/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.pessoa;

import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pessoa.model.Pessoa;
import br.com.system.app.features.pessoa.service.PessoaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

public class PessoaView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final PessoaService pessoaService;
    private Cliente cliente;
    private final ClienteService clienteService;

    @Autowired
    public PessoaView(PessoaService pessoaService, Cliente cliente, ClienteService clienteService) {
        this.pessoaService = pessoaService;
        this.cliente = cliente;
        this.clienteService = clienteService;
        this.create();
    }

    private void create() {
        GridCrud crud = new GridCrud(Pessoa.class);
        crud.setWidth("98%");
        crud.setHeight("93%");
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por nome");
        filter.setClearButtonVisible(true);
        crud.getCrudLayout().addFilterComponent((Component)filter);
        crud.getAddButton().setText("Adicionar");
        crud.getGrid().setColumns(new String[]{"nome", "email", "cpf", "rg", "celular", "telefone2", "nascimento", "papel"});
        crud.getGrid().getColumnByKey("nome").setFlexGrow(0).setWidth("250px");
        crud.getGrid().getColumnByKey("email").setFlexGrow(0).setWidth("180px");
        crud.getCrudFormFactory().setUseBeanValidation(true);
        crud.getCrudFormFactory().setVisibleProperties(new String[]{"nome", "cpf", "rg", "email", "celular", "telefone2", "nascimento", "papel"});
        crud.getCrudFormFactory().setFieldType("email", EmailField.class);
        crud.getCrudFormFactory().setFieldType("nascimento", DatePicker.class);
        crud.getAddButton().setVisible(this.hasPermission("CLIENTE_SAVE"));
        crud.getUpdateButton().setVisible(this.hasPermission("CLIENTE_SAVE"));
        crud.getDeleteButton().setVisible(this.hasPermission("CLIENTE_PESSOA_DELETE"));
        crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> crud.refreshGrid());
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{UIUtils.createHeader((String)"Pessoas da Empresa")});
        this.add(new Component[]{crud});
        HorizontalContainer footer = new HorizontalContainer(new Component[0]).setHorizontalAlign(FlexComponent.JustifyContentMode.END);
        footer.setWidthFull();
        footer.add(new Component[]{btnFechar});
        this.add(new Component[]{footer});
        this.open();
    }
}

