/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.portabilidade.service;

import br.com.system.app.features.portabilidade.model.Operadora;
import br.com.system.app.features.portabilidade.model.Portabilidade;
import br.com.system.app.features.portabilidade.model.PrefixosAnatel;
import br.com.system.app.features.portabilidade.repository.OperadoraRepository;
import br.com.system.app.features.portabilidade.repository.PortabilidadeRepository;
import br.com.system.app.features.portabilidade.repository.PrefixosAnatelRepository;
import br.com.system.app.features.shared.model.OperadoraEnum;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.DateTimeUtil;
import br.com.system.commons.datetime.FormatDate;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PortabilidadeService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(PortabilidadeService.class);
    @Autowired
    private OperadoraRepository operadoraRepository;
    @Autowired
    private PortabilidadeRepository portabilidadeRepository;
    @Autowired
    private PrefixosAnatelRepository prefixosAnatelRepository;

    @Async(value="asyncDefault")
    public void updatePort(String files) {
        Thread.currentThread().setName("asyncDefault-portabilidade-service");
        try {
            this.processarOperadora();
            if (LocalDate.now().getDayOfWeek().equals(DayOfWeek.MONDAY)) {
                this.processarOperadora();
                this.processarPrefixos();
                this.prefixosAnatelRepository.deleteAllNotExists();
            }
            if (files == null) {
                this.processarFile(null);
            } else {
                this.processarFIles(files);
            }
        }
        catch (Exception e) {
            this.logger.error("Portabilidade erro: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processarOperadora() throws IOException {
        String file = "Operadoras.csv";
        try (InputStream inputStream = null;){
            String[] linhas;
            String ftpUrl = "ftp://dlog:1qaz!QAZ@ftp.kingtelecom.com.br/" + file;
            URLConnection urlConnection = new URL(ftpUrl).openConnection();
            inputStream = urlConnection.getInputStream();
            String content = InputStreamUtil.toString((InputStream)inputStream);
            for (String l : linhas = content.split("\n")) {
                try {
                    Operadora operadora;
                    String[] colunas = l.split(";");
                    if (colunas.length != 2) continue;
                    Long csp = StringUtil.toLong((String)colunas[1]);
                    String nome = StringUtil.normalize((String)colunas[0]).trim();
                    if (nome.equals("Prestadora") || nome.isEmpty()) continue;
                    nome = StringUtil.removeLineBreaks((String)nome);
                    Optional optOpe = this.operadoraRepository.findById((Object)csp);
                    if (optOpe.isPresent()) {
                        operadora = (Operadora)optOpe.get();
                    } else {
                        operadora = new Operadora();
                        operadora.setId(csp);
                        operadora.setAbreviacao(OperadoraEnum.OUTRA);
                    }
                    operadora.setNome(nome);
                    operadora.setExiste(Boolean.TRUE);
                    this.operadoraRepository.save((Object)operadora);
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processarPrefixos() throws IOException {
        String file = "prefixos_anatel.csv";
        try (InputStream inputStream = null;){
            String[] linhas;
            String ftpUrl = "ftp://dlog:1qaz!QAZ@ftp.kingtelecom.com.br/" + file;
            URLConnection urlConnection = new URL(ftpUrl).openConnection();
            inputStream = urlConnection.getInputStream();
            String content = InputStreamUtil.toString((InputStream)inputStream);
            this.prefixosAnatelRepository.updateAllExists(Boolean.FALSE);
            for (String l : linhas = content.split("\n")) {
                try {
                    Operadora operadora;
                    String[] colunas = l.split(";");
                    Long prefixo = StringUtil.toLong((String)colunas[0]);
                    Long csp = StringUtil.toLong((String)colunas[1]);
                    Optional optOpe = this.operadoraRepository.findById((Object)csp);
                    if (!optOpe.isPresent() || (operadora = (Operadora)optOpe.get()) == null) continue;
                    PrefixosAnatel pa = this.prefixosAnatelRepository.findByPrefixo(prefixo);
                    if (pa == null) {
                        pa = new PrefixosAnatel();
                        pa.setPrefixo(prefixo);
                    }
                    pa.setOperadora(operadora);
                    pa.setExiste(Boolean.TRUE);
                    this.prefixosAnatelRepository.save((Object)pa);
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage());
                }
            }
        }
    }

    private void processarFIles(String files) throws Exception {
        for (String file : files.split(",")) {
            this.processarFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processarFile(String file) throws Exception {
        if (file == null || ((String)file).isBlank()) {
            file = LocalDate.now().minusDays(1L).format(FormatDate.DATE_BR_YY.toDTF()).replace("/", "") + ".csv";
        }
        String ftpUrl = "ftp://dlog:1qaz!QAZ@ftp.kingtelecom.com.br/incremental/" + (String)file;
        URLConnection urlConnection = new URL(ftpUrl).openConnection();
        try (InputStream inputStream = null;){
            String[] linhas;
            inputStream = urlConnection.getInputStream();
            String content = InputStreamUtil.toString((InputStream)inputStream);
            for (String l : linhas = content.split("\n")) {
                Optional optOperadora;
                if (l.contains("Version") || l.contains("Operacao")) continue;
                String[] colunas = l.split(";");
                Long numero = StringUtil.toLong((String)colunas[1]);
                Long csp = StringUtil.toLong((String)colunas[2]);
                LocalDateTime dataHora = DateTimeUtil.toDateTime((String)colunas[3], (FormatDate)FormatDate.US_DATETIME);
                Integer acao = StringUtil.toInt((String)colunas[4]);
                if (acao != 1 && acao != 0) continue;
                Portabilidade port = this.portabilidadeRepository.findByNumero(numero);
                if (port != null && acao == 0) {
                    this.portabilidadeRepository.delete((Object)port);
                    continue;
                }
                if (acao == 0 && port == null) continue;
                if (port == null) {
                    port = new Portabilidade();
                }
                if (!(optOperadora = this.operadoraRepository.findById((Object)csp)).isPresent()) continue;
                port.setDataHora(dataHora);
                port.setNumero(numero);
                port.setOperadora((Operadora)optOperadora.get());
                this.portabilidadeRepository.save((Object)port);
            }
        }
    }
}

