/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.dashboard.DashBoardBoxTipoEnum;
import br.com.system.app.features.dashboard.DashBoardBoxView;
import br.com.system.app.features.dashboard.dto.DashBoardDTO;
import br.com.system.app.features.estrutura.dto.EstruturaBIDTO;
import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.estrutura.service.EstruturaService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.pedido.service.PedidoService;
import br.com.system.app.features.producaopainel.dto.ProducaoExportacaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoReturnType;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.model.ProducaoPainelBox;
import br.com.system.app.features.producaopainel.model.ProducaoPainelResumo;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelRepository;
import br.com.system.app.features.producaopainel.repository.ProducaoPainelResumoRepository;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ProducaoPainelResumoService {
    @Autowired
    private ProducaoPainelResumoRepository repository;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private ProducaoPainelService pps;
    @Autowired
    private EstruturaService estruturaService;
    @Autowired
    private ProducaoPainelRepository ppr;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private UsuarioHierarquiaService usuarioHierarquiaService;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private EstruturaComplementoService estruturaComplementoService;

    @Async(value="asyncDefault")
    public void getDetalhamento(EstruturaUsuario eu, ProducaoPainelBox box, DashBoardBoxView boxView, String mesAno, Consumer<DashBoardDTO> listener) {
        mesAno = mesAno.replace("-", "");
        Set hierarquia = this.usuarioHierarquiaService.getHierarquia(eu);
        DashBoardDTO dto = new DashBoardDTO();
        dto.setBox(box);
        dto.setBoxView(boxView);
        dto.setDetalhamento(this.repository.getDetalhamento(eu, box, hierarquia, mesAno));
        listener.accept(dto);
    }

    @Async(value="asyncDefault")
    public void getResumo(EstruturaUsuario eu, ProducaoPainelBox box, DashBoardBoxView boxView, String mesAno, Consumer<DashBoardDTO> listener) {
        DashBoardDTO dto = new DashBoardDTO();
        dto.setBox(box);
        dto.setBoxView(boxView);
        List resumo = null;
        mesAno = mesAno.replace("-", "");
        Set hierarquia = this.usuarioHierarquiaService.getHierarquia(eu);
        if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.NORMAL)) {
            resumo = this.repository.getResumo(eu, box, hierarquia, mesAno);
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.CONTAGEM_CONSULTOR)) {
            resumo = this.repository.getByConsultor(eu, box, hierarquia, mesAno);
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.RANKING)) {
            resumo = this.repository.getRanking(eu, box, hierarquia, mesAno);
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.GRAFICO_GRUPO)) {
            resumo = this.repository.getGraficoGrupo(eu, box, hierarquia, mesAno);
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.GRAFICO_FILA)) {
            resumo = this.repository.getGraficoFila(eu, box, hierarquia, mesAno);
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.GRAFICO_ANUAL)) {
            resumo = this.repository.getGraficoAnual(eu, box, hierarquia, mesAno);
        } else if (box.getTipo().equals((Object)DashBoardBoxTipoEnum.CONTAGEM_CNPJ)) {
            resumo = this.repository.getByCnpj(eu, box, hierarquia, mesAno);
        }
        dto.setResumo(resumo);
        listener.accept(dto);
    }

    @Async(value="asyncDefault")
    public void atualizar(EstruturaUsuario euContext, LocalDateTime dataIni, LocalDateTime dataFim, Estrutura e) {
        if (dataIni == null) {
            dataIni = LocalDateTime.now().minusHours(3L);
        }
        if (dataFim == null) {
            dataFim = LocalDateTime.now();
        }
        List forBI = this.estruturaService.getForBI();
        StringBuilder log = new StringBuilder("iniciado " + String.valueOf(LocalDateTime.now())).append("<BR>");
        int qtEstrutura = 0;
        for (EstruturaBIDTO bi : forBI) {
            ++qtEstrutura;
            try {
                if (e != null && !e.getId().equals(bi.getId())) continue;
                EstruturaUsuario eu = this.eus.getMasterEstrutura(this.estruturaService.getById(bi.getId()));
                EstruturaComplemento complemento = this.estruturaComplementoService.getComplementos(eu.getEstrutura());
                ProducaoPainel painel = this.pps.getById(bi.getPainelId());
                log.append("atualizando ").append(qtEstrutura).append(" de ").append(forBI.size()).append(" ").append(eu.getEstrutura().getNome());
                List lista = this.ppr.getProducaoExportacao(eu, painel, null, null, null, null, null, ProducaoReturnType.EXPORTACAO, dataIni, dataFim, Boolean.valueOf(false));
                log.append(" total lista: ").append(lista.size());
                Set pedidos = this.pedidoService.getByEstruturaAndDataHoraAtualizacaoBetween(eu.getEstrutura(), dataIni, dataFim);
                this.delete(pedidos);
                log.append(" pedidos deletados");
                ArrayList<ProducaoPainelResumo> listaPpr = new ArrayList<ProducaoPainelResumo>();
                int ind = 0;
                for (ProducaoExportacaoDTO p : lista) {
                    ++ind;
                    ProducaoPainelResumo resumo = new ProducaoPainelResumo();
                    resumo.setCidade(p.getCidade());
                    resumo.setCpfCnpj(p.getCpfCnpj());
                    resumo.setDataAtualizacao(p.getDataReferencia().atStartOfDay());
                    resumo.setEquipe(p.getNomeEquipe());
                    resumo.setEstado(p.getEstado());
                    resumo.setEstruturaUsuarioId(p.getEstruturaUsuarioId());
                    resumo.setFila(p.getNomeColuna());
                    resumo.setGrupo(p.getNomeLinha());
                    resumo.setMesAno(p.getDataReferencia().format(DateTimeFormatter.ofPattern("YYYYMM")));
                    resumo.setNomeCliente(p.getNomeCliente());
                    resumo.setNumero(p.getNumeroPedido());
                    resumo.setPedidoId(p.getPedidoId());
                    resumo.setProducaoColunasId(p.getColunaId());
                    resumo.setProducaoLinhasId(p.getLinhaId());
                    if (p.getSomaQuantidade().booleanValue()) {
                        resumo.setQuantidade(p.getQuantidade());
                    } else {
                        resumo.setQuantidade(Integer.valueOf(0));
                    }
                    resumo.setValor(Double.valueOf(p.getValor().doubleValue()));
                    resumo.setLoginUsuario(p.getLoginUsuario());
                    resumo.setEquipeId(p.getEquipeId());
                    listaPpr.add(resumo);
                }
                log.append(" ").append(ind).append(" atualizados").append("<BR>");
                complemento.setDataHoraAtualizacaoDashboard(LocalDateTime.now());
                this.estruturaComplementoService.save(complemento);
                if (!listaPpr.isEmpty()) {
                    this.repository.saveAll(listaPpr);
                }
                this.notificacoesService.notify(euContext == null ? eu : euContext, "Atualizacao Dashboard", "Finalizada com sucesso");
                log.append(" finalizado e notificado<BR>");
            }
            catch (Exception ex) {
                log.append(" erro: " + ex.getMessage());
            }
        }
        log.append("Finalizado " + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
    }

    public void delete(Set<Long> pedidoId) {
        this.repository.deleteByPedidoIdIn(pedidoId);
    }
}

