/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.service;

import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoProdutos;
import br.com.system.app.features.producaopainel.repository.ProducaoProdutosRepository;
import br.com.system.app.features.produto.model.Produto;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProducaoProdutosService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ProducaoProdutosRepository producaoProdutosRepository;

    public List<ProducaoProdutos> getProdutos(ProducaoLinhas pl, String nome, Pageable pageable) {
        if (nome != null && !nome.isEmpty()) {
            return this.producaoProdutosRepository.findByProducaoLinhasAndProdutoNomeContains(pl, nome, pageable);
        }
        return this.producaoProdutosRepository.findByProducaoLinhas(pl, pageable);
    }

    public long countProdutos(ProducaoLinhas pl, String nome) {
        if (nome != null && !nome.isEmpty()) {
            return this.producaoProdutosRepository.countByProducaoLinhasAndProdutoNomeContains(pl, nome);
        }
        return this.producaoProdutosRepository.countByProducaoLinhas(pl);
    }

    public ProducaoProdutos getByProducaoLinhaAndProduto(ProducaoLinhas pl, Produto p) {
        return this.producaoProdutosRepository.findByProducaoLinhasAndProduto(pl, p);
    }

    public ProducaoProdutos save(ProducaoProdutos pp) {
        return (ProducaoProdutos)this.producaoProdutosRepository.save((Object)pp);
    }

    public List<ProducaoProdutos> getByProducaoLinhas(ProducaoLinhas pl) {
        return this.producaoProdutosRepository.findByProducaoLinhas(pl);
    }

    public void deleteByProducaoLinhas(ProducaoLinhas pl) {
        this.producaoProdutosRepository.deleteByProducaoLinhas(pl);
    }

    public void delete(ProducaoProdutos pp) {
        this.producaoProdutosRepository.delete((Object)pp);
    }
}

