/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.cadastro;

import br.com.system.app.components.MultiComboBox;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.PedidoItemSolicitacao;
import br.com.system.app.features.pedido.repository.PedidoItemSolicitacaoRepository;
import br.com.system.app.features.producaopainel.model.ProducaoLinhas;
import br.com.system.app.features.producaopainel.model.ProducaoTipoSolicitacao;
import br.com.system.app.features.producaopainel.repository.ProducaoTipoSolicitacaoRepository;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ProducaoSolicitacaoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final EstruturaUsuario eu;
    private final ProducaoLinhas linha;
    private final ProducaoTipoSolicitacaoRepository ptsr;
    private final PedidoItemSolicitacaoRepository pisr;

    public ProducaoSolicitacaoView(EstruturaUsuario eu, ProducaoLinhas linha, ProducaoTipoSolicitacaoRepository ptsr, PedidoItemSolicitacaoRepository pisr) {
        this.eu = eu;
        this.linha = linha;
        this.ptsr = ptsr;
        this.pisr = pisr;
        this.createContent();
    }

    private void createContent() {
        if (this.linha == null) {
            UIUtils.showNotification((String)"Linha esta nula");
            return;
        }
        this.setWidth("600px");
        this.setHeight("650px");
        MultiComboBox cbSol = new MultiComboBox("Solicita\u00e7\u00e3o", (Collection)this.pisr.findByEstruturaTipoAndAtivo(this.eu.getEstrutura().getEstruturaTipo(), Boolean.valueOf(true)));
        cbSol.setItemLabelGenerator(PedidoItemSolicitacao::getNome);
        List listaSol = this.ptsr.findByProducaoLinhasAndPedidoItemSolicitacaoNomeContains(this.linha, "", null);
        if (listaSol.size() > 0) {
            HashSet<PedidoItemSolicitacao> value = new HashSet<PedidoItemSolicitacao>();
            for (ProducaoTipoSolicitacao pts : listaSol) {
                value.add(pts.getPedidoItemSolicitacao());
            }
            cbSol.setValue(value);
        }
        Button salvar = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.INBOX, (String)"Salvar registro");
        salvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbSol.getValue() == null || cbSol.getValue().size() <= 0) {
                UIUtils.showNotification((String)"Selecione pelo menos uma solicitacao");
                return;
            }
            this.ptsr.deleteByProducaoLinhas(this.linha);
            for (PedidoItemSolicitacao pis : cbSol.getValue()) {
                ProducaoTipoSolicitacao pts = new ProducaoTipoSolicitacao();
                pts.setPedidoItemSolicitacao(pis);
                pts.setProducaoLinhas(this.linha);
                this.ptsr.save((Object)pts);
            }
            UIUtils.showNotification((String)"Atualizado com sucesso");
            this.close();
        });
        Button close = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        close.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new VerticalContainer(new Component[]{cbSol, new HorizontalContainer(new Component[]{close, salvar})})});
    }
}

