/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.producaopainel.views.painel;

import br.com.system.app.MainLayout;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.ProgressBar;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaSenhasService;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.producaopainel.dto.ProducaoDTO;
import br.com.system.app.features.producaopainel.dto.ProducaoReturnType;
import br.com.system.app.features.producaopainel.model.ProducaoPainel;
import br.com.system.app.features.producaopainel.service.ProducaoPainelService;
import br.com.system.app.features.producaopainel.views.ProducaoPainelFilter;
import br.com.system.app.features.producaopainel.views.painel.ProducaoPainelBoxProduto;
import br.com.system.app.features.producaopainel.views.painel.ProducaoPainelBoxStatus;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="painel-producao", layout=MainLayout.class)
@PageTitle(value="Painel de Produ\u00e7\u00e3o")
@RolesAllowed(value={"PAINEL_PRODUCAO_VIEW"})
public class ProducaoPainelView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ProducaoPainelService pps;
    private final ProducaoPainelFilter filterModule;
    private final EquipeService es;
    private final ProgressBar progressBar;
    private VerticalContainer containerDados;
    private HorizontalContainer filterCard;
    private DownloadDialog dd;

    @Autowired
    public ProducaoPainelView(ProducaoPainelService pps, EquipeService es, EstruturaSenhasService ess, UsuarioHierarquiaService hierarquiaService) {
        this.pps = pps;
        this.es = es;
        this.filterModule = new ProducaoPainelFilter(pps, this.es, ess, this.getEu(), hierarquiaService);
        this.progressBar = new ProgressBar(Boolean.TRUE);
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent(this.createContent());
        }
    }

    private Component createContent() {
        this.dd = new DownloadDialog();
        Button btn = UIUtils.createSmallButton((String)"Esconder Filtro", (String)"");
        btn.addClickListener((ComponentEventListener & Serializable)e -> {
            if (btn.getText().equals("Esconder Filtro")) {
                btn.setText("Mostrar Filtro");
                this.filterCard.setVisible(false);
            } else {
                btn.setText("Esconder Filtro");
                this.filterCard.setVisible(true);
            }
        });
        this.filterCard = this.filterModule.createContent();
        FlexBoxLayout mainConteiner = new FlexBoxLayout(FlexLayout.FlexDirection.COLUMN, new Component[0]);
        mainConteiner.setSpacingS();
        mainConteiner.add(new Component[]{this.filterCard});
        mainConteiner.add(new Component[]{btn});
        this.containerDados = new VerticalContainer(new Component[0]);
        this.containerDados.setSpacingOn().setPaddingOn();
        this.filterModule.getBtnPesquisar().addClickListener((ComponentEventListener & Serializable)e -> this.povoa());
        mainConteiner.add(new Component[]{this.containerDados});
        return mainConteiner;
    }

    private void povoa() {
        this.filterModule.getBtnPesquisar().setEnabled(true);
        long diff = ChronoUnit.MONTHS.between((Temporal)this.filterModule.getDataInicial().getValue(), (Temporal)this.filterModule.getDataFinal().getValue());
        if (diff > 3L) {
            this.showNotification("M\u00e1ximo de 3 M\u00eases");
            return;
        }
        if (this.filterModule.getCbPainel().getValue() == null) {
            UIUtils.showNotification((String)"Selecione um painel.");
            return;
        }
        if (((ProducaoReturnType)this.filterModule.getRbg().getValue()).equals((Object)ProducaoReturnType.EXPORTACAO)) {
            if (this.hasPermission("PAINEL_PRODUCAO_EXPORTACAO")) {
                this.montarExportacao();
            } else {
                this.showNotification("Voc\u00ea n\u00e3o tem permiss\u00e3o para exportar o painel");
            }
        } else {
            this.montarPainel();
        }
    }

    private void montarExportacao() {
        this.progressBar.setText("Buscando dados, por favor aguarde...").open();
        this.pps.getDadosExportacao((ProducaoPainel)this.filterModule.getCbPainel().getValue(), ((LocalDate)this.filterModule.getDataInicial().getValue()).format(DateTimeFormatter.ISO_DATE), ((LocalDate)this.filterModule.getDataFinal().getValue()).format(DateTimeFormatter.ISO_DATE), (ProducaoReturnType)this.filterModule.getRbg().getValue(), (HierarquiaDTO)this.filterModule.getCbUsuarioFilter().getValue(), this.filterModule.getCbEquipe().getValue(), this.filterModule.getCbSenhas().getValue(), this.getEu(), Boolean.valueOf(this.hasPermission("IGNORAR_HIERARQUIA")), arg_0 -> this.listenerExportacao(arg_0));
    }

    public void listenerExportacao(String hash) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.dd.open(hash, "ExportacaoProducao.xlsx", true);
            this.progressBar.close();
        });
    }

    private void montarPainel() {
        try {
            this.progressBar.setText("Buscando dados, por favor aguarde...").open();
            this.containerDados.removeAll();
            this.pps.getDados((ProducaoPainel)this.filterModule.getCbPainel().getValue(), ((LocalDate)this.filterModule.getDataInicial().getValue()).format(DateTimeFormatter.ISO_DATE), ((LocalDate)this.filterModule.getDataFinal().getValue()).format(DateTimeFormatter.ISO_DATE), (ProducaoReturnType)this.filterModule.getRbg().getValue(), (HierarquiaDTO)this.filterModule.getCbUsuarioFilter().getValue(), this.filterModule.getCbEquipe().getValue(), this.filterModule.getCbSenhas().getValue(), this.getEu(), Boolean.valueOf(this.hasPermission("IGNORAR_HIERARQUIA")), arg_0 -> this.listenerPainel(arg_0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void listenerPainel(List<ProducaoDTO> lista) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> {
            this.progressBar.close();
            try {
                String produtoAnterior = "";
                FlexBoxLayout layoutProduto = null;
                for (ProducaoDTO prod : lista) {
                    if (prod.getNomeLinha() == null) {
                        prod.setNomeLinha("N\u00c3O DEFINIDO");
                    }
                    if (produtoAnterior.isEmpty() || !produtoAnterior.equals(prod.getNomeLinha())) {
                        layoutProduto = new FlexBoxLayout(FlexLayout.FlexDirection.ROW, new Component[0]);
                        layoutProduto.setFlexWrap(FlexLayout.FlexWrap.WRAP);
                        produtoAnterior = prod.getNomeLinha();
                        this.containerDados.add(new Component[]{new ProducaoPainelBoxProduto().getBoxProduto(prod)});
                        this.containerDados.add(new Component[]{layoutProduto});
                    }
                    if (layoutProduto == null) continue;
                    layoutProduto.add(new Component[]{new ProducaoPainelBoxStatus().boxStatus(prod)});
                }
            }
            catch (Exception e) {
                UIUtils.showNotification((String)("Erro: " + e.getMessage()));
            }
        });
    }
}

