/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.produto.repository;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaTipo;
import br.com.system.app.features.produto.model.Produto;
import br.com.system.app.features.produto.model.ProdutoCategoria;
import br.com.system.app.features.produto.model.ProdutoOrigem;
import br.com.system.app.features.produto.repository.ProdutoRepositoryQuery;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface ProdutoRepository
extends JpaRepository<Produto, Long>,
JpaSpecificationExecutor<Produto>,
ProdutoRepositoryQuery {
    @Query(nativeQuery=true, value="SELECT * from produto where find_in_set(id,:listaId)")
    public List<Produto> findByListaId(String var1);

    public Page<Produto> findByNomeContains(String var1, Pageable var2);

    public long countByNomeContains(String var1);

    public List<Produto> findByEstruturaTipoAndOrigemAndQuantosMegasGreaterThanEqualAndAtivoOrderByQuantosMegas(EstruturaTipo var1, ProdutoOrigem var2, BigDecimal var3, Boolean var4);

    public List<Produto> findByEstruturaTipoAndOrigemAndCompromissoMensalAndAtivoOrderByNome(EstruturaTipo var1, ProdutoOrigem var2, Boolean var3, Boolean var4);

    public List<Produto> findByEstruturaTipoAndNomeAndOrigem(EstruturaTipo var1, String var2, ProdutoOrigem var3);

    public List<Produto> findByEstruturaTipoAndNome(EstruturaTipo var1, String var2);

    public List<Produto> findByEstruturaTipoAndNomeContainsAndCategoriaAndAtivo(EstruturaTipo var1, String var2, ProdutoCategoria var3, Boolean var4, Pageable var5);

    public long countByEstruturaTipoAndNomeContainsAndCategoriaAndAtivo(EstruturaTipo var1, String var2, ProdutoCategoria var3, Boolean var4);

    public List<Produto> findByEstruturaTipo(EstruturaTipo var1);

    public List<Produto> findByEstrutura(Estrutura var1);

    public List<Produto> findByEstruturaTipoAndOrigemAndCategoriaAndAtivo(EstruturaTipo var1, ProdutoOrigem var2, ProdutoCategoria var3, Boolean var4);

    public List<Produto> findByEstruturaAndOrigemAndCategoriaAndAtivo(Estrutura var1, ProdutoOrigem var2, ProdutoCategoria var3, Boolean var4);

    public List<Produto> findByEstruturaTipoAndCategoria(EstruturaTipo var1, ProdutoCategoria var2);

    public List<Produto> findByEstruturaAndCategoria(Estrutura var1, ProdutoCategoria var2);

    public List<Produto> findByEstruturaTipoAndOrigem(EstruturaTipo var1, ProdutoOrigem var2);

    public List<Produto> findByEstruturaTipoAndOrigemAndAtivo(EstruturaTipo var1, ProdutoOrigem var2, Boolean var3);

    public List<Produto> findByEstruturaAndOrigemAndAtivo(Estrutura var1, ProdutoOrigem var2, Boolean var3);

    @Query(nativeQuery=true, value="select nome from produto WHERE estrutura_tipo_id=:estruturaTipoId group by estrutura_tipo_id,nome having count(*) >1")
    public List<String> findDuplicados(@Param(value="estruturaTipoId") Long var1);

    @Modifying
    @Query(nativeQuery=true, value="update pedido_item set produto_id=:produtoId where produto_id=:produtoIdDel")
    public void updatePedidos(@Param(value="produtoId") Long var1, @Param(value="produtoIdDel") Long var2);

    @Modifying
    @Query(nativeQuery=true, value="delete from producao_produtos where produto_id=:produtoIdDel")
    public void updatePainel(@Param(value="produtoIdDel") Long var1);

    @Modifying
    @Transactional
    public void deleteByEstrutura(Estrutura var1);
}

