/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sac.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.sac.model.SacTipo;
import br.com.system.app.features.sac.repository.SacTipoRepository;
import br.com.system.app.features.shared.exception.ResourceNotFoundException;
import java.io.Serializable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SacTipoService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SacTipoRepository sacTipoRepository;

    public SacTipo salvar(SacTipo tipo) {
        SacTipo sacTipoSalvo = this.sacTipoRepository.findById((Object)tipo.getId()).orElse(null);
        BeanUtils.copyProperties((Object)tipo, (Object)sacTipoSalvo, (String[])new String[]{"id"});
        return (SacTipo)this.sacTipoRepository.save((Object)sacTipoSalvo);
    }

    public SacTipo buscarPeloId(Long id) {
        SacTipo tipo = this.sacTipoRepository.findById((Object)id).orElse(null);
        if (tipo == null) {
            throw new ResourceNotFoundException();
        }
        return tipo;
    }

    public Page<SacTipo> buscarPorEstrutura(Pageable pageable, Estrutura estrutura) {
        return this.sacTipoRepository.findByEstruturaId(estrutura.getId(), pageable);
    }
}

