/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.serasa;

import br.com.system.app.MainLayout;
import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.creditos.CreditosCompraView;
import br.com.system.app.features.creditos.CreditosExtratoView;
import br.com.system.app.features.creditos.CreditosTransferView;
import br.com.system.app.features.creditos.service.CreditosService;
import br.com.system.app.features.enriquecimento.service.EnriquecimentoService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.serasa.model.Serasa;
import br.com.system.app.features.serasa.report.SerasaReport;
import br.com.system.app.features.serasa.service.SerasaService;
import br.com.system.app.features.usuario.service.UsuarioHierarquiaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.PermitAll;
import java.io.Serializable;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.crudui.crud.CrudListener;
import org.vaadin.crudui.crud.impl.GridCrud;

@Route(value="consulta-credito", layout=MainLayout.class)
@PageTitle(value="Consulta de cr\u00e9dito")
@PermitAll
public class SerasaView
extends VerticalLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final SerasaService serasaService;
    private final UsuarioService usuarioService;
    private final CreditosService creditosService;
    private final CreditosCompraView ccv;
    private final EstruturaUsuarioService eus;
    private final UsuarioHierarquiaService hierarquiaService;
    private TextField saldo;
    private GridCrud<Serasa> crud;

    @Autowired
    public SerasaView(EnriquecimentoService enriquecimentoService, UsuarioService usuarioService, CreditosService creditosService, SerasaService serasaService, EstruturaUsuarioService eus, CreditosCompraView ccv, UsuarioHierarquiaService hierarquiaService) {
        this.serasaService = serasaService;
        this.hierarquiaService = hierarquiaService;
        this.eus = eus;
        this.ccv = ccv;
        this.creditosService = creditosService;
        this.usuarioService = usuarioService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.autenticado()) {
            this.add(new Component[]{this.createContent()});
        } else {
            UIUtils.showNotification((String)"Sem permiss\u00e3o");
        }
    }

    private Component createContent() {
        this.setSpacing(true);
        this.setPadding(true);
        this.saldo = new TextField("Seus cr\u00e9ditos");
        this.saldo.setReadOnly(true);
        Button btnAtualizarSaldo = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.REFRESH, (String)"Atualizar Saldo");
        btnAtualizarSaldo.addClickListener((ComponentEventListener & Serializable)e -> this.atualizarSaldo());
        Button btnExtrato = UIUtils.createSmallButton((String)"Extrato");
        btnExtrato.addClickListener((ComponentEventListener & Serializable)e -> {
            CreditosExtratoView cv = new CreditosExtratoView(this.creditosService);
            cv.create();
            cv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                cv.close();
                this.atualizarSaldo();
            });
        });
        Button btnComprarCreditos = UIUtils.createSmallButton((String)"Comprar Cr\u00e9ditos");
        btnComprarCreditos.addClickListener((ComponentEventListener & Serializable)e -> {
            this.ccv.create(this.getEu());
            this.ccv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                this.ccv.close();
                this.atualizarSaldo();
            });
        });
        Button btnTransferir = UIUtils.createSmallButton((String)"Transferir Cr\u00e9ditos");
        btnTransferir.addClickListener((ComponentEventListener & Serializable)e -> {
            CreditosTransferView ctv = new CreditosTransferView(this.getEu(), this.creditosService, this.eus, this.hierarquiaService);
            ctv.create();
            ctv.getCloseButton().addClickListener((ComponentEventListener & Serializable)close -> {
                ctv.close();
                this.atualizarSaldo();
            });
        });
        ListField txtCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "CPF/CNPJ");
        Checkbox cbProtesto = new Checkbox("Com Protesto");
        cbProtesto.setValue((Object)Boolean.TRUE);
        Button btnConsultar = UIUtils.createSmallButton((String)"Consultar");
        btnConsultar.setDisableOnClick(true);
        btnConsultar.addClickListener((ComponentEventListener & Serializable)e -> {
            btnConsultar.setEnabled(true);
            if (txtCnpj.getValue() == null) {
                UIUtils.showNotification((String)"Informe pelo menos 1 CPF ou CNPJ");
                return;
            }
            ConfirmationDialog cd = new ConfirmationDialog("Consulta de cr\u00e9dito", "Confirma a consulta de cr\u00e9dito " + ((Boolean)cbProtesto.getValue() != false ? " com protesto?" : " sem protesto?"));
            cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
            cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                StringBuilder log = new StringBuilder();
                for (String cnpj : txtCnpj.getValue()) {
                    try {
                        Serasa serasa = this.serasaService.executaConsulta(cnpj, (Boolean)cbProtesto.getValue(), this.getEu());
                        log.append(cnpj).append(" ").append(serasa.isTemRestricao() ? " COM RESTRI\u00c7\u00c3O " : " SEM RESTRI\u00c7\u00c3O ").append("<BR>");
                    }
                    catch (Exception ex) {
                        log.append(cnpj).append(" ERRO: ").append(ex.getMessage()).append("<BR>");
                    }
                }
                UIUtils.showNotification((String)log.toString());
                this.crud.refreshGrid();
                cd.close();
                log = null;
                this.atualizarSaldo();
            });
        });
        VerticalLayout v = new VerticalLayout();
        v.add(new Component[]{UIUtils.createHeader((String)"Consulta de Cr\u00e9dito")});
        v.add(new Component[]{new HorizontalLayout(new Component[]{this.saldo, btnAtualizarSaldo, btnExtrato, btnComprarCreditos, btnTransferir})});
        v.add(new Component[]{new HorizontalLayout(new Component[]{txtCnpj, cbProtesto, btnConsultar})});
        HorizontalLayout cg = new HorizontalLayout(new Component[]{this.getGrid()});
        cg.setSizeFull();
        v.add(new Component[]{cg});
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{v});
        this.atualizarSaldo();
        return v;
    }

    private GridCrud<Serasa> getGrid() {
        this.crud = new GridCrud(Serasa.class);
        this.crud.setWidthFull();
        this.crud.getGrid().setColumns(new String[0]);
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCliente().getCpfCnpj())).setHeader("CPF/CNPJ").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getCliente().getNome()))).setHeader("Nome").setFlexGrow(0).setWidth("350px");
        this.crud.getGrid().addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setHeader("Data/Hora").setFlexGrow(0).setWidth("180px");
        this.crud.getGrid().addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Button btn = UIUtils.createSmallButton((String)"Abrir");
            if (p.isTemRestricao()) {
                UIUtils.setBackgroundColor((Color)Color.RED, (Component[])new Component[]{btn});
                UIUtils.setTextColor((String)"#FFFFFF", (Component[])new Component[]{btn});
            } else {
                UIUtils.setBackgroundColor((Color)Color.GREEN, (Component[])new Component[]{btn});
                UIUtils.setTextColor((String)"#00FF00", (Component[])new Component[]{btn});
            }
            btn.addClickListener((ComponentEventListener & Serializable)e -> {
                SerasaReport report = new SerasaReport(p);
                String url = report.getPDF();
                if (url.isBlank()) {
                    UIUtils.showNotification((String)"Erro ao criar PDF");
                    return;
                }
                try {
                    Dialog dialog = new Dialog();
                    Button btnClose = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
                    btnClose.addClickListener((ComponentEventListener & Serializable)close -> dialog.close());
                    Anchor anchor = new Anchor(url, new Component[0]);
                    anchor.getElement().setAttribute("download", true);
                    anchor.setTarget("_blank");
                    anchor.setText("Abrir PDF");
                    anchor.setTitle("Abrir PDF da consulta de cr\u00e9dito");
                    anchor.setVisible(!url.isEmpty());
                    VerticalContainer v = new VerticalContainer(new Component[0]);
                    v.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
                    v.add(new Component[]{UIUtils.createHeader((String)"Arquivo gerado com sucesso")});
                    v.add(new Component[]{anchor, btnClose});
                    dialog.add(new Component[]{v});
                    dialog.open();
                }
                catch (Exception ex) {
                    UIUtils.showNotification((String)ex.getMessage());
                }
            });
            return btn;
        })).setHeader("Restri\u00e7\u00e3o").setFlexGrow(0).setWidth("300px");
        TextField filter = new TextField();
        filter.setPlaceholder("Filtrar por cpf/cnpj");
        filter.setClearButtonVisible(true);
        this.crud.getAddButton().setVisible(false);
        this.crud.getUpdateButton().setVisible(false);
        this.crud.getDeleteButton().setVisible(false);
        this.crud.getCrudLayout().addFilterComponent((Component)filter);
        this.crud.setCrudListener((CrudListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.crud;
    }

    private void atualizarSaldo() {
        BigDecimal saldoUsuario = this.usuarioService.getCreditos(this.getEu().getUsuario());
        if (saldoUsuario == null) {
            saldoUsuario = BigDecimal.ZERO;
        }
        this.saldo.setValue("R$ " + saldoUsuario.toString());
    }
}

