/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.serasa.report;

import br.com.system.app.features.serasa.dto.SerasaChequeDTO;
import br.com.system.app.features.serasa.dto.SerasaPendenciaDTO;
import br.com.system.app.features.serasa.dto.SerasaProtestoDTO;
import br.com.system.app.features.serasa.model.Serasa;
import br.com.system.app.features.serasa.service.SerasaHandler;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.commons.HashUtil;
import br.com.system.commons.datetime.FormatDate;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;
import org.apache.http.entity.ContentType;

public class SerasaReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Serasa serasa;
    private final Font mainFont = new Font(Font.FontFamily.COURIER, 11.0f);
    private final Font cabTableFont;
    private final Font cabFont = new Font(Font.FontFamily.COURIER, 11.0f, 1);
    private final SerasaHandler handler;

    public SerasaReport(Serasa serasa) {
        this.cabTableFont = new Font(Font.FontFamily.COURIER, 11.0f, 1);
        this.handler = new SerasaHandler(serasa);
        this.serasa = serasa;
    }

    public String getPDF() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Document document = new Document();
            document.setMargins(Float.valueOf("0.5").floatValue(), Float.valueOf("0.5").floatValue(), Float.valueOf("0.5").floatValue(), Float.valueOf("0.5").floatValue());
            document.setPageSize(PageSize.A4.rotate());
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            document.addTitle("Consulta cr\u00e9dito cliente " + this.serasa.getCliente().getNome());
            this.setCabecalho(document);
            this.setPendencias(document);
            this.setProtestos(document);
            this.setCheques(document);
            document.close();
            String obj = StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".pdf"), (String)ContentType.MULTIPART_FORM_DATA.toString(), (byte[])out.toByteArray());
            String string = StorageUtil.getUrlSign((String)obj, (String)"bucket-neosales").getUrl();
            return string;
        }
        catch (Exception e) {
            throw new BusinessException("Erro ao gerar PDF " + e.getMessage());
        }
    }

    private void setCheques(Document pdf) throws Exception {
        this.setCabTable(pdf, "Cheques Sem Fundos");
        Set cheques = this.handler.getCheques();
        PdfPTable tableCab = new PdfPTable(5);
        tableCab.addCell(this.getCabCell("Banco"));
        tableCab.addCell(this.getCabCell("Agencia"));
        tableCab.addCell(this.getCabCell("Quantidade"));
        tableCab.addCell(this.getCabCell("Data"));
        tableCab.addCell(this.getCabCell("Motivo"));
        pdf.add((Element)tableCab);
        if (cheques.size() <= 0) {
            PdfPTable tableRow = new PdfPTable(1);
            tableRow.addCell(new PdfPCell(new Phrase("Nada Consta", this.mainFont)));
            pdf.add((Element)tableRow);
            return;
        }
        for (SerasaChequeDTO cheque : cheques) {
            PdfPTable tableRow = new PdfPTable(5);
            tableRow.addCell(new PdfPCell(new Phrase(cheque.getBanco(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(cheque.getAgencia(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(cheque.getQuantidade().toString(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(cheque.getData(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(cheque.getMotivo(), this.mainFont)));
            pdf.add((Element)tableRow);
        }
    }

    private void setProtestos(Document pdf) throws Exception {
        this.setCabTable(pdf, "Protestos");
        Set protestos = this.handler.getProtestos();
        PdfPTable tableCab = new PdfPTable(3);
        tableCab.addCell(this.getCabCell("Cart\u00f3rio"));
        tableCab.addCell(this.getCabCell("Data"));
        tableCab.addCell(this.getCabCell("Valor"));
        pdf.add((Element)tableCab);
        if (protestos.size() <= 0) {
            PdfPTable tableRow = new PdfPTable(1);
            tableRow.addCell(new PdfPCell(new Phrase("Nada Consta", this.mainFont)));
            pdf.add((Element)tableRow);
            return;
        }
        for (SerasaProtestoDTO protesto : protestos) {
            PdfPTable tableRow = new PdfPTable(3);
            tableRow.addCell(new PdfPCell(new Phrase(protesto.getCartorio(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(protesto.getDataProtesto(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase("R$ " + protesto.getValor(), this.mainFont)));
            pdf.add((Element)tableRow);
        }
    }

    private void setPendencias(Document pdf) throws Exception {
        this.setCabTable(pdf, "Pend\u00eancias Financeiras");
        Set pendencias = this.handler.getPendencias();
        pendencias.addAll(this.handler.getSpc());
        PdfPTable tableCab = new PdfPTable(5);
        tableCab.addCell(this.getCabCell("Contrato"));
        tableCab.addCell(this.getCabCell("Data"));
        tableCab.addCell(this.getCabCell("Origem"));
        tableCab.addCell(this.getCabCell("Titulo"));
        tableCab.addCell(this.getCabCell("Valor"));
        pdf.add((Element)tableCab);
        if (pendencias.size() <= 0) {
            PdfPTable tableRow = new PdfPTable(1);
            tableRow.addCell(new PdfPCell(new Phrase("Nada Consta", this.mainFont)));
            pdf.add((Element)tableRow);
            return;
        }
        for (SerasaPendenciaDTO pend : pendencias) {
            PdfPTable tableRow = new PdfPTable(5);
            tableRow.addCell(new PdfPCell(new Phrase(pend.getContrato(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(pend.getDataOcorrencia(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(pend.getOrigem(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase(pend.getTitulo(), this.mainFont)));
            tableRow.addCell(new PdfPCell(new Phrase("R$ " + pend.getValor(), this.mainFont)));
            pdf.add((Element)tableRow);
        }
    }

    private void setCabecalho(Document pdf) throws Exception {
        PdfPCell cell;
        Font fontBlue = new Font(Font.FontFamily.COURIER, 11.0f, 1);
        fontBlue.setColor(BaseColor.BLUE);
        Font fontGray = new Font(Font.FontFamily.COURIER, 11.0f, 1);
        fontGray.setColor(BaseColor.GRAY);
        Paragraph p1 = new Paragraph("Relat\u00f3rio de Cr\u00e9dito gerado em " + LocalDateTime.now().format(FormatDate.DATETIME_BR.toDTF()), this.cabFont);
        p1.setAlignment(1);
        Paragraph p2 = new Paragraph(this.serasa.getCliente().getCpfCnpj(), fontGray);
        p2.setAlignment(1);
        Paragraph p3 = new Paragraph(this.serasa.getCliente().getNome(), fontBlue);
        p3.setAlignment(1);
        p3.setSpacingAfter(20.0f);
        pdf.add((Element)p1);
        pdf.add((Element)p2);
        pdf.add((Element)p3);
        PdfPTable t = new PdfPTable(1);
        Font font = new Font(Font.FontFamily.COURIER, 11.0f, 1);
        font.setColor(BaseColor.WHITE);
        if (this.serasa.isTemRestricao()) {
            cell = new PdfPCell(new Phrase("**** CONSTAM OCORR\u00caNCIAS PARA O DOCUMENTO CONSULTADO ****", font));
            cell.setHorizontalAlignment(1);
            cell.setBackgroundColor(BaseColor.RED);
            cell.setBorder(0);
        } else {
            cell = new PdfPCell(new Phrase("**** NADA CONSTA PARA O DOCUMENTO CONSULTADO ****", font));
            BaseColor myColor = this.hexToBaseColor("#1AA026");
            cell.setHorizontalAlignment(1);
            cell.setBackgroundColor(myColor);
            cell.setBorder(0);
        }
        t.addCell(cell);
        pdf.add((Element)t);
    }

    private void setCabTable(Document pdf, String texto) throws Exception {
        Font font = new Font(Font.FontFamily.COURIER, 11.0f, 1);
        BaseColor myColor = this.hexToBaseColor("#7DAC9C");
        font.setColor(myColor);
        Paragraph p1 = new Paragraph(texto, font);
        p1.setAlignment(1);
        p1.setSpacingAfter(10.0f);
        p1.setSpacingBefore(20.0f);
        pdf.add((Element)p1);
    }

    private PdfPCell getCabCell(String campo) {
        BaseColor myColor = this.hexToBaseColor("#B0F5DD");
        PdfPCell pdfPCell = new PdfPCell(new Phrase(campo, this.cabTableFont));
        pdfPCell.setBackgroundColor(myColor);
        return pdfPCell;
    }

    public BaseColor hexToBaseColor(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        int r = Integer.valueOf(hex.substring(0, 2), 16);
        int g = Integer.valueOf(hex.substring(2, 4), 16);
        int b = Integer.valueOf(hex.substring(4, 6), 16);
        return new BaseColor(r, g, b);
    }
}

