/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.serasa.service;

import br.com.system.integreation.soap.Soap;
import br.com.system.integreation.soap.SoapExecutor;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.stereotype.Service;

@Service
public class SerasaSoupService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String codigoProdutoSelectionado;
    private String cpfCnpj;
    public static final String SPC_MIX_TOP = "257";
    public static final String SPC_MIX_MAIS = "323";
    public static final String NOVO_SPC_MAXI = "325";
    private static final String URL_WS = "https://servicos.spc.org.br/spc/remoting/ws/consulta/consultaWebService?wsdl";

    public JSONObject execute(String cpfCnpj, boolean comProtesto) throws Exception {
        this.cpfCnpj = cpfCnpj;
        this.setProdutoSelecionado(Boolean.valueOf(comProtesto));
        try {
            String soapReturn = this.executaChamadaSoap();
            return XML.toJSONObject((String)soapReturn);
        }
        catch (MalformedURLException | JSONException e) {
            return new JSONObject();
        }
    }

    private String executaChamadaSoap() throws Exception {
        SoapExecutor executor = new Soap(URL_WS).setCorpoMensagemSoap(this.getSoapBady()).addUrlCabecalho("xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"").addUrlCabecalho("xmlns:web=\"http://webservice.consulta.spcjava.spcbrasil.org/\"").addHeaders("Content-Type", "text/xml; charset=utf-8").addHeaders("Authorization", this.getAutorization()).execute();
        return executor.getStringRetornoRequisicao();
    }

    private String getSoapBady() {
        return "<web:filtro>" + "<codigo-produto>" + this.codigoProdutoSelectionado + "</codigo-produto>" + "<tipo-consumidor>" + this.getTipoPessoa() + "</tipo-consumidor>" + "<documento-consumidor>" + this.cpfCnpj + "</documento-consumidor>" + "<utiliza-CMC7>false</utiliza-CMC7>" + "</web:filtro>";
    }

    public String getProdutoSelecionado(Boolean comProtesto) {
        return this.setProdutoSelecionado(comProtesto);
    }

    public String setProdutoSelecionado(Boolean comProtesto) {
        if (comProtesto.booleanValue()) {
            this.codigoProdutoSelectionado = NOVO_SPC_MAXI;
            return NOVO_SPC_MAXI;
        }
        this.codigoProdutoSelectionado = SPC_MIX_TOP;
        return SPC_MIX_TOP;
    }

    private String getTipoPessoa() {
        if (this.cpfCnpj.length() == 11) {
            return "F";
        }
        return "J";
    }

    private String getAutorization() {
        String username = this.getUser();
        String password = this.getPassword();
        String passSenha = username + ":" + password;
        Base64 base64 = new Base64();
        String b64str = base64.encodeToString(passSenha.getBytes());
        return "Basic " + b64str;
    }

    private String getUser() {
        return "1893090";
    }

    private String getPassword() {
        return "10112016";
    }
}

