/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.sessions.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.sessions.model.Sessions;
import br.com.system.app.features.sessions.model.SessionsDTO;
import br.com.system.app.features.sessions.repository.SessionsRepository;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SessionsService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SessionsService.class);
    @Autowired
    private SessionsRepository sessionsRepository;

    @Transactional
    @Async(value="asyncDefault")
    public void updateHeartBeat(String sessionId) {
        this.sessionsRepository.updateHeartBeat(sessionId);
    }

    @Async(value="asyncDefault")
    public void encerrarSessao(String sessionId) {
        Sessions session = this.getBySessionId(sessionId);
        if (session != null) {
            this.encerrarSessao(session);
        }
    }

    @Async(value="asyncDefault")
    public void encerrarSessao(EstruturaUsuario eu) {
        if (eu == null) {
            return;
        }
        for (Sessions d : this.getAtivaByEu(eu)) {
            this.encerrarSessao(d);
        }
    }

    public void encerrarSessao(SessionsDTO session) {
        this.encerrarSessao(this.getBySessionId(session.getSessionId()));
    }

    public void encerrarSessao(Sessions session) {
        try {
            session.setAtiva(false);
            this.sessionsRepository.save((Object)session);
        }
        catch (Exception e) {
            logger.error("Erro inesperado", (Throwable)e);
        }
    }

    public List<Sessions> getAtivaByEu(EstruturaUsuario eu) {
        return this.sessionsRepository.findByEstruturaUsuarioAndAtivaAndLastHeartbeatGreaterThan(eu, Boolean.valueOf(true), LocalDateTime.now().minusMinutes(10L));
    }

    public List<Sessions> getAtivaByEstrutura(Estrutura e) {
        return this.sessionsRepository.findByEstruturaUsuarioEstruturaAndAtivaAndLastHeartbeatGreaterThan(e, Boolean.valueOf(true), LocalDateTime.now().minusMinutes(10L));
    }

    public List<SessionsDTO> getAtivas(EstruturaUsuario eu) {
        return this.getSessions(eu, Boolean.TRUE, "", null, null, null);
    }

    public List<SessionsDTO> getSessions(EstruturaUsuario eu, Boolean activeOnly, String userFilter, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        return this.sessionsRepository.getSessions(eu, activeOnly, dataInicial, dataFinal, userFilter, pageable);
    }

    public long countSessions(EstruturaUsuario eu, Boolean activeOnly, String userFilter, LocalDate dataInicial, LocalDate dataFinal) {
        return this.sessionsRepository.countSessions(eu, activeOnly, dataInicial, dataFinal, userFilter);
    }

    public void save(Sessions session) {
        this.sessionsRepository.save((Object)session);
    }

    public Sessions getBySessionId(String sessionId) {
        return this.sessionsRepository.getBySessionId(sessionId);
    }

    @Async(value="asyncDefault")
    public void checkAtivos(String sessionId) {
        Sessions session = this.getBySessionId(sessionId);
        if (session == null) {
            return;
        }
        if (!(session.getEstruturaUsuario().isAtivo() && session.getEstruturaUsuario().getEstrutura().isAtivo() || session.getEstruturaUsuario().getUsuario().isMaster())) {
            this.encerrarSessao(session);
        }
    }

    public void deleteByEstrutura(Estrutura e) {
        this.sessionsRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

