/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.storage;

import br.com.system.app.features.storage.google.GoogleStorageService;
import br.com.system.app.features.storage.model.UrlSign;
import br.com.system.commons.FileUtil;
import br.com.system.commons.exception.InvalidExtensionException;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;

/*
 * Exception performing whole class analysis ignored.
 */
public class StorageUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MODELO_BUCKET = "modelo-neosales";
    public static final String PUB_BUCKET = "files-neosales";
    public static final String DEFAULT_BUCKET = "bucket-neosales";

    public static Boolean haveObject(String objectName) {
        try {
            boolean retorno;
            try (InputStream obj = StorageUtil.getObject((String)objectName);){
                retorno = obj != null && obj.available() > 0;
            }
            return retorno;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static InputStream getObjectModelo(String objectName) throws IOException, GeneralSecurityException {
        return GoogleStorageService.getObjectInputStream((String)"modelo-neosales", (String)objectName);
    }

    public static InputStream getObject(String objectName) throws IOException, GeneralSecurityException {
        return GoogleStorageService.getObjectInputStream((String)objectName);
    }

    public static String uploadObjectByteArray(String fileNameWithExtension, byte[] byteFile) throws Exception {
        Object contentType;
        try {
            contentType = FileUtil.getContentType((String)fileNameWithExtension);
        }
        catch (InvalidExtensionException | IOException e) {
            contentType = "application/" + FileUtil.getExtension((String)fileNameWithExtension);
        }
        return StorageUtil.uploadObjectByteArray((String)fileNameWithExtension, (String)contentType, (byte[])byteFile);
    }

    public static String uploadObjectByteArray(String fileNameWithExtension, String contentType, byte[] byteFile) throws Exception {
        String retorno;
        try (ByteArrayInputStream myInputStream = new ByteArrayInputStream(byteFile);){
            retorno = StorageUtil.uploadObjectInputStream((String)fileNameWithExtension, (String)contentType, (InputStream)myInputStream);
        }
        return retorno;
    }

    public static String uploadObjectInputStream(String fileNameWithExtension, InputStream inputStreamFile) throws Exception {
        Object contentType;
        try {
            contentType = FileUtil.getContentType((String)fileNameWithExtension);
        }
        catch (InvalidExtensionException | IOException e) {
            contentType = "application/" + FileUtil.getExtension((String)fileNameWithExtension);
        }
        return StorageUtil.uploadObjectInputStream((String)fileNameWithExtension, (String)contentType, (InputStream)inputStreamFile);
    }

    public static String uploadObjectInputStream(String fileNameWithExtension, String contentType, InputStream inputStreamFile) throws Exception {
        return StorageUtil.uploadObjectInputStream(null, (String)fileNameWithExtension, (String)contentType, (InputStream)inputStreamFile);
    }

    public static String uploadObjectInputStream(String bucketName, String fileNameWithExtension, String contentType, InputStream inputStreamFile) throws Exception {
        return GoogleStorageService.uploadObject((String)bucketName, (String)fileNameWithExtension, (String)contentType, (InputStream)inputStreamFile);
    }

    public static void deleteObject(String objectName) throws Exception {
        GoogleStorageService.delete(null, (String)objectName);
    }

    public static void deleteObject(String objectName, String bucketName) throws Exception {
        GoogleStorageService.delete((String)bucketName, (String)objectName);
    }

    public static UrlSign getUrlSign(String nomeArquivo, String bucket) {
        if (nomeArquivo == null || nomeArquivo.isEmpty()) {
            return null;
        }
        return GoogleStorageService.getUrlSign((String)nomeArquivo, (String)bucket);
    }

    public static StreamResource getStreamResource(String hash, String nomeArquivo) {
        return StorageUtil.getStreamResource((String)hash, (String)nomeArquivo, null);
    }

    public static StreamResource getStreamResource(String hash, String nomeArquivo, String bucketName) {
        try {
            byte[] bite = GoogleStorageService.getObject((String)bucketName, (String)hash);
            if (bite.length <= 0) {
                return null;
            }
            if (nomeArquivo.contains("/")) {
                nomeArquivo = nomeArquivo.replace("/", "");
            }
            return new StreamResource(nomeArquivo, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(bite));
        }
        catch (Exception e) {
            return null;
        }
    }
}

