/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx;

import br.com.system.app.features.layout.Border;
import br.com.system.app.features.layout.Color;
import br.com.system.app.features.layout.FlexBoxLayout;
import br.com.system.app.features.layout.TextColor;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.util.Shadow;
import br.com.system.app.features.layout.util.TextAlign;
import br.com.system.app.features.trescx.dto.TrescxLogResumoDTO;
import br.com.system.commons.datetime.DateTimeUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;

public class TrescxBoxView
extends FlexBoxLayout {
    private static final long serialVersionUID = 1L;
    private final TrescxLogResumoDTO dto;

    public TrescxBoxView(TrescxLogResumoDTO dto) {
        this.dto = dto;
        this.setBox();
    }

    public void setBox() {
        this.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        this.setWidth("180px");
        UIUtils.setShadow((Shadow)Shadow.S, (Component[])new Component[]{this});
        this.setPaddingS();
        this.setBorder(Border.Style.SOLID, "1px", Color.AQUAMARINE);
        FlexBoxLayout boxStatus = new FlexBoxLayout();
        boxStatus.setWidthFull();
        Span titulo = new Span(this.dto.getRamal());
        titulo.setWidthFull();
        UIUtils.setTextColor((TextColor)TextColor.TERTIARY, (Component[])new Component[]{titulo});
        UIUtils.setTextAlign((TextAlign)TextAlign.CENTER, (Component[])new Component[]{titulo});
        boxStatus.add(new Component[]{titulo});
        this.add(new Component[]{boxStatus});
        Span labelUsuario = UIUtils.createBreakWrapSpan((String)this.dto.getLoginUsuario());
        labelUsuario.getStyle().set("border-style", "dotted");
        labelUsuario.getStyle().set("border-width", "1px");
        labelUsuario.getStyle().set("border-color", "#DDD7D7");
        Span spanQuantidade = new Span("Liga\u00e7\u00f5es " + this.dto.getQuantidade().toString());
        spanQuantidade.getStyle().set("border-style", "dotted");
        spanQuantidade.getStyle().set("border-width", "1px");
        spanQuantidade.getStyle().set("border-color", "#DDD7D7");
        Span spanQtdeFalado = new Span("Liga\u00e7\u00f5es Falando " + this.dto.getQuantosFalados().toString());
        spanQtdeFalado.getStyle().set("border-style", "dotted");
        spanQtdeFalado.getStyle().set("border-width", "1px");
        spanQtdeFalado.getStyle().set("border-color", "#DDD7D7");
        Span spanTalking = new Span("Tempo Falando " + DateTimeUtil.secondsToTime((Integer)this.dto.getTalking()));
        spanTalking.getStyle().set("border-style", "dotted");
        spanTalking.getStyle().set("border-width", "1px");
        spanTalking.getStyle().set("border-color", "#DDD7D7");
        Span spanRing = new Span("Chamando " + DateTimeUtil.secondsToTime((Integer)this.dto.getRing()));
        spanRing.getStyle().set("border-style", "dotted");
        spanRing.getStyle().set("border-width", "1px");
        spanRing.getStyle().set("border-color", "#DDD7D7");
        Span spanTotal = new Span("Total " + DateTimeUtil.secondsToTime((Integer)this.dto.getTempoTotal()));
        spanTotal.getStyle().set("border-style", "dotted");
        spanTotal.getStyle().set("border-width", "1px");
        spanTotal.getStyle().set("border-color", "#DDD7D7");
        UIUtils.setTextWrap((Component[])new Component[]{labelUsuario});
        this.add(new Component[]{labelUsuario, spanQuantidade, spanQtdeFalado, spanRing, spanTalking, spanTotal});
    }
}

