/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx;

import br.com.system.app.components.AudioPlayerView;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.trescx.model.TrescxChamada;
import br.com.system.app.features.trescx.service.TrescxChamadaService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.HashUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TrescxGravacaoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final TrescxChamadaService tcs;
    private final Pedido pedido;
    private final Cliente cliente;
    private Grid<TrescxChamada> grid;
    private final AudioPlayerView audioPlayerView;
    private List<TrescxChamada> lista;
    private DownloadDialog dd;

    public TrescxGravacaoView(Cliente cliente, TrescxChamadaService tcs, AudioPlayerView audioPlayerView) {
        this.tcs = tcs;
        this.audioPlayerView = audioPlayerView;
        this.cliente = cliente;
        this.pedido = null;
        this.init();
    }

    public TrescxGravacaoView(Pedido pedido, TrescxChamadaService tcs, AudioPlayerView audioPlayerView) {
        this.tcs = tcs;
        this.audioPlayerView = audioPlayerView;
        this.pedido = pedido;
        this.cliente = null;
        this.init();
    }

    private String getZip() {
        try {
            File zipFile = new File("/tmp/" + HashUtil.getUUI() + ".zip");
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            int ind = 0;
            for (TrescxChamada tc : this.lista) {
                InputStream is = StorageUtil.getObject((String)tc.getHashGravacao());
                ZipEntry ze = new ZipEntry(++ind + "-" + StringUtil.normalize((String)tc.getHashGravacao()));
                zos.putNextEntry(ze);
                byte[] bytes = new byte[1024];
                int count = is.read(bytes);
                while (count > -1) {
                    zos.write(bytes, 0, count);
                    count = is.read(bytes);
                }
                is.close();
                zos.closeEntry();
            }
            zos.close();
            byte[] fileContent = Files.readAllBytes(zipFile.toPath());
            zipFile.delete();
            return StorageUtil.uploadObjectByteArray((String)(HashUtil.getUUI() + ".zip"), (byte[])fileContent);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private void init() {
        this.dd = new DownloadDialog();
        if (!this.hasPermission("TRESCX_GRAVACOES_VIEW")) {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar anexos");
            return;
        }
        this.setWidth("910px");
        Button btnDown = UIUtils.createButton((String)"Baixar Todos", (String)"Baixar todos os arquivos em ZIP", (ButtonVariant[])new ButtonVariant[0]);
        btnDown.addClickListener((ComponentEventListener & Serializable)e -> this.dd.open(this.getZip(), "Gravacoes-3cx.zip", true));
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE, (String)"");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.add(new Component[]{new VerticalContainer(new Component[]{this.createGrid(), new FooterContainer(new Component[]{btnFechar, btnDown})})});
        this.open();
    }

    private void povoa() {
        if (this.pedido != null) {
            this.lista = this.tcs.getByAtividade(this.pedido.getId());
        } else if (this.cliente != null) {
            this.lista = this.tcs.getByCpfCnpj(this.cliente.getCpfCnpj(), this.getEstrutura());
        }
        this.grid.setItems((Collection)this.lista);
    }

    private HorizontalContainer createGrid() {
        this.grid = new Grid(TrescxChamada.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("860px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            TrescxChamada tl = eg;
            Button b = UIUtils.createSmallButton((String)"Ouvir");
            b.setVisible(tl.getHashGravacao() != null);
            b.addClickListener((ComponentEventListener & Serializable)e -> this.audioPlayerView.create(tl.getHashGravacao()));
            return b;
        })).setFlexGrow(0).setWidth("100px").setHeader("Grava\u00e7\u00e3o");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)e -> {
            TrescxChamada pa = e;
            return UIUtils.createBreakWrapSpan((String)pa.getEstruturaUsuario().getUsuario().getNome());
        })).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("160px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getCpfCnpj() == null ? "" : p.getCpfCnpj())).setFlexGrow(0).setWidth("160px").setHeader("CPF-CNPJ");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getPedidoId() == null ? "" : p.getPedidoId().toString())).setFlexGrow(0).setWidth("120px").setHeader("Atividade");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getRamal())).setFlexGrow(0).setWidth("100px").setHeader("Ramal");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDestino())).setFlexGrow(0).setWidth("120px").setHeader("Destino");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px").setHeader("Data/Hora");
        this.povoa();
        return new HorizontalContainer(new Component[]{this.grid});
    }
}

