/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.trescx.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.trescx.model.TrescxChamada;
import br.com.system.app.features.trescx.repository.TrescxChamadaRepository;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrescxChamadaService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private TrescxChamadaRepository repository;

    public List<TrescxChamada> getByAtividade(Long atividadeId) {
        return this.repository.findByAtividade(atividadeId);
    }

    public List<TrescxChamada> getByCpfCnpj(String cpfCnpj, Estrutura estrutura) {
        return this.repository.findByCpfCnpjAndEstrutura(cpfCnpj, estrutura);
    }

    public TrescxChamada save(TrescxChamada tc) {
        try {
            if (tc.getEstruturaUsuario() == null) {
                throw new BusinessException("Eu nao informado");
            }
            if (tc.getEstruturaUsuario().getUsuario().getRamal() == null) {
                throw new BusinessException("Ramal nao definido no cadastro do usu\u00e1rio");
            }
            if (tc.getDestino() == null || tc.getDestino().isEmpty()) {
                throw new BusinessException("Destino obrigatorio");
            }
            if (tc.getDataHora() == null) {
                tc.setDataHora(LocalDateTime.now());
            }
            if (tc.getRamal() == null || tc.getRamal().isEmpty()) {
                tc.setRamal(tc.getEstruturaUsuario().getUsuario().getRamal());
            }
            return (TrescxChamada)this.repository.save((Object)tc);
        }
        catch (Exception e) {
            return tc;
        }
    }

    public List<TrescxChamada> getChamadaSemLog(String ramal, String destino) {
        return this.repository.findFirstByRamalAndDestino(ramal, destino);
    }

    public void gravarChamada3cx(EstruturaUsuario eu, String numero, String cpfCnpj, Long atividade) {
        TrescxChamada tc = new TrescxChamada();
        tc.setCpfCnpj(cpfCnpj);
        tc.setDataHora(LocalDateTime.now());
        tc.setDestino(numero);
        tc.setEstruturaUsuario(eu);
        tc.setPedidoId(atividade);
        tc.setRamal(eu.getUsuario().getRamal());
        this.save(tc);
    }

    public void deleteByEstrutura(Estrutura e) {
        this.repository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

