/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.MainLayout;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.layout.ViewFrame;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.dto.UsuarioTemaEnum;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioSenhaService;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.usuario.views.UsuarioConfirmacaoView;
import br.com.system.app.features.usuario.views.UsuarioNovaSenhaView;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="configuracoes", layout=MainLayout.class)
@PageTitle(value="Minhas configura\u00e7\u00f5es")
@RolesAllowed(value={"USER_CONFIG_VIEW"})
public class ConfiguracoesView
extends ViewFrame
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final UsuarioService usuarioService;
    private final UsuarioConfirmacaoView ucv;
    private final UsuarioSenhaService usuarioSenhaService;

    @Autowired
    public ConfiguracoesView(UsuarioService usuarioService, UsuarioConfirmacaoView ucv, UsuarioSenhaService usuarioSenhaService) {
        this.ucv = ucv;
        this.usuarioSenhaService = usuarioSenhaService;
        this.usuarioService = usuarioService;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.autenticado()) {
            this.setViewContent((Component)this.createContent());
        }
    }

    private VerticalContainer createContent() {
        this.setWidth("400px");
        TextField nome = new TextField("Nome");
        nome.setWidth("380px");
        RadioButtonGroup rb = new RadioButtonGroup();
        rb.setLabel("Informativo Diario");
        rb.setItems((Object[])new String[]{"Somente eu", "Com Hierarquia", "N\u00e3o Receber"});
        Button updateEt = UIUtils.createSmallButton((String)"Atualizar E-mail e Telefone");
        updateEt.addClickListener((ComponentEventListener & Serializable)e -> this.ucv.create(this.getEu(), "light"));
        Button updatePass = UIUtils.createSmallButton((String)"Alterar Senha");
        updatePass.addClickListener((ComponentEventListener & Serializable)e -> new UsuarioNovaSenhaView(this.getEu().getUsuario(), this.usuarioSenhaService, false, "light"));
        Button updateButton = UIUtils.createSmallButton((String)"Salvar");
        ComboBox cbTheme = new ComboBox();
        cbTheme.setPlaceholder("Tema");
        cbTheme.setItems((Object[])UsuarioTemaEnum.values());
        cbTheme.setValue((Object)this.getEu().getUsuario().getTema());
        updateButton.addClickListener((ComponentEventListener & Serializable)event -> {
            try {
                if (nome.getValue().isEmpty()) {
                    Notification.show((String)"O campo Nome \u00e9 obrigatorio");
                    return;
                }
                Usuario usuario = this.getEu().getUsuario();
                usuario.setNome(nome.getValue());
                if ("Somente eu".equals(rb.getValue())) {
                    usuario.setInformativoComHierarquia(Boolean.valueOf(false));
                } else if ("Com Hierarquia".equals(rb.getValue())) {
                    usuario.setInformativoComHierarquia(Boolean.valueOf(true));
                } else {
                    usuario.setInformativoComHierarquia(null);
                }
                usuario.setTema((UsuarioTemaEnum)cbTheme.getValue());
                this.usuarioService.salvar(usuario, this.getEu());
                Notification.show((String)"Altera\u00e7\u00f5es efetuadas com sucesso");
            }
            catch (BusinessException e) {
                Notification.show((String)e.getMessage());
            }
        });
        nome.setValue(this.getEu().getUsuario().getNome());
        if (this.getEu().getUsuario().getInformativoComHierarquia() == null) {
            rb.setValue((Object)"N\u00e3o Receber");
        } else if (this.getEu().getUsuario().getInformativoComHierarquia().booleanValue()) {
            rb.setValue((Object)"Com Hierarquia");
        } else {
            rb.setValue((Object)"Somente eu");
        }
        return new VerticalContainer(new Component[]{nome, rb, cbTheme, updateButton, new FooterContainer(new Component[]{updateEt, updatePass})}).setSpacingOn();
    }
}

