/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.usuario.views;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.model.HierarquiaLog;
import br.com.system.app.features.usuario.service.HierarquiaLogService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Footer;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class HierarquiaLogView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private HierarquiaLogService hierarquiaLogService;
    private Grid<HierarquiaLog> grid;

    public void create(Estrutura estrutura) {
        this.removeAll();
        this.grid = new Grid(HierarquiaLog.class);
        this.grid.setWidth("900px");
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> UIUtils.createBreakWrapSpan((String)p.getEstruturaUsuario().getUsuario().getNome()))).setHeader("Usu\u00e1rio").setFlexGrow(0).setWidth("200px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)p -> {
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span>" + p.getAlteracoes() + "</span>");
            return div;
        })).setHeader("Altera\u00e7\u00f5es").setFlexGrow(0).setWidth("500px");
        this.grid.addItemClickListener((ComponentEventListener & Serializable)e -> {
            Dialog d = new Dialog();
            Button b = UIUtils.createSmallButton((String)"Fechar");
            b.addClickListener((ComponentEventListener & Serializable)close -> d.close());
            Div div = new Div();
            div.getElement().setProperty("innerHTML", "<span>" + ((HierarquiaLog)e.getItem()).getAlteracoes() + "</span>");
            d.add(new com.vaadin.flow.component.Component[]{div, new Footer(new com.vaadin.flow.component.Component[]{b})});
            d.open();
        });
        this.grid.setPageSize(60);
        this.grid.setItems((CallbackDataProvider.FetchCallback & Serializable)query -> this.hierarquiaLogService.get(estrutura, (Pageable)PageRequest.of((int)query.getPage(), (int)query.getPageSize())).stream());
        Button close = UIUtils.createSmallButton((String)"Fechar");
        close.addClickListener((ComponentEventListener & Serializable)c -> this.close());
        this.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Clique no item para expandir")});
        this.add(new com.vaadin.flow.component.Component[]{this.grid, new Footer(new com.vaadin.flow.component.Component[]{close})});
        this.open();
    }
}

