/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.waha;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.waha.service.WahaService;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.commons.StreamResourceUtil;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WahaQrcodeView
extends Dialog {
    private static final long serialVersionUID = 1L;
    private final String SCAN_QR_CODE = "SCAN_QR_CODE";
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> future;
    private WahaService wahaService;

    protected void onDetach(DetachEvent detachEvent) {
        this.future.cancel(true);
        this.scheduler.shutdownNow();
        super.onDetach(detachEvent);
    }

    public WahaQrcodeView(Usuario usuario, WhatsAppConta conta, WahaService wahaService) {
        this.wahaService = wahaService;
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        Image image = new Image();
        image.setWidth("350px");
        image.setHeight("350px");
        this.setImage(image, conta.getMooseId());
        UI ui = UI.getCurrent();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        Runnable task = () -> {
            if (ui != null && ui.isAttached()) {
                ui.access((Command & Serializable)() -> {
                    try {
                        String status = this.wahaService.getStatusSession(conta.getMooseId());
                        if (status.equals("SCAN_QR_CODE")) {
                            this.setImage(image, conta.getMooseId());
                        } else {
                            this.close();
                        }
                    }
                    catch (Exception ex) {
                        UIUtils.showNotification((String)("Erro ao atualizar QR: " + ex.getMessage()));
                    }
                });
            }
        };
        this.future = this.scheduler.scheduleAtFixedRate(task, 10L, 10L, TimeUnit.SECONDS);
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar");
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        btnFechar.setEnabled(usuario.getTravaQrcode() == null || usuario.getTravaQrcode() == false);
        Button btnRefresh = UIUtils.createSmallButton((String)"Refresh");
        btnRefresh.addClickListener((ComponentEventListener & Serializable)e -> {
            try {
                this.setImage(image, conta.getMooseId());
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)("Erro ao atualizar QR: " + ex.getMessage()));
            }
        });
        this.add(new Component[]{UIUtils.createHeader((String)"Leia o QRCODE com APP Whats")});
        this.add(new Component[]{image});
        this.add(new Component[]{new FooterContainer(new Component[]{btnFechar, btnRefresh})});
        this.open();
    }

    private void setImage(Image image, String session) {
        try {
            image.setSrc((AbstractStreamResource)StreamResourceUtil.getStream((InputStream)this.wahaService.getQrCode(session), (String)"QR_CODE"));
        }
        catch (Exception e) {
            UIUtils.showError((String)e.getMessage());
        }
    }
}

