/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.equipe.model.Equipe;
import br.com.system.app.features.equipe.service.EquipeService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.repository.projection.HierarquiaDTO;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppSetores;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppSetoresService;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppAtendenteForm
extends Dialog {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppAtendenteService waas;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private EquipeService equipeService;
    @Autowired
    private WhatsAppSetoresService whatsAppSetoresService;
    private Set<String> equipeIds;
    private WhatsAppAtendente wa;
    private Grid<Equipe> grid;
    private Checkbox cbAuto;
    private Checkbox cbAtivo;
    private Checkbox cbPrioritario;
    private ComboBox<HierarquiaDTO> cbUsuario;
    private ComboBox<WhatsAppSetores> cbSetores;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void show(WhatsAppAtendente waSelected, EstruturaUsuario eu) {
        this.removeAll();
        this.setWidth("600px");
        this.wa = waSelected;
        if (this.wa == null) {
            this.wa = new WhatsAppAtendente();
            this.wa.setOnline(Boolean.FALSE);
            this.wa.setAtivo(Boolean.TRUE);
            this.wa.setRecebeAutomatico(Boolean.TRUE);
            this.wa.setPrioritario(Boolean.FALSE);
        }
        List hierarquia = this.eus.getAtivosByEstrutura(eu.getEstrutura());
        VerticalContainer main = new VerticalContainer(new com.vaadin.flow.component.Component[0]);
        main.setWidthFull();
        main.setHeightFull();
        this.cbUsuario = new ComboBox("Usu\u00e1rio", (Collection)hierarquia);
        this.cbUsuario.setItemLabelGenerator(HierarquiaDTO::getUsuarioELoginEEquipe);
        if (this.wa.getEstruturaUsuario() != null) {
            for (HierarquiaDTO h : hierarquia) {
                if (!h.getEstruturaUsuarioId().equals(this.wa.getEstruturaUsuario().getId())) continue;
                this.cbUsuario.setValue((Object)h);
                this.cbUsuario.setEnabled(false);
                break;
            }
        }
        this.cbAuto = new Checkbox("Recebe Automatico", this.wa.getRecebeAutomatico().booleanValue());
        this.cbAtivo = new Checkbox("Ativo", this.wa.getAtivo().booleanValue());
        this.cbPrioritario = new Checkbox("Priorit\u00e1rio", this.wa.getPrioritario().booleanValue());
        this.cbSetores = new ComboBox("Setor", (Collection)this.whatsAppSetoresService.getByEstrutura(eu.getEstrutura()));
        this.cbSetores.setItemLabelGenerator(WhatsAppSetores::getNome);
        if (this.wa.getWhatsappSetores() != null) {
            this.cbSetores.setValue((Object)this.wa.getWhatsappSetores());
        }
        ComboBox cbEquipe = new ComboBox("Inserir Equipe", (Collection)this.equipeService.getEquipes(eu.getEstrutura()));
        cbEquipe.setItemLabelGenerator(Equipe::getNome);
        this.grid = new Grid(Equipe.class);
        this.grid.setColumns(new String[0]);
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getNome())).setHeader("Equipes Selecionadas");
        Button btnInsert = UIUtils.createSmallButton((String)"Inserir");
        btnInsert.addClickListener((ComponentEventListener & Serializable)e -> {
            if (cbEquipe.getValue() == null) {
                UIUtils.showNotification((String)"Selecione uma equipe para Inserir");
                return;
            }
            this.equipeIds.add(((Equipe)cbEquipe.getValue()).getId().toString());
            this.wa.setEstruturaUsuario(this.eus.getById(((HierarquiaDTO)this.cbUsuario.getValue()).getEstruturaUsuarioId()));
            this.wa.setEquipeIds(StringUtils.join((Iterable)this.equipeIds, (String)","));
            this.wa.setWhatsappSetores((WhatsAppSetores)this.cbSetores.getValue());
            try {
                this.wa = this.salvar();
            }
            catch (Exception ex) {
                UIUtils.showNotification((String)ex.getMessage());
            }
            cbEquipe.clear();
            this.povoar();
        });
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnDelete = UIUtils.createSmallButton((String)"Excluir");
        btnDelete.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.grid.getSelectedItems().size() <= 0) {
                UIUtils.showNotification((String)"Selecione uma equipe para excluir");
                return;
            }
            this.equipeIds.remove(((Equipe)this.grid.getSelectedItems().iterator().next()).getId().toString());
            this.wa.setEquipeIds(StringUtils.join((Iterable)this.equipeIds, (String)","));
            this.wa = this.salvar();
            this.povoar();
        });
        Button btnSalvar = UIUtils.createSmallButton((String)"Salvar");
        btnSalvar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.cbUsuario.getValue() == null) {
                UIUtils.showNotification((String)"Selecione um usu\u00e1rio para salvar");
                return;
            }
            this.salvar();
            this.close();
        });
        main.add(new com.vaadin.flow.component.Component[]{UIUtils.createHeader((String)"Cadastro Atendente")});
        main.add(new com.vaadin.flow.component.Component[]{this.cbUsuario, this.cbSetores, this.cbAuto, this.cbAtivo, this.cbPrioritario, new HorizontalContainer(new com.vaadin.flow.component.Component[]{cbEquipe, btnInsert}), this.grid, new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnDelete, btnSalvar})});
        this.add(new com.vaadin.flow.component.Component[]{main});
        this.povoar();
        this.open();
    }

    private WhatsAppAtendente salvar() {
        if (this.wa.getId() == null) {
            this.wa.setEstruturaUsuario(this.eus.getById(((HierarquiaDTO)this.cbUsuario.getValue()).getEstruturaUsuarioId()));
            this.wa.setOnline(Boolean.FALSE);
        }
        this.wa.setAtivo((Boolean)this.cbAtivo.getValue());
        this.wa.setWhatsappSetores((WhatsAppSetores)this.cbSetores.getValue());
        this.wa.setPrioritario((Boolean)this.cbPrioritario.getValue());
        this.wa.setRecebeAutomatico((Boolean)this.cbAuto.getValue());
        return this.waas.save(this.wa);
    }

    private void povoar() {
        if (this.wa.getEquipeIds() == null || this.wa.getEquipeIds().isEmpty()) {
            this.equipeIds = new HashSet();
            this.grid.setItems(new ArrayList());
            return;
        }
        List equipes = this.equipeService.getByIds(this.wa.getEquipeIds());
        this.grid.setItems((Collection)equipes);
        this.equipeIds = new HashSet<String>(Arrays.asList(this.wa.getEquipeIds().split(",")));
    }
}

