/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp;

import br.com.system.app.components.ListField;
import br.com.system.app.components.ListFieldTypeEnum;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppConta;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppFuncaoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppHave;
import br.com.system.app.features.whatsapp.service.WhatsAppContaService;
import br.com.system.app.features.whatsapp.service.WhatsAppHaveService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.EmailField;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WhatsAppCadastroView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppHaveService whatsAppHaveService;
    @Autowired
    private WhatsAppContaService whatsappContaService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private UsuarioService usuarioService;
    private ListField txtCnpj;
    private TextField txtWNumero;
    private TextField txtWNome;
    private EmailField txtWEmail;
    private TextField txtLogin;
    private ComboBox<WhatsAppFuncaoEnum> cbFuncao;
    private WhatsApp w;
    private String cnpj;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public void create(WhatsApp w, String cnpj) {
        this.cnpj = cnpj;
        this.removeAll();
        this.add(new com.vaadin.flow.component.Component[]{this.form(w)});
        this.open();
    }

    private VerticalLayout form(WhatsApp whats) {
        this.w = whats;
        this.setWidth("300px");
        this.txtCnpj = new ListField(ListFieldTypeEnum.CPF_CNPJ, "CNPJS");
        this.txtCnpj.setWidthFull();
        if (whats == null && this.cnpj != null && !this.cnpj.isEmpty()) {
            this.txtCnpj.setValue(this.cnpj);
            this.txtCnpj.setEnabled(false);
        }
        this.txtWNumero = new TextField("*N\u00famero");
        this.txtWNumero.setWidth("160px");
        this.txtWNome = new TextField("*Nome");
        this.txtWNome.setWidthFull();
        this.txtWEmail = new EmailField("E-mail");
        this.txtWEmail.setWidthFull();
        this.cbFuncao = new ComboBox("Fun\u00e7\u00e3o", (Object[])WhatsAppFuncaoEnum.values());
        this.cbFuncao.setItemLabelGenerator(Enum::name);
        this.txtLogin = new TextField("Login");
        this.txtLogin.setWidthFull();
        if (this.w == null) {
            this.w = new WhatsApp();
        } else {
            if (this.w.getCpfCnpj() != null) {
                HashSet<String> ss = new HashSet<String>();
                if (this.w.getCpfCnpj().contains(",")) {
                    for (String s : this.w.getCpfCnpj().split(",")) {
                        if (!ValidationUtil.isValidCnpjAndCpf((String)s)) continue;
                        ss.add(s);
                    }
                } else if (ValidationUtil.isValidCnpjAndCpf((String)this.w.getCpfCnpj())) {
                    ss.add(this.w.getCpfCnpj());
                }
                this.txtCnpj.setValue(ss);
            }
            this.txtWNumero.setValue(this.w.getNumero() == null ? "" : this.w.getNumero());
            this.txtWNumero.setReadOnly(true);
            this.txtWNome.setValue(this.w.getNome() == null ? "" : this.w.getNome());
            this.txtWEmail.setValue(this.w.getEmail() == null ? "" : this.w.getEmail());
            if (this.w.getFuncao() != null) {
                this.cbFuncao.setValue((Object)this.w.getFuncao());
            }
        }
        Button btnSave = UIUtils.createSmallButton((String)"Salvar");
        btnSave.addClickListener((ComponentEventListener & Serializable)e -> this.salvar(this.w));
        Button btnClose = UIUtils.createSmallButton((String)"Fechar");
        btnClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        if (this.isNeoCrm()) {
            return new VerticalContainer(new com.vaadin.flow.component.Component[]{this.txtWNumero, this.txtWNome, this.txtCnpj, this.txtWEmail, this.txtLogin, new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnSave})});
        }
        return new VerticalContainer(new com.vaadin.flow.component.Component[]{this.txtWNumero, this.txtWNome, this.txtCnpj, this.txtWEmail, this.cbFuncao, new FooterContainer(new com.vaadin.flow.component.Component[]{btnClose, btnSave})});
    }

    private void salvar(WhatsApp w) {
        Usuario u;
        String numero = StringUtil.numbersOnly((String)this.txtWNumero.getValue());
        if (numero.length() > 11 && numero.startsWith("55")) {
            numero = numero.substring(2);
            this.txtWNumero.setValue(numero);
        }
        if (!TelefoneUtil.isValid((String)numero)) {
            UIUtils.showNotification((String)"Telefone inv\u00e1lido");
            return;
        }
        if (this.txtLogin.getValue() != null && !this.txtLogin.getValue().isEmpty() && (u = this.usuarioService.getByLogin(this.txtLogin.getValue())) == null) {
            UIUtils.showNotification((String)"Login n\u00e3o encontrado");
            return;
        }
        WhatsAppHave have = this.whatsAppHaveService.getHave(numero);
        if (have == null || !have.getHave().booleanValue()) {
            UIUtils.showNotification((String)"Este n\u00famero n\u00e3o tem whatsapp");
            return;
        }
        if (this.txtWNome.getValue() == null || this.txtWNome.getValue().isEmpty()) {
            UIUtils.showNotification((String)"Nome \u00e9 obrigat\u00f3rio");
            return;
        }
        WhatsAppConta wc = null;
        if (this.getUsuario().getWhatsappConta() != null) {
            wc = this.getUsuario().getWhatsappConta();
        } else {
            List listaWc = this.whatsappContaService.getContaByEstruturaAndAtendimentoAndMarketing(this.getEstrutura(), true, false);
            if (!listaWc.isEmpty()) {
                wc = (WhatsAppConta)listaWc.get(0);
            }
        }
        if (wc == null) {
            UIUtils.showNotification((String)"N\u00e3o localizei conta whatsapp business nessa estrutura");
            return;
        }
        WhatsApp wExists = this.whatsAppService.getByNumeroAndConta(have.getNumeroWhats(), wc);
        if (wExists != null && !wExists.getId().equals(w.getId())) {
            UIUtils.showNotification((String)"Este n\u00famero j\u00e1 est\u00e1 cadastrado.");
            return;
        }
        if (w.getId() != null) {
            UIUtils.showNotification((String)"Atualizado com sucesso");
        } else {
            UIUtils.showNotification((String)"Cadastro criado com sucesso");
        }
        w.setCpfCnpj(StringUtils.join((Iterable)this.txtCnpj.getValue(), (String)","));
        w.setLogin(this.txtLogin.getValue());
        w.setCriador(this.getEu());
        w.setDataHoraCriacao(LocalDateTime.now());
        w.setEtapa(WhatsAppEtapaEnum.FECHADO);
        w.setNome(this.txtWNome.getValue());
        w.setEmail(this.txtWEmail.getValue() == null || this.txtWEmail.getValue().isEmpty() ? null : this.txtWEmail.getValue());
        w.setFuncao((WhatsAppFuncaoEnum)this.cbFuncao.getValue());
        w.setNumero(have.getNumeroWhats());
        w.setUltimoAtendente(this.eus.getMasterEstrutura(this.getEstrutura()));
        w.setWhatsappConta(wc);
        this.whatsAppService.save(w);
        for (String s : this.txtCnpj.getValue()) {
            if (!ValidationUtil.isValidCnpjAndCpf((String)s)) continue;
            Cliente cliente = this.clienteService.getAndCreateCliente(this.getEu(), s, new ClienteContato[0]);
            if (w.getEmail() == null || !ValidationUtil.isValidEmail((String)w.getEmail())) continue;
            ClienteContato cc = new ClienteContato(cliente, TipoContatoEnum.EMAIL, w.getEmail().trim().toLowerCase());
            if (!cliente.getClienteContato().contains(cc)) {
                cc.setVerificado(ClienteContatoVerficadoEnum.VALIDO);
                cliente.getClienteContato().add(cc);
                this.clienteService.salvar(cliente, this.getEu());
                continue;
            }
            cliente.getClienteContato().forEach(e -> {
                if (e.getTipo().equals((Object)TipoContatoEnum.EMAIL) && e.getValor().equals(w.getEmail())) {
                    e.setVerificado(ClienteContatoVerficadoEnum.VALIDO);
                    this.clienteService.salvar(cliente, this.getEu());
                }
            });
        }
        this.close();
    }
}

