/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.Estrutura;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.whatsapp.model.WhatsappBloqueio;
import br.com.system.app.features.whatsapp.repository.WhatsAppBloqueioRepository;
import br.com.system.commons.TelefoneUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WhatsAppBloqueioService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppBloqueioRepository whatsAppBloqueioRepository;

    public List<WhatsappBloqueio> getByEstrutura(Estrutura e, Set<String> numeros, Pageable pageable) {
        if (numeros == null || numeros.size() <= 0) {
            return this.whatsAppBloqueioRepository.findByEstruturaUsuarioEstrutura(e, pageable);
        }
        return this.whatsAppBloqueioRepository.findByEstruturaUsuarioEstruturaAndNumeroIn(e, numeros, pageable);
    }

    public long countByEstrutura(Estrutura e, Set<String> numeros) {
        if (numeros == null || numeros.size() <= 0) {
            return this.whatsAppBloqueioRepository.countByEstruturaUsuarioEstrutura(e);
        }
        return this.whatsAppBloqueioRepository.countByEstruturaUsuarioEstruturaAndNumeroIn(e, numeros);
    }

    public boolean isBloqueado(Estrutura e, String numero) {
        return this.whatsAppBloqueioRepository.findFirstByEstruturaUsuarioEstruturaAndNumero(e, TelefoneUtil.normalize((String)numero)) != null;
    }

    public WhatsappBloqueio save(WhatsappBloqueio wb) {
        WhatsappBloqueio b = this.whatsAppBloqueioRepository.findFirstByEstruturaUsuarioEstruturaAndNumero(wb.getEstruturaUsuario().getEstrutura(), wb.getNumero());
        if (b != null) {
            return b;
        }
        return (WhatsappBloqueio)this.whatsAppBloqueioRepository.save((Object)wb);
    }

    public void bloquear(EstruturaUsuario eu, Set<String> numeros) {
        for (String numero : numeros) {
            this.bloquear(eu, numero);
        }
    }

    public WhatsappBloqueio bloquear(EstruturaUsuario eu, String numero) {
        if (!TelefoneUtil.isValid((String)(numero = TelefoneUtil.normalize((String)numero)))) {
            return null;
        }
        WhatsappBloqueio b = this.whatsAppBloqueioRepository.findFirstByEstruturaUsuarioEstruturaAndNumero(eu.getEstrutura(), numero);
        if (b != null) {
            return b;
        }
        b = new WhatsappBloqueio();
        b.setDataHora(LocalDateTime.now());
        b.setNumero(numero);
        b.setEstruturaUsuario(eu);
        return this.save(b);
    }

    @Transactional
    @Modifying
    public void delete(WhatsappBloqueio wo) {
        this.whatsAppBloqueioRepository.delete((Object)wo);
    }

    @Transactional
    @Modifying
    public void remove(EstruturaUsuario eu, String numero) {
        WhatsappBloqueio b = this.whatsAppBloqueioRepository.findFirstByEstruturaUsuarioEstruturaAndNumero(eu.getEstrutura(), numero);
        if (b != null) {
            this.whatsAppBloqueioRepository.delete((Object)b);
        }
    }

    public void deleteByEstrutura(Estrutura e) {
        this.whatsAppBloqueioRepository.deleteByEstruturaUsuarioEstrutura(e);
    }
}

