/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.pedido.model.Pedido;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppMensagemService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import com.vaadin.flow.component.notification.Notification;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppCreateService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppSendService whatsAppSendService;
    @Autowired
    private WhatsAppMensagemService whatsAppMensagemService;

    public void criar(WhatsApp w, EstruturaUsuario eu, String cnpj, String mensagem, Pedido pedido) {
        List abertos = this.whatsAppAtendimentoService.getAbertos(w);
        if (!abertos.isEmpty()) {
            StringBuilder msg = new StringBuilder("J\u00e1 h\u00e1 um atendimento em aberto para este n\u00famero");
            if (((WhatsAppAtendimento)abertos.get(0)).getPedido() != null) {
                msg.append("\nAtendimento #").append(((WhatsAppAtendimento)abertos.get(0)).getPedido().getNumero());
            }
            if (!((WhatsAppAtendimento)abertos.get(0)).getAtendente().getId().equals(eu.getId())) {
                msg.append("\nUsu\u00e1rio ").append(((WhatsAppAtendimento)abertos.get(0)).getAtendente().getUsuario().getLogin());
                msg.append("\nSolicite o encerramento do atendimento atual ou a transferencia do atendimento.");
            } else {
                msg.append("\nEste atendimento j\u00e1 est\u00e1 na sua fila.");
            }
            throw new BusinessException(msg.toString());
        }
        w.setCnpjEscolhido(cnpj);
        w.setUltimoAtendente(eu);
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        this.whatsAppService.save(w);
        WhatsAppAtendimento wa = this.whatsAppAtendimentoService.getAndCreate(w, pedido);
        wa.setDataHoraTransferencia(LocalDateTime.now());
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        wa.setFechado(false);
        wa.setFechadoInatividade(false);
        wa = this.whatsAppAtendimentoService.save(wa);
        try {
            if (mensagem != null && !mensagem.isEmpty()) {
                WhatsAppMensagem wm = w.getWhatsappConta().getApiOficial() != false ? this.whatsAppSendService.sendTemplate(wa, eu, mensagem) : this.whatsAppSendService.sendMessageText(wa, eu, mensagem);
                this.whatsAppControleService.gravarNova(wm, WhatsAppStatusEnum.ENVIADA);
            } else {
                this.whatsAppMensagemService.inserirAnotacao(wa, eu, "Criado atendimento sem enviar mensagem.");
            }
        }
        catch (Exception e) {
            Notification.show((String)e.getMessage());
        }
    }
}

