/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.storage.StorageUtil;
import br.com.system.app.features.whatsapp.dto.WhatsAppButtonRequest;
import br.com.system.app.features.whatsapp.dto.WhatsAppMessageFileRequest;
import br.com.system.app.features.whatsapp.dto.WhatsAppMessageRequest;
import br.com.system.app.features.whatsapp.dto.WhatsMoorseBillingDTO;
import br.com.system.app.features.whatsapp.dto.WhatsMoorseBillingItemDTO;
import br.com.system.app.features.whatsapp.model.WhatsAppContentTipoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.integreation.conexaoExterna.ExternalConnection;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppMoorseApi {
    private ExternalConnection getConexao() {
        ExternalConnection conexao = new ExternalConnection();
        conexao.addHeaderDefault("Authorization", "eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJqZXJpYW0uc2lxdWVpcmFAZ21haWwuY29tIiwiaWRDbGllbnQiOiIwZjc0OTQ1MS1lODIxLTRmMWYtOTFkNi0xMzRhMjVlMmRiY2QiLCJjcmVhdGVkIjoxNzUyNTk0MTU1MjQ0LCJyb2xlcyI6WyJST0xFX0FQSSIsIlJPTEVfREFTSEJPQVJEIiwiUk9MRV9EQVNIQk9BUkRfR1JPVVBTIiwiUk9MRV9HUk9VUFMiLCJST0xFX0lOVEVHUkFUSU9OX1VTRVIiLCJST0xFX1RSSUFMIiwiUk9MRV9VU0VSUyIsIlJPTEVfV0VCSE9PSyJdLCJpZCI6MTYxLCJleHAiOjE3ODQxMzAxNTV9.OltbyFu9lhesfB05JcKtsV1J6kfb_9L70V1WPuBzNLZB5V8cAxEcDLGf1guqI6KQQNOtPzaAMUUPsd-WhuWRAA");
        return conexao;
    }

    public void cadastrarContato(String numero, String nome, String mooorseId) {
        try {
            JSONObject j = new JSONObject();
            j.put("integrationId", (Object)mooorseId);
            j.put("number", (Object)numero);
            j.put("name", (Object)nome);
            ExternalConnection conexao = this.getConexao();
            JSONObject jsonReturn = conexao.setJsonParameters(j).executePost("https://api.moorse.io/v1/contacts").toJsonObject();
            if (!jsonReturn.has("data")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JSONObject sendButton(String numero, String title, String subtitle, List<String> buttons, String moorseId) {
        try {
            WhatsAppButtonRequest req = new WhatsAppButtonRequest(numero, title, subtitle, buttons);
            ExternalConnection conexao = this.getConexao();
            String jsonInString = new Gson().toJson((Object)req);
            JSONObject json = new JSONObject(jsonInString);
            JSONObject jsonReturn = conexao.setJsonParameters(json).executePost("https://api.moorse.io/v2/whatsapp/" + moorseId + "/send-buttons").toJsonObject();
            if (!jsonReturn.has("data")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
            if (!jsonReturn.getJSONObject("data").getString("message").contains("Mensagem encaminhada")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
            return jsonReturn;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public Boolean checkIntegration(String mooserId) {
        try {
            ExternalConnection conexao = this.getConexao();
            JSONObject jsonReturn = conexao.executeGet("https://api.moorse.io/v2/whatsapp/" + mooserId + "/status").toJsonObject();
            if (!jsonReturn.has("data")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
            if (!jsonReturn.getJSONObject("data").has("status")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
            return jsonReturn.getJSONObject("data").getString("status").equals("RUNNING");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public JSONObject sendText(String numero, String mensagem, String mooserId) {
        try {
            JSONObject jsonReturn;
            WhatsAppMessageRequest req = new WhatsAppMessageRequest(numero, mensagem);
            ExternalConnection conexao = this.getConexao();
            String jsonInString = new Gson().toJson((Object)req);
            JSONObject json = new JSONObject(jsonInString);
            String html = conexao.setJsonParameters(json).executePost("https://api.moorse.io/v2/whatsapp/" + mooserId + "/send-message").getReturnedHtml();
            try {
                jsonReturn = new JSONObject(html);
            }
            catch (Exception ex) {
                throw new BusinessException("Erro ao enviar msg: " + html);
            }
            if (!jsonReturn.has("data") && jsonReturn.has("errors")) {
                JSONArray a = jsonReturn.getJSONArray("errors");
                throw new BusinessException(a.toString());
            }
            if (!jsonReturn.has("data")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
            if (!jsonReturn.getJSONObject("data").getString("message").contains("Mensagem encaminhada")) {
                throw new BusinessException("Erro no retorno " + jsonReturn.toString());
            }
            return jsonReturn;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public JSONObject sendFile(WhatsAppMensagem message, String hash) throws Exception {
        String moorseId = message.getWhatsappAtendimento().getWhatsapp().getWhatsappConta().getMooseId();
        return this.sendFile(message.getWhatsappAtendimento().getWhatsapp().getNumero(), hash, message.getFileName(), moorseId, Boolean.valueOf(message.getContentTipo().equals((Object)WhatsAppContentTipoEnum.AUDIO)));
    }

    public JSONObject sendFile(String numero, String hash, String fileName, String moorseId, Boolean audio) throws Exception {
        ExternalConnection conexao = this.getConexao();
        if (hash == null || hash.isEmpty()) {
            throw new BusinessException("Tipo arquivo com hash zerada");
        }
        WhatsAppMessageFileRequest req = new WhatsAppMessageFileRequest(numero, StorageUtil.getUrlSign((String)hash, (String)"bucket-neosales").getUrl(), fileName, audio != false ? "Audio" : "");
        String jsonInString = new Gson().toJson((Object)req);
        JSONObject json = new JSONObject(jsonInString);
        String html = conexao.setJsonParameters(json).executePost("https://api.moorse.io/v2/whatsapp/" + moorseId + "/send-file").getReturnedHtml();
        JSONObject jsonReturn = new JSONObject(html);
        if (!jsonReturn.has("data")) {
            throw new BusinessException("Erro no retorno " + jsonReturn.toString());
        }
        if (!jsonReturn.getJSONObject("data").getString("message").contains("Mensagem encaminhada")) {
            throw new BusinessException("Erro no retorno " + jsonReturn.toString());
        }
        return jsonReturn;
    }

    public JSONObject sendTemplate(WhatsAppMensagem message) throws Exception {
        JSONArray arrParam = new JSONArray();
        JSONObject param = new JSONObject();
        param.put("type", (Object)"text");
        param.put("text", (Object)message.getContent().replace("\n", " ").replace("(?i)ola", "").replace("(?i)ol\u00e1", "").replace("(?i)ol\u00c1", "").trim());
        arrParam.put((Object)param);
        JSONArray arrComp = new JSONArray();
        JSONObject comp = new JSONObject();
        comp.put("type", (Object)"body");
        comp.put("parameters", (Object)arrParam);
        arrComp.put((Object)comp);
        return this.sendTemplate(message.getWhatsappAtendimento().getWhatsapp().getNumero(), arrComp, message.getWhatsappAtendimento().getWhatsapp().getWhatsappConta().getMooseId(), message.getWhatsappAtendimento().getWhatsapp().getWhatsappConta().getTemplateName());
    }

    public JSONObject sendTemplate(String numero, String msg, String moorseId, String templateName) throws Exception {
        JSONArray arrParam = new JSONArray();
        JSONObject param = new JSONObject();
        param.put("type", (Object)"text");
        param.put("text", (Object)msg.replace("\n", " ").replaceAll("(?i)ola", "").replaceAll("(?i)ol\u00e1", "").replaceAll("(?i)ol\u00c1", "").trim());
        arrParam.put((Object)param);
        JSONArray arrComp = new JSONArray();
        JSONObject comp = new JSONObject();
        comp.put("type", (Object)"body");
        comp.put("parameters", (Object)arrParam);
        arrComp.put((Object)comp);
        return this.sendTemplate(numero, arrComp, moorseId, templateName);
    }

    public JSONObject sendLista(String numero, String moorseId, List<String> lista) throws Exception {
        if (lista.size() <= 0) {
            throw new Exception("Lista n\u00e3o informada");
        }
        JSONObject jEnvio = new JSONObject();
        jEnvio.put("to", (Object)numero);
        jEnvio.put("body", (Object)"Informe o motivo do seu contato:");
        JSONObject actions = new JSONObject();
        JSONArray sections = new JSONArray();
        actions.put("sections", (Object)sections);
        JSONObject objSections = new JSONObject();
        objSections.put("title", (Object)"Op\u00e7\u00f5es");
        JSONArray rows = new JSONArray();
        for (String l : lista) {
            JSONObject jl = new JSONObject();
            jl.put("id", (Object)l);
            jl.put("title", (Object)l);
            rows.put((Object)jl);
        }
        objSections.put("rows", (Object)rows);
        sections.put((Object)objSections);
        jEnvio.put("action", (Object)actions);
        ExternalConnection conexao = this.getConexao();
        JSONObject jsonReturn = conexao.setJsonParameters(jEnvio).executePost("https://api.moorse.io/v2/whatsapp/" + moorseId + "/send-list-menu").toJsonObject();
        if (!jsonReturn.has("data")) {
            throw new BusinessException("Erro no retorno " + jsonReturn.toString());
        }
        if (!jsonReturn.getJSONObject("data").getString("message").contains("Mensagem encaminhada")) {
            throw new BusinessException("Erro no retorno " + jsonReturn.toString());
        }
        return jsonReturn;
    }

    public JSONObject sendTemplate(String numero, JSONArray arrComp, String moorseId, String templateName) throws Exception {
        templateName = templateName == null || templateName.isEmpty() ? "generic" : templateName;
        JSONObject json = new JSONObject();
        if (arrComp.length() > 0) {
            json.put("components", (Object)arrComp);
        }
        json.put("templateName", (Object)templateName);
        json.put("to", (Object)numero);
        ExternalConnection conexao = this.getConexao();
        String html = conexao.setJsonParameters(json).executePost("https://api.moorse.io/v2/whatsapp/" + moorseId + "/send-template").getReturnedHtml();
        JSONObject jsonReturn = new JSONObject(html);
        if (!jsonReturn.has("data")) {
            throw new BusinessException("Erro no retorno " + jsonReturn.toString());
        }
        if (!jsonReturn.getJSONObject("data").getString("message").contains("Mensagem encaminhada")) {
            throw new BusinessException("Erro no retorno " + jsonReturn.toString());
        }
        return jsonReturn;
    }

    public JSONObject send(WhatsAppMensagem message) throws Exception {
        String moorseId = message.getWhatsappAtendimento().getWhatsapp().getWhatsappConta().getMooseId();
        if (message.getContentTipo().equals((Object)WhatsAppContentTipoEnum.TEXTO)) {
            return this.sendText(message.getWhatsappAtendimento().getWhatsapp().getNumero(), message.getContent(), moorseId);
        }
        if (message.getContentTipo().equals((Object)WhatsAppContentTipoEnum.BUTTONS)) {
            ArrayList<String> buttons = new ArrayList<String>();
            for (String s : message.getButtons().split(",")) {
                buttons.add(s);
            }
            return this.sendButton(message.getWhatsappAtendimento().getWhatsapp().getNumero(), message.getTitle(), message.getSubtitle(), buttons, moorseId);
        }
        if (message.getContentTipo().equals((Object)WhatsAppContentTipoEnum.LISTA)) {
            String[] arr;
            ArrayList<String> lista = new ArrayList<String>();
            for (String s : arr = message.getContent().split(",")) {
                lista.add(s);
            }
            return this.sendLista(message.getWhatsappAtendimento().getWhatsapp().getNumero(), moorseId, lista);
        }
        if (message.getContentTipo().equals((Object)WhatsAppContentTipoEnum.TEMPLATE)) {
            return this.sendTemplate(message);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            System.out.println(new WhatsAppMoorseApi().temWhats("79999764200"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject temWhats(String numero) throws Exception {
        if (!((String)numero).startsWith("55") || ((String)numero).length() < 12) {
            numero = "55" + (String)numero;
        }
        if (((String)numero).length() < 12) {
            throw new BusinessException("numero invalido: " + (String)numero);
        }
        ExternalConnection conexao = this.getConexao();
        JSONObject j = conexao.executeGet("https://api.moorse.io/v1/verify-number?phone=" + (String)numero).toJsonObject();
        if (!j.has("data")) {
            throw new BusinessException("Erro no retorno " + j.toString());
        }
        JSONObject jd = j.getJSONObject("data");
        if (!jd.has("exist") || !jd.getBoolean("exist")) {
            try {
                ExternalConnection conexaoFallback = new ExternalConnection();
                conexaoFallback.addHeaderDefault("apikey", "8CDFEDA21624-4929-B78F-EBA8342AB718");
                conexaoFallback.addHeaderDefault("Content-Type", "application/json");
                JSONObject requestBody = new JSONObject();
                JSONArray numbersArray = new JSONArray();
                numbersArray.put(numero);
                requestBody.put("numbers", (Object)numbersArray);
                String responseStr = conexaoFallback.setJsonParameters(requestBody).executePost("https://wpp.solucoes.plus/chat/whatsappNumbers/consulta_wpp").getReturnedHtml();
                JSONArray response = new JSONArray(responseStr);
                if (response.length() > 0) {
                    JSONObject result = response.getJSONObject(0);
                    JSONObject convertedResponse = new JSONObject();
                    JSONObject data = new JSONObject();
                    data.put("exist", result.optBoolean("exists", false));
                    data.put("jid", (Object)result.optString("jid", ""));
                    data.put("number", (Object)result.optString("number", ""));
                    convertedResponse.put("data", (Object)data);
                    System.out.println(convertedResponse);
                    return convertedResponse;
                }
                throw new BusinessException("Nenhum resultado retornado da API alternativa");
            }
            catch (Exception ex) {
                return j;
            }
        }
        return j;
    }

    public WhatsMoorseBillingDTO getBilling(String moorseId) throws Exception {
        WhatsMoorseBillingDTO retorno = new WhatsMoorseBillingDTO();
        ExternalConnection conexao = this.getConexao();
        JSONObject j = conexao.executeGet("https://api.moorse.io/v1/billings/integration/" + moorseId).toJsonObject();
        if ((j = j.optJSONObject("data")) == null) {
            throw new BusinessException("Erro no retorno: json data not found");
        }
        JSONArray arr = j.optJSONArray("items");
        if (arr == null) {
            throw new BusinessException("Erro no retorno " + j.toString());
        }
        ArrayList<WhatsMoorseBillingItemDTO> itens = new ArrayList<WhatsMoorseBillingItemDTO>();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject obj = arr.getJSONObject(i);
            WhatsMoorseBillingItemDTO item = new WhatsMoorseBillingItemDTO();
            item.setQuantidade(Integer.valueOf(obj.optInt("total")));
            item.setTipo(obj.optString("billingType"));
            item.setValorTotal(Double.valueOf(obj.optDouble("amount")));
            item.setValorUnitario(Double.valueOf(obj.optDouble("unitPrice")));
            itens.add(item);
        }
        retorno.setItens(itens);
        retorno.setMinimoMensal(Double.valueOf(j.optDouble("minAmount")));
        retorno.setValorTotal(Double.valueOf(j.optDouble("actualAmount")));
        return retorno;
    }
}

