/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service;

import br.com.system.app.features.broadcast.service.BroadcasterWhats;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppStatusEnum;
import br.com.system.app.features.whatsapp.service.WhatsAppLogService;
import br.com.system.app.features.whatsapp.service.WhatsAppRecebimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppStatusService;
import br.com.system.app.features.whatsapp.service.WhatsAppWebhookMoorse;
import br.com.system.commons.InputStreamUtil;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.SleepUtil;
import com.vdurmont.emoji.EmojiParser;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppWebhookMoorse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private WhatsAppStatusService whatsAppStatusService;
    @Autowired
    private WhatsAppRecebimentoService whatsAppRecebimentoService;
    @Autowired
    private WhatsAppLogService whatsAppLogService;

    public void webhook(ServletRequest request, ServletResponse response) {
        PrintWriter out;
        try {
            out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("json");
        }
        catch (IOException e) {
            return;
        }
        JSONObject jsonBody = null;
        try {
            String token = request.getParameter("token");
            if (!token.equals("6262f94f0c79dedb1fda444dc283ec8b531087b412dc2ffa20a4cbf5300eeed7")) {
                this.printErro("Token invalido", out);
                return;
            }
            String body = InputStreamUtil.toString((InputStream)request.getInputStream());
            if (body.isEmpty()) {
                this.printErro("Body is empty", out);
                return;
            }
            jsonBody = new JSONObject(body);
            if (!(jsonBody.has("status") && jsonBody.has("integrationId") && jsonBody.has("from"))) {
                this.printErro("json invalido", out);
                return;
            }
            this.emojiToDecimal(jsonBody);
            SleepUtil.inMiliseconds((Integer)RandomUtil.getRandom((Integer)0, (Integer)3000));
            this.whatsAppLogService.gravar(jsonBody);
            WhatsAppAtendimento wam = null;
            WhatsAppStatusEnum status = jsonBody.getString("status").equals("ERROR") ? WhatsAppStatusEnum.ERRO : WhatsAppStatusEnum.valueOf((String)jsonBody.getString("status"));
            switch (1.$SwitchMap$br$com$system$app$features$whatsapp$model$WhatsAppStatusEnum[status.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    wam = this.whatsAppStatusService.controlar(jsonBody);
                    break;
                }
                case 4: {
                    wam = this.whatsAppRecebimentoService.respondido(jsonBody, null);
                    break;
                }
                case 5: {
                    wam = this.whatsAppRecebimentoService.errorReceived(jsonBody);
                    break;
                }
                default: {
                    this.printErro("Status invalido", out);
                    return;
                }
            }
            if (wam != null) {
                BroadcasterWhats.broadcast((WhatsAppAtendimento)wam);
            }
            this.printSucesso(out);
        }
        catch (Exception e) {
            this.printErro("Erro " + e.getMessage(), out);
        }
    }

    private void printSucesso(PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", true);
        jsonRetorno.put("erro", (Object)"");
        out.print(jsonRetorno.toString());
    }

    private void printErro(String msg, PrintWriter out) {
        JSONObject jsonRetorno = new JSONObject();
        jsonRetorno.put("success", false);
        jsonRetorno.put("erro", (Object)msg);
        out.print(jsonRetorno.toString());
    }

    private void emojiToDecimal(JSONObject jsonBody) {
        try {
            JSONObject j;
            if (jsonBody.has("content") || !jsonBody.isNull("content")) {
                jsonBody.put("content", (Object)EmojiParser.parseToHtmlDecimal((String)jsonBody.getString("content")));
            }
            if (jsonBody.has("contactUser") && (j = jsonBody.getJSONObject("contactUser")).has("name") && !j.isNull("name")) {
                j.put("name", (Object)"");
                jsonBody.put("contactUser", (Object)j);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

