/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.whatsapp.service.bot;

import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteContatoVerficadoEnum;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.whatsapp.model.WhatsApp;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendente;
import br.com.system.app.features.whatsapp.model.WhatsAppAtendimento;
import br.com.system.app.features.whatsapp.model.WhatsAppEtapaEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppFuncaoEnum;
import br.com.system.app.features.whatsapp.model.WhatsAppMensagem;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendenteService;
import br.com.system.app.features.whatsapp.service.WhatsAppAtendimentoService;
import br.com.system.app.features.whatsapp.service.WhatsAppControleService;
import br.com.system.app.features.whatsapp.service.WhatsAppSendService;
import br.com.system.app.features.whatsapp.service.WhatsAppService;
import br.com.system.app.features.whatsapp.service.WhatsAppTimeService;
import br.com.system.app.features.whatsapp.service.bot.MensagemTipo;
import br.com.system.commons.RandomUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppBotGoldcell2
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private WhatsAppSendService sendService;
    @Autowired
    private WhatsAppAtendenteService whatsAppAtendenteService;
    @Autowired
    private WhatsAppAtendimentoService whatsAppAtendimentoService;
    @Autowired
    private WhatsAppControleService whatsAppControleService;
    @Autowired
    private WhatsAppTimeService whatsAppTimeService;
    @Autowired
    private EstruturaUsuarioService estruturaUsuarioService;
    @Autowired
    private SessionsService sessionsService;
    private final Map<Integer, MensagemTipo> listaTipo = new HashMap();

    public void notBot(WhatsAppMensagem wm, EstruturaUsuario master) {
        WhatsAppAtendimento wa = wm.getWhatsappAtendimento();
        WhatsApp w = wa.getWhatsapp();
        List a = this.whatsAppAtendenteService.getByConta(wm.getWhatsappAtendimento().getWhatsapp().getWhatsappConta());
        if (a.size() <= 0) {
            w.setUltimoAtendente(master);
            wa.setAtendente(master);
        } else {
            EstruturaUsuario eu = ((WhatsAppAtendente)a.get(RandomUtil.getRandom((Integer)(a.size() - 1)))).getEstruturaUsuario();
            w.setUltimoAtendente(eu);
            wa.setAtendente(eu);
        }
        w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
        this.whatsAppControleService.gravarNova(wm, wm.getStatus());
    }

    public void botDefault(WhatsAppAtendimento wa, EstruturaUsuario master, String resposta) {
        WhatsApp w = wa.getWhatsapp();
        if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.INICIAL)) {
            w.setUltimoAtendente(master);
            wa.setAtendente(master);
            if (w.getCpfCnpj() == null || w.getEmail() == null || w.getNome() == null || w.getFuncao() == null) {
                this.sendService.sendMessageText(wa, master, "Ol\u00e1, tudo bem? Sou o Goldinho, o assistente virtual da Gold Empresas e eu vou ajuda-lo at\u00e9 voc\u00ea ser transferido para um atendente.");
                this.sendService.sendMessageText(wa, master, "Seu telefone ainda n\u00e3o est\u00e1 no nosso cadastro. Vamos faz\u00ea-lo agora.\n\u00c9 rapidinho, apenas 4 perguntas.\n\nInforme por favor o CNPJ da sua empresa");
                w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
            } else {
                this.mostrarCnpj(w, wa, master, false);
                w.setEtapa(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.ESCOLHA_CNPJ)) {
            if (resposta.equals("Inserir Novo")) {
                String[] cnpjs = w.getCpfCnpj().split(",");
                if (cnpjs.length >= 3) {
                    w.setEtapa(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
                    wa.setEtapa(WhatsAppEtapaEnum.ESCOLHA_CNPJ);
                    this.sendService.sendMessageText(wa, master, "Este n\u00famero n\u00e3o pode ser usado pois j\u00e1 tem tr\u00eas cadastros ativos.");
                    this.mostrarCnpj(w, wa, master, true);
                } else {
                    this.sendService.sendMessageText(wa, master, "Ok, Poderia me informar o CNPJ para cadastro?");
                    w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                    wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                }
            } else {
                if (!ValidationUtil.isValidCnpjAndCpf((String)resposta) || !w.getCpfCnpj().contains(resposta)) {
                    this.mostrarCnpj(w, wa, master, false);
                    w.setDataErro(LocalDate.now());
                    w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                    this.whatsAppService.save(w);
                    return;
                }
                if (!this.whatsAppTimeService.noHorario(wa)) {
                    this.whatsAppTimeService.sendOffTime(wa);
                    return;
                }
                this.sendService.sendMessageText(wa, master, "Legal, encontramos seu cadastro em nosso sistema. Agora para facilitar o atendimento, digite uma das op\u00e7\u00f5es abaixo");
                this.sendService.sendMessageText(wa, master, this.getMensagemTipo());
                w.setEtapa(WhatsAppEtapaEnum.OPCOES);
                w.setCnpjEscolhido(resposta);
                wa.setCnpj(w.getCnpjEscolhido());
                wa.setEtapa(WhatsAppEtapaEnum.OPCOES);
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.CPF_CNPJ)) {
            String cpfCnpj = StringUtil.numbersOnly((String)resposta);
            if (!ValidationUtil.isValidCnpjAndCpf((String)cpfCnpj)) {
                this.sendService.sendMessageText(wa, master, "Ops! Este CNPJ (" + resposta + ") parece estar inv\u00e1lido, vamos tentar novamente?\nInforme seu Cnpj");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            if (w.getCpfCnpj() == null || w.getCpfCnpj().isEmpty()) {
                w.setCpfCnpj(cpfCnpj);
            } else {
                w.setCpfCnpj(w.getCpfCnpj() + "," + cpfCnpj);
            }
            this.sendService.sendMessageText(wa, master, "Vou procurar em nosso banco de dados");
            Cliente cliente = this.clienteService.getAndCreateCliente(master, cpfCnpj, new ClienteContato[0]);
            if (cliente.getNome() != null && !cliente.getNome().isEmpty()) {
                this.sendService.sendMessageText(wa, master, "Encontrei, " + cliente.getNome());
            }
            if (w.getCpfCnpj().length() > 20 && w.getNome() != null && w.getEmail() != null && w.getFuncao() != null) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("Nova solicita\u00e7\u00e3o");
                this.sendService.sendButton(wa, master, "Obrigado. CNPJ inserido com sucesso em seu cadastro.\nCaso voc\u00ea tenha alguma solicita\u00e7\u00e3o, clique no bot\u00e3o que direcionamos o seu atendimento para nosso p\u00f3s-venda. Se voc\u00ea queria apenas cadastrar o CNPJ, fique tranquilo, ele j\u00e1 foi cadastrado.", "", buttons);
                this.whatsAppAtendimentoService.fechar(wa, master, true);
                return;
            }
            if (cpfCnpj.length() == 11 && cliente.getNome() != null && !cliente.getNome().isEmpty()) {
                w.setEtapa(WhatsAppEtapaEnum.EMAIL);
                wa.setEtapa(WhatsAppEtapaEnum.EMAIL);
                w.setNome(cliente.getNome());
                this.sendService.sendMessageText(wa, master, "Certo. Agora gostaria de saber seu e-mail");
            } else {
                w.setEtapa(WhatsAppEtapaEnum.NOME);
                wa.setEtapa(WhatsAppEtapaEnum.NOME);
                this.sendService.sendMessageText(wa, master, "Agora informe seu nome completo");
            }
            w.setCnpjEscolhido(cpfCnpj);
            wa.setCnpj(w.getCnpjEscolhido());
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.NOME)) {
            String nome = resposta;
            if (nome.split(" ").length < 2) {
                this.sendService.sendMessageText(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida, informe seu nome completo, com NOME e SOBRENOME");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setEtapa(WhatsAppEtapaEnum.EMAIL);
            w.setNome(nome);
            this.sendService.sendMessageText(wa, master, "Certo. Agora gostaria de saber seu e-mail");
            wa.setEtapa(WhatsAppEtapaEnum.EMAIL);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.EMAIL)) {
            String email = resposta.trim();
            if (!ValidationUtil.isValidEmail((String)email)) {
                this.sendService.sendMessageText(wa, master, "Este E-mail(" + email + ") parece estar inv\u00e1lido, vamos tentar novamente?\nInforme seu E-mail");
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            try {
                ClienteContato cc = new ClienteContato(TipoContatoEnum.EMAIL, email, ClienteContatoVerficadoEnum.VALIDO);
                this.clienteService.getAndCreateCliente(master, w.getCnpjEscolhido(), new ClienteContato[]{cc});
            }
            catch (Exception e) {
                System.out.println("Erro whatsapp ao gravar email no cliente " + e.getMessage());
            }
            w.setEtapa(WhatsAppEtapaEnum.FUNCAO);
            w.setEmail(email);
            ArrayList<String> buttons = new ArrayList<String>();
            buttons.add("S\u00f3cio");
            buttons.add("Colaborador");
            buttons.add("Outros");
            this.sendService.sendButton(wa, master, "Qual sua fun\u00e7\u00e3o na empresa?", "", buttons);
            wa.setEtapa(WhatsAppEtapaEnum.FUNCAO);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.FUNCAO)) {
            if (resposta == null || resposta.isEmpty() || !resposta.equals("S\u00f3cio") && !resposta.equals("Colaborador") && !resposta.equals("Outros")) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("S\u00f3cio");
                buttons.add("Colaborador");
                buttons.add("Outros");
                this.sendService.sendButton(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida Selecione", "", buttons);
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            WhatsAppFuncaoEnum fn = WhatsAppFuncaoEnum.getByResposta((String)resposta);
            if (fn == null) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("S\u00f3cio");
                buttons.add("Colaborador");
                buttons.add("Outros");
                this.sendService.sendButton(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida selecione", "", buttons);
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            w.setFuncao(fn);
            w.setEtapa(WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO);
            wa.setEtapa(WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO);
            ArrayList<String> buttons = new ArrayList<String>();
            buttons.add("Est\u00e1 correto");
            buttons.add("Corrigir");
            this.sendService.sendButton(wa, master, "Ok, por favor confira seus dados:\nCNPJ(s) " + w.getCnpjEscolhido() + "\nNome: " + w.getNome() + "\nEmail: " + w.getEmail() + "\nFun\u00e7\u00e3o: " + w.getFuncao().name(), "Selecione a op\u00e7\u00e3o", buttons);
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.CONFIRMACAO_CADASTRO)) {
            if (resposta.isEmpty() || !resposta.equals("Est\u00e1 correto") && !resposta.equals("Corrigir")) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("Est\u00e1 correto");
                buttons.add("Corrigir");
                this.sendService.sendButton(wa, master, "Informa\u00e7\u00e3o inv\u00e1lida Selecione", "", buttons);
                w.setDataErro(LocalDate.now());
                w.setErros(Integer.valueOf(w.getErros() == null ? 0 : w.getErros() + 1));
                this.whatsAppService.save(w);
                return;
            }
            if (resposta.equals("Est\u00e1 correto")) {
                ArrayList<String> buttons = new ArrayList<String>();
                buttons.add("Abrir Atendimento");
                this.sendService.sendButton(wa, master, "Obrigado. Seu cadastro foi concluido com sucesso", "Quer falar com um atendente? Clique abaixo!", buttons);
                Cliente cliente = this.clienteService.getAndCreateCliente(master, wa.getCnpj(), new ClienteContato[0]);
                cliente.setCadastroWhatsapp(Boolean.valueOf(true));
                this.clienteService.salvar(cliente, master);
                this.whatsAppAtendimentoService.fechar(wa, master, true);
                return;
            }
            if (resposta.equals("Corrigir")) {
                w.setNome(null);
                w.setEmail(null);
                w.setCpfCnpj(null);
                w.setFuncao(null);
                w.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                wa.setEtapa(WhatsAppEtapaEnum.CPF_CNPJ);
                this.sendService.sendMessageText(wa, master, "Ok, vamos iniciar o cadastro novamente.\nInforme seu CNPJ");
            }
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.OPCOES)) {
            Integer opcao = this.getOpcao(resposta);
            if (opcao == null) {
                this.sendService.sendMessageText(wa, master, "Op\u00e7\u00e3o Inv\u00e1lida. Escolha uma op\u00e7\u00e3o de 1 a 7.");
                return;
            }
            wa.setEscolhaTipo(((MensagemTipo)this.listaTipo.get(opcao)).getTexto());
            EstruturaUsuario eu = this.getAtendente(w, master, opcao);
            w.setUltimoAtendente(eu);
            wa.setAtendente(eu);
            WhatsAppMensagem m = this.sendService.sendMessageText(wa, master, "Certo! Por favor descreva sua solicita\u00e7\u00e3o para que possamos encaminhar para atendimento de forma mais eficiente.");
            w.setEtapa(WhatsAppEtapaEnum.RESUMO);
            wa.setEtapa(WhatsAppEtapaEnum.RESUMO);
            this.whatsAppControleService.gravarNova(m, m.getStatus());
        } else if (wa.getEtapa().equals((Object)WhatsAppEtapaEnum.RESUMO)) {
            WhatsAppMensagem m = this.whatsAppTimeService.isAlmoco(wa.getWhatsapp().getWhatsappConta()) ? this.whatsAppTimeService.sendAlmoco(wa) : this.sendService.sendMessageText(wa, master, "Ok! Obrigado \nSua solicita\u00e7\u00e3o j\u00e1 foi direcionada. Por gentileza, aguarde um momento e nossos atendentes j\u00e1 ir\u00e3o lhe atender");
            wa.setDataHoraTransferencia(LocalDateTime.now());
            wa.setFechado(false);
            w.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            wa.setEtapa(WhatsAppEtapaEnum.ATENDENTE);
            this.whatsAppControleService.gravarNova(m, m.getStatus());
        }
        w.setDataErro(null);
        w.setErros(Integer.valueOf(0));
        this.whatsAppService.save(w);
        this.whatsAppAtendimentoService.save(wa);
    }

    public EstruturaUsuario getAtendente(WhatsApp w, EstruturaUsuario master, Integer opcao) {
        List sessoes;
        EstruturaUsuario eu = this.estruturaUsuarioService.getById(Long.valueOf(45017L));
        if (opcao.equals(4) && !(sessoes = this.sessionsService.getAtivaByEu(eu)).isEmpty()) {
            return eu;
        }
        return this.whatsAppAtendenteService.getAtendente(w, master, null);
    }

    private void mostrarCnpj(WhatsApp w, WhatsAppAtendimento wa, EstruturaUsuario master, boolean mais3) {
        String[] cnpjs;
        ArrayList<String> buttons = new ArrayList<String>();
        for (String cnpj : cnpjs = w.getCpfCnpj().split(",")) {
            if (buttons.contains(cnpj)) continue;
            buttons.add(cnpj);
        }
        if (!mais3) {
            this.sendService.sendMessageText(wa, master, "Ol\u00e1 " + w.getNome() + ", Tudo bem? Sou o Goldinho, o assistente virtual da Gold Empresas e eu vou ajuda-lo at\u00e9 voc\u00ea ser transferido para um atendente.");
            this.sendService.sendButton(wa, master, "Para transferir seu atendimento, preciso que voc\u00ea selecione o CNPJ para qual deseja atendimento:", "", buttons);
        } else {
            this.sendService.sendButton(wa, master, "Para qual CNPJ ser\u00e1 o atendimento", "", buttons);
        }
        buttons.clear();
        if (!mais3) {
            buttons.add("Inserir Novo");
            this.sendService.sendButton(wa, master, "Caso n\u00e3o tenha encontrado o CNPJ que deseja atendimento, clique em \"Inserir Novo\"", "", buttons);
        }
    }

    private Integer getOpcao(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (StringUtil.numbersOnly((String)name).length() == name.length()) {
            if (Integer.valueOf(name) >= 1 && Integer.valueOf(name) <= this.listaTipo.size()) {
                return Integer.valueOf(name);
            }
        } else {
            for (Map.Entry entry : this.listaTipo.entrySet()) {
                if (((MensagemTipo)entry.getValue()).getTexto().equals(name)) {
                    return (Integer)entry.getKey();
                }
                if (!((MensagemTipo)entry.getValue()).getNumeralString().contains(name)) continue;
                return (Integer)entry.getKey();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        WhatsAppBotGoldcell2 bot = new WhatsAppBotGoldcell2();
        System.out.println(bot.getMensagemTipo());
        Map lista = bot.getmt();
        System.out.println(((MensagemTipo)lista.get(7)).getTexto());
    }

    public Map<Integer, MensagemTipo> getmt() {
        return this.listaTipo;
    }

    public String getMensagemTipo() {
        this.listaTipo.clear();
        this.listaTipo.put(1, new MensagemTipo("1\ufe0f\u20e3", "Contratar um novo servi\u00e7o Vivo              ", "um"));
        this.listaTipo.put(2, new MensagemTipo("2\ufe0f\u20e3", "Ativar eSIM ou trocar chip                  ", "dois"));
        this.listaTipo.put(3, new MensagemTipo("3\ufe0f\u20e3", "Problemas com Portabilidade, linha ou servi\u00e7", "tres,tr\u00eas"));
        this.listaTipo.put(4, new MensagemTipo("4\ufe0f\u20e3", "Segunda via de fatura                       ", "quatro"));
        this.listaTipo.put(5, new MensagemTipo("5\ufe0f\u20e3", "Contestar valor da fatura                   ", "cinco"));
        this.listaTipo.put(6, new MensagemTipo("6\ufe0f\u20e3", "Acompanhar status do pedido                 ", "seis"));
        this.listaTipo.put(7, new MensagemTipo("7\ufe0f\u20e3", "Outros assuntos                             ", "sete"));
        return "1\ufe0f\u20e3 Contratar um novo servi\u00e7o Vivo\n2\ufe0f\u20e3 Ativar eSIM ou trocar chip\n3\ufe0f\u20e3 Problemas com Portabilidade, linha ou servi\u00e7o\n4\ufe0f\u20e3 Segunda via de fatura\n5\ufe0f\u20e3 Contestar valor da fatura\n6\ufe0f\u20e3 Acompanhar status do pedido\n7\ufe0f\u20e3 Outros assuntos";
    }
}

