/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.security;

import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.repository.UsuarioRepository;
import com.vaadin.flow.spring.security.AuthenticationContext;
import java.util.Optional;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class AuthenticatedUser {
    private final UsuarioRepository userRepository;
    private final AuthenticationContext authenticationContext;

    public AuthenticatedUser(AuthenticationContext authenticationContext, UsuarioRepository userRepository) {
        this.userRepository = userRepository;
        this.authenticationContext = authenticationContext;
    }

    public Optional<Usuario> get() {
        return this.authenticationContext.getAuthenticatedUser(UserDetails.class).map(userDetails -> this.userRepository.findByLogin(userDetails.getUsername()));
    }

    public void logout() {
        this.authenticationContext.logout();
    }
}

