/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.datetime;

import br.com.system.commons.StringUtil;
import br.com.system.commons.ValidationUtil;
import br.com.system.commons.datetime.FormatDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeUtil {
    public static final String DD = "dd";
    public static final String MM = "MM";
    public static final String YYYY = "yyyy";
    public static final String DD_MM = "dd/MM";
    public static final String MM_YYYY = "MM/yyyy";
    public static final String DD_MM_YY = "dd/MM/yy";
    public static final String DD_MM_YYYY = "dd/MM/yyyy";

    public static LocalDateTime getEndOfDay() {
        return LocalDate.now().atTime(LocalTime.MAX);
    }

    public static LocalDateTime getEndOfDay(LocalDate data) {
        return data.atTime(LocalTime.MAX);
    }

    public static String getMesAno(LocalDate m) {
        return StringUtil.zeroLeft((String)String.valueOf(m.getMonthValue()), (int)2) + "-" + m.getYear();
    }

    private DateTimeUtil() {
    }

    public static boolean isOpen(LocalTime start, LocalTime end, LocalTime time) {
        if (start.isAfter(end)) {
            return !time.isBefore(start) || !time.isAfter(end);
        }
        return !time.isBefore(start) && !time.isAfter(end);
    }

    public static LocalDate getFirstDayOfMonth(LocalDate date) {
        return date.withDayOfMonth(1);
    }

    public static LocalDate getLastDayOfMonth(LocalDate date) {
        if (date == null) {
            date = LocalDate.now();
        }
        return date.withDayOfMonth(date.lengthOfMonth());
    }

    public static LocalDateTime getDateTimeOfFirstDayOfMonth(LocalDate date) {
        return date.withDayOfMonth(1).atStartOfDay();
    }

    public static LocalDateTime getDateTimeOfLastDayOfMonth(LocalDate date) {
        if (date == null) {
            date = LocalDate.now();
        }
        return date.withDayOfMonth(date.lengthOfMonth()).atTime(LocalTime.MAX);
    }

    public static LocalDateTime timeStampToDate(String timeStamp) {
        if (timeStamp == null) {
            return null;
        }
        if (timeStamp.length() > 19) {
            timeStamp = timeStamp.substring(0, 19);
        }
        LocalDateTime dataFormatada = LocalDateTime.parse(timeStamp, DateTimeFormatter.ISO_DATE_TIME);
        return dataFormatada;
    }

    public static String normalizeBrDate(String brDate) {
        String[] arrDate = brDate.split("/");
        if (arrDate.length != 3) {
            return "";
        }
        for (int i = 0; i < arrDate.length; ++i) {
            if (arrDate[i].length() >= 2) continue;
            arrDate[i] = "0" + arrDate[i];
        }
        return arrDate[0] + "/" + arrDate[1] + "/" + arrDate[2];
    }

    public static String normalizeBrDateTime(String brDateTime) {
        int i;
        if (brDateTime == null) {
            return "";
        }
        String[] arr = brDateTime.split(" ");
        if (arr.length != 2) {
            return brDateTime;
        }
        String[] arrDate = arr[0].split("/");
        String[] arrTime = arr[1].split(":");
        if (arrTime.length == 2) {
            String aux = arr[1] + ":00";
            arrTime = aux.split(":");
        }
        if (arrDate.length != 3 || arrTime.length != 3) {
            return brDateTime;
        }
        for (i = 0; i < arrDate.length; ++i) {
            if (arrDate[i].length() >= 2) continue;
            arrDate[i] = "0" + arrDate[i];
        }
        for (i = 0; i < arrTime.length; ++i) {
            if (arrTime[i].length() >= 2) continue;
            arrTime[i] = "0" + arrTime[i];
        }
        return arrDate[0] + "/" + arrDate[1] + "/" + arrDate[2] + " " + arrTime[0] + ":" + arrTime[1] + ":" + arrTime[2];
    }

    public static String brToUsDate(String brDate) {
        if (brDate == null) {
            return "";
        }
        brDate = DateTimeUtil.parse((String)"dd/MM/yy", (String)"dd/MM/yyyy", (String)brDate);
        return DateTimeUtil.parse((String)"dd/MM/yyyy", (String)"yyyy-MM-dd", (String)brDate);
    }

    public static String usToBrDate(String usDate) {
        if (usDate == null) {
            return "";
        }
        return DateTimeUtil.parse((String)"yyyy-MM-dd", (String)"dd/MM/yyyy", (String)usDate);
    }

    public static String dbToBrDate(String dbDate) {
        return DateTimeUtil.usToBrDate((String)dbDate);
    }

    public static String getToday(FormatDate parseFormat) {
        Locale locale = new Locale("pt", "BR");
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat formatador = new SimpleDateFormat(parseFormat.getPattern(), locale);
        return formatador.format(calendar.getTime());
    }

    public static String getTodayDateDb() {
        return DateTimeUtil.getToday((FormatDate)FormatDate.US_DATE);
    }

    public static String getTodayTimeDb() {
        return DateTimeUtil.getToday((FormatDate)FormatDate.US_TIME);
    }

    public static LocalDate toDate(String dateText, FormatDate format) {
        if (dateText == null || dateText.isEmpty()) {
            return null;
        }
        if (StringUtil.isBlank((Object)(dateText = dateText.trim()))) {
            return null;
        }
        if (!format.name().contains("TIME") && dateText.length() > 10) {
            dateText = dateText.substring(0, 10);
        }
        if (format.equals((Object)FormatDate.DATE_BR)) {
            dateText = DateTimeUtil.normalizeBrDate((String)dateText);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format.getPattern());
        return LocalDate.parse(dateText, formatter);
    }

    public static LocalDateTime toDateTime(String dateText, FormatDate format) {
        if (StringUtil.isBlank((Object)(dateText = dateText.trim()))) {
            return null;
        }
        dateText = DateTimeUtil.normalizeBrDateTime((String)dateText);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format.getPattern());
        return LocalDateTime.parse(dateText, formatter);
    }

    public static Date calcDate(Date date, int fator) {
        return DateTimeUtil.calcDate((Date)date, (int)fator, (int)5);
    }

    public static Date calcDate(Date date, int factor, int calendarDateType) {
        if (ValidationUtil.hasAnyNull((Object[])new Object[]{date})) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarDateType, factor);
        return calendar.getTime();
    }

    public static String parse(String fromFmt, String toFmt, String input) {
        if (ValidationUtil.hasAnyNull((Object[])new Object[]{fromFmt, toFmt, input})) {
            return null;
        }
        try {
            SimpleDateFormat inFormat = new SimpleDateFormat(fromFmt);
            SimpleDateFormat outFormat = new SimpleDateFormat(toFmt);
            return outFormat.format(inFormat.parse(input));
        }
        catch (ParseException pe) {
            return "";
        }
    }

    public static String secondsToTime(long s) {
        Integer i = Long.valueOf(s).intValue();
        return DateTimeUtil.secondsToTime((Integer)i);
    }

    public static String secondsToTime(Integer s) {
        if (s == null) {
            return "";
        }
        Double hours = Math.floor(s / 3600);
        Double minutes = Math.floor(((double)s.intValue() - hours * 60.0 * 60.0) / 60.0);
        Double seconds = (double)s.intValue() - hours * 60.0 * 60.0 - minutes * 60.0;
        Integer hou = hours.intValue();
        Integer min = minutes.intValue();
        Integer sec = seconds.intValue();
        return StringUtil.zeroLeft((String)hou.toString(), (int)2) + ":" + StringUtil.zeroLeft((String)min.toString(), (int)2) + ":" + StringUtil.zeroLeft((String)sec.toString(), (int)2);
    }

    public static String intervaloEmHoras(LocalDateTime inicio, LocalDateTime fim) {
        if (inicio == null) {
            return "00:00:00";
        }
        if (fim == null) {
            fim = LocalDateTime.now();
        }
        long s = Duration.between(inicio, fim).getSeconds();
        return String.format("%d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    public static long diferencaEmMeses(LocalDate di, LocalDate df) {
        return ChronoUnit.MONTHS.between(di, df);
    }

    public static long diferencaEmDias(LocalDate di, LocalDate df) {
        return ChronoUnit.DAYS.between(di, df);
    }

    public static long diferencaEmMinutos(LocalDateTime di, LocalDateTime df) {
        return ChronoUnit.MINUTES.between(di, df);
    }
}

