/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.commons.json.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapListDeserializer
implements JsonDeserializer<List<Map<String, Object>>> {
    private static final Pattern JSON_DATA_VALUE_PATTERN = Pattern.compile("(\"?\\w*\"?):(\"?\\w*\"?)");

    public List<Map<String, Object>> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        List jsonObjects = this.splitJsonAsObjects(json);
        for (String jsonObj : jsonObjects) {
            maps.add(this.getJsonAsMap(jsonObj));
        }
        return maps;
    }

    private List<String> splitJsonAsObjects(JsonElement json) {
        ArrayList<String> jsonObjs = new ArrayList<String>();
        String strJson = json.toString();
        int iPos = -1;
        for (int x = 0; x < strJson.length(); ++x) {
            if (strJson.charAt(x) == '{') {
                iPos = x;
            }
            if (iPos == -1 || strJson.charAt(x) != '}') continue;
            jsonObjs.add(strJson.substring(iPos, x + 1));
            iPos = -1;
        }
        return jsonObjs;
    }

    private Map<String, Object> getJsonAsMap(String jsonObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Matcher m = JSON_DATA_VALUE_PATTERN.matcher(jsonObj);
        while (m.find()) {
            map.put(m.group(1), m.group(2));
        }
        return map;
    }
}

