/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.filereader.pdf.pdfbox;

import br.com.system.commons.exception.InvalidExtensionException;
import br.com.system.filereader.pdf.AbstractPDFReader;
import br.com.system.filereader.pdf.pdfbox.PDFReaderConfig;
import br.com.system.filereader.pdf.pdfbox.PDFStripperOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;

public final class PDFReader
extends AbstractPDFReader {
    private static final Logger LOGGER = Logger.getLogger(PDFReader.class.getName());
    private static final int FIRST_PAGE = 1;
    private final Set<PDFStripperOptions> options = new HashSet();
    private final PDFReaderConfig config;
    private PDFTextStripper stripper;
    private StringBuilder readContent;
    private PDDocument document;

    public PDFReader(File file) {
        super(file);
        this.options.add(PDFStripperOptions.SORT);
        this.options.add(PDFStripperOptions.IGNORE_BEADS);
        this.options.add(PDFStripperOptions.CONSIDER_EMBEDDED_FILES);
        this.options.add(PDFStripperOptions.FORCE);
        this.config = new PDFReaderConfig();
        this.config.update(this.options);
    }

    public PDFReader(byte[] fileContent) {
        super(fileContent);
        this.options.add(PDFStripperOptions.SORT);
        this.options.add(PDFStripperOptions.IGNORE_BEADS);
        this.options.add(PDFStripperOptions.CONSIDER_EMBEDDED_FILES);
        this.options.add(PDFStripperOptions.FORCE);
        this.config = new PDFReaderConfig();
        this.config.update(this.options);
    }

    public PDFReader(InputStream inputStream) {
        super(inputStream);
        this.options.add(PDFStripperOptions.SORT);
        this.options.add(PDFStripperOptions.IGNORE_BEADS);
        this.options.add(PDFStripperOptions.CONSIDER_EMBEDDED_FILES);
        this.options.add(PDFStripperOptions.FORCE);
        this.config = new PDFReaderConfig();
        this.config.update(this.options);
    }

    public PDFReader setOptions(PDFStripperOptions ... options) {
        if (options != null) {
            this.options.addAll(Arrays.asList(options));
            this.config.update(this.options);
        }
        return this;
    }

    public PDFReader setPassword(String pdfPassword) {
        this.config.setPassword(pdfPassword);
        return this;
    }

    public PDFReader setEncoding(String encoding) {
        this.config.setEncoding(encoding);
        return this;
    }

    public String readFirstPage() throws IOException {
        return this.readPage(1);
    }

    public String extractContent() throws InvalidExtensionException, InvalidPasswordException, IOException {
        return this.readAllPages();
    }

    public String readAllPages() throws IOException {
        return this.readPages(1, Integer.MAX_VALUE);
    }

    public String readPages(int startPage, int endPage) throws IOException {
        this.readContent = new StringBuilder();
        this.loadDocument();
        if (endPage > this.getPageCount()) {
            endPage = this.getPageCount();
        }
        if (startPage < 1) {
            startPage = 1;
        }
        if (startPage > endPage) {
            int tmp = startPage;
            startPage = endPage;
            endPage = tmp;
        }
        for (int page = startPage; page <= endPage; ++page) {
            this.readContent.append(this.readPage(page));
        }
        if (this.config.isConsiderEmbeddedFiles()) {
            this.readContent.append(this.extractEmbeddedFiles());
        }
        return this.readContent.toString();
    }

    public String readPage(int pageNo) throws IOException {
        this.loadDocument();
        this.loadStripper();
        if (this.document.getCurrentAccessPermission().canExtractContent() || this.config.isForce()) {
            this.stripper.setStartPage(pageNo);
            this.stripper.setEndPage(pageNo);
            try {
                return this.stripper.getText(this.document);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Erro na pagina: {0}", pageNo);
            }
        }
        return "";
    }

    public int getPageCount() {
        return this.document.getNumberOfPages();
    }

    public void close() {
        try {
            if (this.document != null) {
                LOGGER.info("Fechando recursos de I/O");
                this.document.close();
            }
        }
        catch (IOException ex) {
            LOGGER.severe("Erro ao fechar I/O");
        }
    }

    private void loadDocument() throws InvalidPasswordException, IOException {
        if (this.document == null) {
            this.document = this.file != null ? PDDocument.load((File)this.file, (String)this.config.getPassword()) : (this.bytes != null ? PDDocument.load((byte[])this.bytes, (String)this.config.getPassword()) : PDDocument.load((InputStream)this.inputStream, (String)this.config.getPassword()));
        }
    }

    private void loadStripper() throws IOException {
        if (this.stripper == null) {
            this.stripper = new PDFTextStripper();
            this.stripper.setSortByPosition(this.config.isSort());
            this.stripper.setShouldSeparateByBeads(this.config.isSeparateBeads());
        }
    }

    public String extractEmbeddedFiles() throws IOException {
        StringBuilder documentEmbeddedContent = new StringBuilder();
        PDDocumentCatalog catalog = this.document.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        try (InputStream fis = null;){
            Map embeddedFileNames;
            PDEmbeddedFilesNameTreeNode embeddedFiles;
            if (names != null && (embeddedFiles = names.getEmbeddedFiles()) != null && (embeddedFileNames = embeddedFiles.getNames()) != null) {
                for (Map.Entry ent : embeddedFileNames.entrySet()) {
                    PDComplexFileSpecification spec;
                    PDEmbeddedFile embdFile;
                    if (this.config.isDebug()) {
                        System.err.println("Processing embedded file " + (String)ent.getKey() + ":");
                    }
                    if ((embdFile = (spec = (PDComplexFileSpecification)ent.getValue()).getEmbeddedFile()) == null || !embdFile.getSubtype().equals("application/pdf")) continue;
                    if (this.config.isDebug()) {
                        System.err.println("  is PDF (size=" + embdFile.getSize() + ")");
                    }
                    fis = embdFile.createInputStream();
                    PDDocument embeddedDoc = PDDocument.load((InputStream)fis);
                    String embeddedContent = this.extractEmbeddedDocument(embeddedDoc);
                    documentEmbeddedContent.append(embeddedContent);
                }
            }
        }
        return documentEmbeddedContent.toString();
    }

    private String extractEmbeddedDocument(PDDocument embeddedDocument) throws IOException {
        PDDocument tmp = this.document;
        this.document = embeddedDocument;
        StringBuilder docContent = new StringBuilder();
        for (int pgNo = 1; pgNo <= embeddedDocument.getNumberOfPages(); ++pgNo) {
            String read = this.readPage(pgNo);
            if (read == null || read.isEmpty()) continue;
            docContent.append(read);
        }
        this.document = tmp;
        return docContent.toString();
    }
}

