/*
 * Decompiled with CFR 0.152.
 */
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import javax.print.PrintService;

public class ARMEscPosFix {
    private static final String TAG = "ARMEscPosFix";

    public static EscPos createFixedEscPos(String printerName) throws IOException {
        boolean isLinuxARM = ARMEscPosFix.isLinuxARM();
        if (!isLinuxARM) {
            System.out.println("ARMEscPosFix: N\u00e3o \u00e9 Linux ARM, usando EscPos padr\u00e3o");
            PrintService printService = PrinterOutputStream.getPrintServiceByName(printerName);
            return new EscPos(new PrinterOutputStream(printService));
        }
        System.out.println("ARMEscPosFix: Linux ARM detectado - aplicando corre\u00e7\u00f5es profundas");
        try {
            PrintService printService = PrinterOutputStream.getPrintServiceByName(printerName);
            if (printService == null) {
                throw new IOException("Impressora n\u00e3o encontrada: " + printerName);
            }
            ARMPrinterOutputStream armStream = new ARMPrinterOutputStream(printService, printerName);
            EscPos escPos = new EscPos(armStream);
            ARMEscPosFix.replaceInternalStream(escPos, armStream);
            return escPos;
        }
        catch (Exception e) {
            System.err.println("ARMEscPosFix: Falha ao criar EscPos corrigido: " + e.getMessage());
            PrintService printService = PrinterOutputStream.getPrintServiceByName(printerName);
            return new EscPos(new PrinterOutputStream(printService));
        }
    }

    private static void replaceInternalStream(EscPos escPos, ARMPrinterOutputStream armStream) {
        try {
            Field[] fields;
            Class<?> escPosClass = escPos.getClass();
            for (Field field : fields = escPosClass.getDeclaredFields()) {
                Object currentValue;
                field.setAccessible(true);
                if (!OutputStream.class.isAssignableFrom(field.getType()) || !((currentValue = field.get(escPos)) instanceof PrinterOutputStream) || currentValue instanceof ARMPrinterOutputStream) continue;
                System.out.println("ARMEscPosFix: Substituindo campo interno: " + field.getName());
                field.set(escPos, armStream);
            }
        }
        catch (Exception e) {
            System.err.println("ARMEscPosFix: Aviso - n\u00e3o foi poss\u00edvel substituir streams internos: " + e.getMessage());
        }
    }

    private static boolean isLinuxARM() {
        String os = System.getProperty("os.name", "").toLowerCase();
        String arch = System.getProperty("os.arch", "").toLowerCase();
        return os.contains("linux") && (arch.contains("arm") || arch.contains("aarch"));
    }

    private static class ARMPrinterOutputStream
    extends PrinterOutputStream {
        private String printerName;
        private PrintService printService;
        private boolean closed = false;
        private ByteArrayOutputStream dataBuffer;
        private static int instanceCount = 0;
        private int instanceId;

        public ARMPrinterOutputStream(PrintService printService, String printerName) throws IOException {
            super(printService);
            this.printService = printService;
            this.printerName = printerName;
            this.dataBuffer = new ByteArrayOutputStream();
            this.instanceId = ++instanceCount;
            System.out.println("ARMEscPosFix: Criado ARMPrinterOutputStream #" + this.instanceId + " para " + printerName);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.dataBuffer.write(b);
            if (this.dataBuffer.size() % 100 == 0) {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Buffer size: " + this.dataBuffer.size() + " bytes");
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.dataBuffer.write(b, off, len);
            System.out.println("ARMEscPosFix: #" + this.instanceId + " Escrevendo " + len + " bytes, buffer total: " + this.dataBuffer.size());
        }

        @Override
        public void flush() throws IOException {
            if (this.closed || this.dataBuffer.size() == 0) {
                return;
            }
            System.out.println("ARMEscPosFix: #" + this.instanceId + " FLUSH chamado - processando " + this.dataBuffer.size() + " bytes com ARM workarounds");
            try {
                byte[] data = this.dataBuffer.toByteArray();
                this.printWithARMWorkarounds(data);
                this.dataBuffer.reset();
                System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 ARM workarounds executados com sucesso");
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: #" + this.instanceId + " \u274c ARM workarounds falharam: " + e.getMessage());
                if (this.dataBuffer.size() < 10000) {
                    try {
                        System.out.println("ARMEscPosFix: #" + this.instanceId + " Tentando fallback para super.flush()");
                        byte[] fallbackData = this.dataBuffer.toByteArray();
                        this.dataBuffer.reset();
                        super.write(fallbackData);
                        super.flush();
                        System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 Fallback bem-sucedido");
                    }
                    catch (Exception fallbackError) {
                        System.err.println("ARMEscPosFix: #" + this.instanceId + " \u274c Fallback tamb\u00e9m falhou: " + fallbackError.getMessage());
                        throw new IOException("Ambos ARM workaround e fallback falharam", e);
                    }
                }
                throw new IOException("ARM workaround falhou e buffer muito grande para fallback", e);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " CLOSE chamado");
                try {
                    this.flush();
                }
                finally {
                    super.close();
                    this.closed = true;
                    System.out.println("ARMEscPosFix: #" + this.instanceId + " Stream fechado");
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void printWithARMWorkarounds(byte[] data) throws IOException {
            Path tempFile = null;
            try {
                Path tempDir = Paths.get("/tmp", new String[0]);
                if (!Files.exists(tempDir, new LinkOption[0])) {
                    tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                }
                tempFile = Files.createTempFile(tempDir, "armfix_" + this.instanceId + "_", ".prn", new FileAttribute[0]);
                Files.write(tempFile, data, new OpenOption[0]);
                try {
                    Process permProcess = Runtime.getRuntime().exec(new String[]{"chmod", "644", tempFile.toString()});
                    if (!permProcess.waitFor(3L, TimeUnit.SECONDS)) {
                        permProcess.destroyForcibly();
                    }
                }
                catch (Exception e) {
                    System.err.println("ARMEscPosFix: Aviso - chmod falhou: " + e.getMessage());
                }
                Thread.sleep(50L);
                if (!Files.exists(tempFile, new LinkOption[0])) throw new IOException("Arquivo tempor\u00e1rio inv\u00e1lido");
                if (Files.size(tempFile) == 0L) {
                    throw new IOException("Arquivo tempor\u00e1rio inv\u00e1lido");
                }
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Arquivo tempor\u00e1rio criado: " + String.valueOf(tempFile) + " (" + Files.size(tempFile) + " bytes)");
                boolean success = false;
                String lastError = "";
                if (this.tryLprWithoutH(tempFile)) {
                    success = true;
                }
                if (!success && this.tryLprRaw(tempFile)) {
                    success = true;
                }
                if (!success && this.tryCatLpr(tempFile)) {
                    success = true;
                }
                if (!success && this.tryLp(tempFile)) {
                    success = true;
                }
                if (!success && this.tryDdLpr(tempFile)) {
                    success = true;
                }
                if (!success) {
                    throw new IOException("Todas as estrat\u00e9gias ARM falharam. \u00daltimo erro: " + lastError);
                }
                if (tempFile == null) return;
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrompido durante impress\u00e3o ARM", e);
                }
                catch (Throwable throwable) {
                    if (tempFile == null) throw throwable;
                    try {
                        Files.deleteIfExists(tempFile);
                        throw throwable;
                    }
                    catch (Exception e2) {
                        System.err.println("ARMEscPosFix: Aviso - n\u00e3o foi poss\u00edvel deletar " + String.valueOf(tempFile) + ": " + e2.getMessage());
                    }
                    throw throwable;
                }
            }
            try {
                Files.deleteIfExists(tempFile);
                return;
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: Aviso - n\u00e3o foi poss\u00edvel deletar " + String.valueOf(tempFile) + ": " + e.getMessage());
                return;
            }
        }

        private boolean tryLprWithoutH(Path tempFile) {
            try {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Tentando lpr sem -h...");
                String[] cmd = new String[]{"lpr", "-P" + this.printerName, tempFile.toString()};
                Process process = Runtime.getRuntime().exec(cmd);
                boolean finished = process.waitFor(15L, TimeUnit.SECONDS);
                if (finished && process.exitValue() == 0) {
                    System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 lpr sem -h funcionou");
                    return true;
                }
                System.err.println("ARMEscPosFix: #" + this.instanceId + " lpr sem -h falhou: c\u00f3digo " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout"));
                return false;
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: #" + this.instanceId + " lpr sem -h exception: " + e.getMessage());
                return false;
            }
        }

        private boolean tryLprRaw(Path tempFile) {
            try {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Tentando lpr raw...");
                String[] cmd = new String[]{"lpr", "-P" + this.printerName, "-o", "raw", tempFile.toString()};
                Process process = Runtime.getRuntime().exec(cmd);
                boolean finished = process.waitFor(15L, TimeUnit.SECONDS);
                if (finished && process.exitValue() == 0) {
                    System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 lpr raw funcionou");
                    return true;
                }
                System.err.println("ARMEscPosFix: #" + this.instanceId + " lpr raw falhou: c\u00f3digo " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout"));
                return false;
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: #" + this.instanceId + " lpr raw exception: " + e.getMessage());
                return false;
            }
        }

        private boolean tryCatLpr(Path tempFile) {
            try {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Tentando cat | lpr...");
                String cmd = "cat \"" + tempFile.toString() + "\" | lpr -P" + this.printerName;
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd});
                boolean finished = process.waitFor(15L, TimeUnit.SECONDS);
                if (finished && process.exitValue() == 0) {
                    System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 cat | lpr funcionou");
                    return true;
                }
                System.err.println("ARMEscPosFix: #" + this.instanceId + " cat | lpr falhou: c\u00f3digo " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout"));
                return false;
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: #" + this.instanceId + " cat | lpr exception: " + e.getMessage());
                return false;
            }
        }

        private boolean tryLp(Path tempFile) {
            try {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Tentando lp...");
                String[] cmd = new String[]{"lp", "-d", this.printerName, tempFile.toString()};
                Process process = Runtime.getRuntime().exec(cmd);
                boolean finished = process.waitFor(15L, TimeUnit.SECONDS);
                if (finished && process.exitValue() == 0) {
                    System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 lp funcionou");
                    return true;
                }
                System.err.println("ARMEscPosFix: #" + this.instanceId + " lp falhou: c\u00f3digo " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout"));
                return false;
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: #" + this.instanceId + " lp exception: " + e.getMessage());
                return false;
            }
        }

        private boolean tryDdLpr(Path tempFile) {
            try {
                System.out.println("ARMEscPosFix: #" + this.instanceId + " Tentando dd + lpr...");
                String cmd = "dd if=\"" + tempFile.toString() + "\" | lpr -P" + this.printerName;
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", cmd});
                boolean finished = process.waitFor(15L, TimeUnit.SECONDS);
                if (finished && process.exitValue() == 0) {
                    System.out.println("ARMEscPosFix: #" + this.instanceId + " \u2705 dd + lpr funcionou");
                    return true;
                }
                System.err.println("ARMEscPosFix: #" + this.instanceId + " dd + lpr falhou: c\u00f3digo " + String.valueOf(finished ? Integer.valueOf(process.exitValue()) : "timeout"));
                return false;
            }
            catch (Exception e) {
                System.err.println("ARMEscPosFix: #" + this.instanceId + " dd + lpr exception: " + e.getMessage());
                return false;
            }
        }
    }
}

