/*
 * Decompiled with CFR 0.152.
 */
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.json.JSONObject;

public class ConfigLoader {
    private String urlAplication;
    private String scopeCompany;
    private String scopeBranch;
    private String scopePdv;
    private boolean blockPowerButton;
    private boolean blockStatusBar;
    private boolean printCommand;
    private boolean printInvoice;
    private String omsToken;
    private int cscId;
    private String csc;
    private int account_id;
    private int establishment_id;
    private int equipament_id;
    private int box_id;
    private boolean pinpadOnly;

    public void loadConfig(String numSerie, String model) throws InterruptedException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("identifier", numSerie);
        jsonObject.put("application", "totem");
        jsonObject.put("operational_system", "Linux");
        jsonObject.put("device", model);
        jsonObject.put("version", "1.0.0");
        String postData = jsonObject.toString();
        String urlString = "https://admin.automizei.com/api/equipaments.php";
        try {
            String response = this.sendPostRequest(urlString, postData);
            if (!response.equals("false")) {
                JSONObject jsonResponse = new JSONObject(response);
                this.urlAplication = jsonResponse.optString("url_aplication");
                this.scopeCompany = jsonResponse.optString("scope_company");
                this.scopeBranch = jsonResponse.optString("scope_branch");
                this.scopePdv = jsonResponse.optString("scope_pdv");
                this.blockPowerButton = jsonResponse.optBoolean("block_power_button");
                this.blockStatusBar = jsonResponse.optBoolean("block_status_bar");
                this.printCommand = jsonResponse.optBoolean("print_command");
                this.printInvoice = jsonResponse.optBoolean("print_invoice");
                this.omsToken = jsonResponse.optString("oms_token");
                this.cscId = jsonResponse.optInt("csc_id");
                this.csc = jsonResponse.optString("csc");
                this.account_id = jsonResponse.optInt("account_id");
                this.establishment_id = jsonResponse.optInt("establishment_id");
                this.equipament_id = jsonResponse.optInt("equipament_id");
                this.box_id = jsonResponse.optInt("box_id");
                this.pinpadOnly = jsonResponse.optBoolean("pinpad_only");
                System.out.println("scope_company: " + this.scopeCompany);
                this.saveToPreferences();
            } else {
                this.loadFromPreferences();
            }
        }
        catch (Exception e) {
            System.out.println("Erro: " + e.getMessage());
            this.loadFromPreferences();
        }
    }

    private String sendPostRequest(String urlString, String postData) throws Exception {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(urlString)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(postData)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        return response.body();
    }

    private void saveToPreferences() {
        System.out.println("Dados salvos nas prefer\u00eancias");
    }

    private void loadFromPreferences() throws InterruptedException {
        Thread.sleep(3000L);
        this.loadConfig(Main.Globals.numSerie, Main.Globals.model);
        System.out.println("Retentativa de obten\u00e7\u00e3o dos parametros");
    }

    public String getUrlAplication() {
        return this.urlAplication;
    }

    public String getScopeCompany() {
        return this.scopeCompany;
    }

    public String getScopeBranch() {
        return this.scopeBranch;
    }

    public String getScopePdv() {
        return this.scopePdv;
    }

    public boolean isBlockPowerButton() {
        return this.blockPowerButton;
    }

    public boolean isBlockStatusBar() {
        return this.blockStatusBar;
    }

    public boolean isPrintCommand() {
        return this.printCommand;
    }

    public boolean isPrintInvoice() {
        return this.printInvoice;
    }

    public String getOmsToken() {
        return this.omsToken;
    }

    public int getCscId() {
        return this.cscId;
    }

    public String getCsc() {
        return this.csc;
    }

    public int getAccountId() {
        return this.account_id;
    }

    public int getEstablishmentId() {
        return this.establishment_id;
    }

    public int getEquipamentId() {
        return this.equipament_id;
    }

    public int getBoxId() {
        return this.box_id;
    }

    public boolean isPinpadOnly() {
        return this.pinpadOnly;
    }
}

