/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;

public class DeviceIdentifier {
    private static final String DEVICE_ID_FILE = "device.id";

    public static String getUniqueDeviceId() {
        String persistentId = DeviceIdentifier.loadPersistentId();
        if (persistentId != null && !persistentId.trim().isEmpty()) {
            return persistentId;
        }
        SystemInfo systemInfo = new SystemInfo();
        StringBuilder deviceId = new StringBuilder();
        try {
            deviceId.append(DeviceIdentifier.getHardwareBasedId(systemInfo));
            if (deviceId.length() == 0) {
                deviceId.append(DeviceIdentifier.getNetworkBasedId(systemInfo));
            }
            if (deviceId.length() == 0) {
                deviceId.append(DeviceIdentifier.getH313SpecificId());
            }
            if (deviceId.length() == 0) {
                deviceId.append(DeviceIdentifier.getFileSystemBasedId());
            }
            if (deviceId.length() == 0) {
                deviceId.append(DeviceIdentifier.generateSystemFingerprint(systemInfo));
            }
            if (deviceId.length() == 0) {
                deviceId.append(DeviceIdentifier.generateFallbackId());
            }
        }
        catch (Exception e) {
            deviceId.append(DeviceIdentifier.generateFallbackId());
        }
        String finalId = deviceId.toString().replaceAll("[^a-zA-Z0-9]", "");
        DeviceIdentifier.savePersistentId(finalId);
        return finalId;
    }

    private static String getHardwareBasedId(SystemInfo systemInfo) {
        StringBuilder id = new StringBuilder();
        try {
            String uuid;
            String systemSerial;
            String baseboard = systemInfo.getHardware().getComputerSystem().getBaseboard().getSerialNumber();
            if (DeviceIdentifier.isValidSerial(baseboard)) {
                id.append(baseboard);
            }
            if (DeviceIdentifier.isValidSerial(systemSerial = systemInfo.getHardware().getComputerSystem().getSerialNumber())) {
                id.append(systemSerial);
            }
            if (DeviceIdentifier.isValidSerial(uuid = systemInfo.getHardware().getComputerSystem().getHardwareUUID())) {
                id.append(uuid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id.toString();
    }

    private static String getNetworkBasedId(SystemInfo systemInfo) {
        StringBuilder id;
        block7: {
            id = new StringBuilder();
            try {
                List<NetworkIF> networkIFs = systemInfo.getHardware().getNetworkIFs();
                for (NetworkIF netIF : networkIFs) {
                    String mac = netIF.getMacaddr();
                    if (mac == null || mac.equals("00:00:00:00:00:00") || mac.trim().isEmpty()) continue;
                    id.append(mac.replace(":", ""));
                    break;
                }
                if (id.length() != 0) break block7;
                try {
                    ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                    for (NetworkInterface netInterface : interfaces) {
                        byte[] mac;
                        if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || (mac = netInterface.getHardwareAddress()) == null || mac.length != 6) continue;
                        StringBuilder macStr = new StringBuilder();
                        for (byte b : mac) {
                            macStr.append(String.format("%02x", b));
                        }
                        String macAddress = macStr.toString();
                        if (macAddress.equals("000000000000")) continue;
                        id.append(macAddress);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return id.toString();
    }

    private static String getFileSystemBasedId() {
        String[] machineIdPaths;
        StringBuilder id = new StringBuilder();
        for (String path : machineIdPaths = new String[]{"/etc/machine-id", "/var/lib/dbus/machine-id", "/sys/class/dmi/id/product_uuid", "/proc/sys/kernel/random/boot_id"}) {
            try {
                String content;
                if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) || (content = Files.readString(Paths.get(path, new String[0])).trim()).isEmpty() || content.length() <= 10) continue;
                id.append(content);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return id.toString();
    }

    private static String generateSystemFingerprint(SystemInfo systemInfo) {
        try {
            StringBuilder fingerprint = new StringBuilder();
            CentralProcessor processor = systemInfo.getHardware().getProcessor();
            fingerprint.append(processor.getProcessorIdentifier().getIdentifier());
            fingerprint.append(processor.getProcessorIdentifier().getName());
            fingerprint.append(processor.getLogicalProcessorCount());
            fingerprint.append(processor.getPhysicalProcessorCount());
            GlobalMemory memory = systemInfo.getHardware().getMemory();
            fingerprint.append(memory.getTotal());
            OperatingSystem os = systemInfo.getOperatingSystem();
            fingerprint.append(os.getManufacturer());
            fingerprint.append(os.getFamily());
            fingerprint.append(os.getBitness());
            try {
                systemInfo.getHardware().getDiskStores().forEach(disk -> {
                    fingerprint.append(disk.getModel());
                    fingerprint.append(disk.getSize());
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(fingerprint.toString().getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            return DeviceIdentifier.generateTimestampBasedId();
        }
    }

    private static String generateFallbackId() {
        StringBuilder fallback = new StringBuilder();
        fallback.append(System.currentTimeMillis());
        fallback.append(System.nanoTime());
        fallback.append(System.getProperty("user.name", "unknown"));
        fallback.append(System.getProperty("os.name", "unknown"));
        fallback.append(System.getProperty("java.version", "unknown"));
        fallback.append(Runtime.getRuntime().availableProcessors());
        fallback.append(Runtime.getRuntime().maxMemory());
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(fallback.toString().getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            return DeviceIdentifier.generateTimestampBasedId();
        }
    }

    private static String generateTimestampBasedId() {
        return String.valueOf(System.currentTimeMillis() + System.nanoTime()).replaceAll("[^0-9]", "");
    }

    private static boolean isValidSerial(String serial) {
        if (serial == null || serial.trim().isEmpty()) {
            return false;
        }
        String[] invalidValues = new String[]{"unknown", "n/a", "not available", "not specified", "none", "null", "0", "00000000-0000-0000-0000-000000000000", "ffffffff-ffff-ffff-ffff-ffffffffffff", "default string", "to be filled by o.e.m.", "system serial number", "chassis serial number", "board serial number"};
        String lowerSerial = serial.toLowerCase().trim();
        for (String invalid : invalidValues) {
            if (!lowerSerial.equals(invalid)) continue;
            return false;
        }
        return lowerSerial.length() > 3;
    }

    private static String loadPersistentId() {
        try {
            File idFile = new File(DEVICE_ID_FILE);
            if (idFile.exists()) {
                return Files.readString(idFile.toPath()).trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void savePersistentId(String deviceId) {
        try {
            Files.writeString(Paths.get(DEVICE_ID_FILE, new String[0]), (CharSequence)deviceId, new OpenOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getH313SpecificId() {
        String[] devicePaths;
        StringBuilder id = new StringBuilder();
        for (String path : devicePaths = new String[]{"/proc/cpuinfo", "/sys/devices/virtual/dmi/id/board_serial", "/sys/devices/virtual/dmi/id/chassis_serial", "/sys/devices/virtual/dmi/id/product_serial", "/sys/class/dmi/id/board_serial", "/sys/class/dmi/id/chassis_serial", "/proc/device-tree/serial-number", "/proc/device-tree/model"}) {
            try {
                String content;
                String extractedId;
                if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) || (extractedId = DeviceIdentifier.extractDeviceSpecificId(path, content = Files.readString(Paths.get(path, new String[0])).trim())).isEmpty()) continue;
                id.append(extractedId);
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (id.length() == 0) {
            id.append(DeviceIdentifier.trySystemCommands());
        }
        return id.toString();
    }

    private static String extractDeviceSpecificId(String path, String content) {
        if (content == null || content.trim().isEmpty()) {
            return "";
        }
        content = content.trim();
        if (path.contains("cpuinfo")) {
            String[] lines;
            for (String line : lines = content.split("\n")) {
                String serial;
                String[] parts;
                if (!line.toLowerCase().contains("serial") || (parts = line.split(":")).length <= 1 || !DeviceIdentifier.isValidSerial(serial = parts[1].trim())) continue;
                return serial;
            }
        }
        if (path.contains("device-tree") && DeviceIdentifier.isValidSerial(content = content.replaceAll("\\x00", "").replaceAll("[\\x00-\\x1F]", ""))) {
            return content;
        }
        if ((path.contains("dmi") || path.contains("sys/class")) && DeviceIdentifier.isValidSerial(content)) {
            return content;
        }
        return "";
    }

    private static String trySystemCommands() {
        String[] commands;
        for (String command : commands = new String[]{"dmidecode -s system-serial-number", "dmidecode -s baseboard-serial-number", "dmidecode -s chassis-serial-number", "cat /sys/class/dmi/id/product_uuid", "hostid"}) {
            try {
                String output;
                Process process = Runtime.getRuntime().exec(command);
                process.waitFor();
                if (process.exitValue() != 0 || !DeviceIdentifier.isValidSerial(output = new String(process.getInputStream().readAllBytes()).trim())) continue;
                return output;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static String getDeviceSpecificId() {
        StringBuilder id = new StringBuilder();
        id.append(DeviceIdentifier.getH313SpecificId());
        if (id.length() == 0) {
            id.append(DeviceIdentifier.getAlternativeHardwareId());
        }
        return id.toString().replaceAll("[^a-zA-Z0-9]", "");
    }

    private static String getAlternativeHardwareId() {
        StringBuilder id;
        block5: {
            id = new StringBuilder();
            try {
                String[] lines;
                String memInfo;
                String cpuInfo = DeviceIdentifier.readFileContent("/proc/cpuinfo");
                if (!cpuInfo.isEmpty()) {
                    String[] lines2;
                    for (String line : lines2 = cpuInfo.split("\n")) {
                        String value;
                        String[] parts;
                        if (!line.contains("processor") && !line.contains("model name") && !line.contains("serial") && !line.contains("Hardware") || (parts = line.split(":")).length <= 1 || (value = parts[1].trim()).length() <= 3) continue;
                        id.append(value.replaceAll("\\s+", ""));
                    }
                }
                if ((memInfo = DeviceIdentifier.readFileContent("/proc/meminfo")).isEmpty()) break block5;
                for (String line : lines = memInfo.split("\n")) {
                    String[] parts;
                    if (!line.contains("MemTotal") || (parts = line.split(":")).length <= 1) continue;
                    id.append(parts[1].trim().replaceAll("\\s+", ""));
                    break;
                }
            }
            catch (Exception e) {
                id.append(System.getProperty("os.arch", ""));
                id.append(System.getProperty("os.version", ""));
                id.append(Runtime.getRuntime().availableProcessors());
            }
        }
        return id.toString();
    }

    private static String readFileContent(String path) {
        try {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                return Files.readString(Paths.get(path, new String[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String regenerateDeviceId() {
        try {
            Files.deleteIfExists(Paths.get(DEVICE_ID_FILE, new String[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DeviceIdentifier.getUniqueDeviceId();
    }
}

