/*
 * Decompiled with CFR 0.152.
 */
import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.Style;
import com.github.anastaciocintra.escpos.barcode.QRCode;
import com.github.anastaciocintra.output.PrinterOutputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.PrinterStateReasons;
import javax.print.attribute.standard.QueuedJobCount;
import org.json.JSONObject;

public class ESCPosPrinter {
    private static final String TAG = "ESCPosPrinter";
    private PrintService printService;
    private String printerName;
    EscPos escPos;
    private PrinterStatus lastStatus = PrinterStatus.UNKNOWN;
    private ScheduledExecutorService statusMonitor;
    private boolean monitoringEnabled = false;

    public ESCPosPrinter(String printerName) throws IOException {
        this.printerName = printerName;
        this.printService = PrinterOutputStream.getPrintServiceByName(printerName);
        if (this.printService == null) {
            throw new IOException("Impressora n\u00e3o encontrada: " + printerName);
        }
        try {
            this.escPos = ARMEscPosFix.createFixedEscPos(printerName);
            System.out.println("ESCPosPrinter: Usando EscPos com corre\u00e7\u00f5es para Linux ARM");
        }
        catch (Exception e) {
            System.out.println("ESCPosPrinter: Usando EscPos padr\u00e3o: " + e.getMessage());
            PrinterOutputStream printerOutputStream = new PrinterOutputStream(this.printService);
            this.escPos = new EscPos(printerOutputStream);
        }
        PrinterStatus initialStatus = this.getPrinterStatus();
        if (initialStatus.isError()) {
            String errorMessage = "Problema detectado ao conectar com a impressora: " + initialStatus.getDescription();
            this.publishPrinterError(errorMessage);
            this.notifyPrinterStatus(initialStatus, "Problema detectado ao conectar com a impressora");
        }
        System.out.println("ESCPosPrinter: Impressora " + printerName + " inicializada. Status: " + initialStatus.getDescription());
    }

    public void close() throws IOException {
        if (this.monitoringEnabled) {
            this.stopStatusMonitoring();
        }
        if (this.escPos != null) {
            this.escPos.close();
        }
        System.out.println("ESCPosPrinter: Conex\u00e3o com impressora fechada");
    }

    public void print(String text) throws IOException {
        PrinterStatus status = this.getPrinterStatus();
        if (status.isError()) {
            String errorMessage = "N\u00e3o \u00e9 poss\u00edvel imprimir. " + status.getDescription();
            System.err.println("ESCPosPrinter: " + errorMessage);
            this.publishPrinterError(errorMessage);
            this.notifyPrinterStatus(status, errorMessage);
            throw new IOException(errorMessage);
        }
        try {
            this.escPos.writeLF(text);
            System.out.println("ESCPosPrinter: Texto enviado para impress\u00e3o");
        }
        catch (IOException e) {
            System.err.println("ESCPosPrinter: Erro durante impress\u00e3o: " + e.getMessage());
            String errorMessage = "Falha na impress\u00e3o: " + e.getMessage();
            this.publishPrinterError(errorMessage);
            PrinterStatus newStatus = this.getPrinterStatus();
            if (newStatus.isError()) {
                this.notifyPrinterStatus(newStatus, "Erro durante impress\u00e3o: " + e.getMessage());
            }
            throw e;
        }
    }

    public void cut() throws IOException {
        PrinterStatus status = this.getPrinterStatus();
        if (status.isError()) {
            String errorMessage = "N\u00e3o \u00e9 poss\u00edvel cortar papel. " + status.getDescription();
            System.err.println("ESCPosPrinter: " + errorMessage);
            this.publishPrinterError(errorMessage);
            this.notifyPrinterStatus(status, errorMessage);
            throw new IOException(errorMessage);
        }
        try {
            this.escPos.feed(5);
            this.escPos.cut(EscPos.CutMode.FULL);
            System.out.println("ESCPosPrinter: Corte de papel executado");
        }
        catch (IOException e) {
            System.err.println("ESCPosPrinter: Erro durante corte: " + e.getMessage());
            String errorMessage = "Falha no corte do papel: " + e.getMessage();
            this.publishPrinterError(errorMessage);
            PrinterStatus newStatus = this.getPrinterStatus();
            if (newStatus.isError()) {
                this.notifyPrinterStatus(newStatus, "Erro durante corte: " + e.getMessage());
            }
            throw e;
        }
    }

    public void printTitle(String text) throws IOException {
        PrinterStatus status = this.getPrinterStatus();
        if (status.isError()) {
            String errorMessage = "N\u00e3o \u00e9 poss\u00edvel imprimir t\u00edtulo. " + status.getDescription();
            System.err.println("ESCPosPrinter: " + errorMessage);
            this.publishPrinterError(errorMessage);
            this.notifyPrinterStatus(status, errorMessage);
            throw new IOException(errorMessage);
        }
        try {
            Style title = new Style().setFontSize(Style.FontSize._2, Style.FontSize._2).setJustification(EscPosConst.Justification.Center);
            this.escPos.writeLF(title, text);
            System.out.println("ESCPosPrinter: T\u00edtulo enviado para impress\u00e3o");
        }
        catch (IOException e) {
            System.err.println("ESCPosPrinter: Erro durante impress\u00e3o de t\u00edtulo: " + e.getMessage());
            String errorMessage = "Falha na impress\u00e3o do t\u00edtulo: " + e.getMessage();
            this.publishPrinterError(errorMessage);
            PrinterStatus newStatus = this.getPrinterStatus();
            if (newStatus.isError()) {
                this.notifyPrinterStatus(newStatus, "Erro durante impress\u00e3o de t\u00edtulo: " + e.getMessage());
            }
            throw e;
        }
    }

    public void qrcode(String text) throws IOException {
        PrinterStatus status = this.getPrinterStatus();
        if (status.isError()) {
            String errorMessage = "N\u00e3o \u00e9 poss\u00edvel imprimir QR Code. " + status.getDescription();
            System.err.println("ESCPosPrinter: " + errorMessage);
            this.publishPrinterError(errorMessage);
            this.notifyPrinterStatus(status, errorMessage);
            throw new IOException(errorMessage);
        }
        try {
            QRCode qrcode = new QRCode();
            this.escPos.feed(2);
            qrcode.setSize(6);
            qrcode.setJustification(EscPosConst.Justification.Center);
            this.escPos.write(qrcode, text);
            this.escPos.feed(4);
            System.out.println("ESCPosPrinter: QR Code enviado para impress\u00e3o");
        }
        catch (IOException e) {
            System.err.println("ESCPosPrinter: Erro durante impress\u00e3o de QR Code: " + e.getMessage());
            String errorMessage = "Falha na impress\u00e3o do QR Code: " + e.getMessage();
            this.publishPrinterError(errorMessage);
            PrinterStatus newStatus = this.getPrinterStatus();
            if (newStatus.isError()) {
                this.notifyPrinterStatus(newStatus, "Erro durante impress\u00e3o de QR Code: " + e.getMessage());
            }
            throw e;
        }
    }

    public static void listAvailablePrinters() {
        String[] printServicesNames = PrinterOutputStream.getListPrintServicesNames();
        System.out.println("Impressoras dispon\u00edveis:");
        for (String printServiceName : printServicesNames) {
            System.out.println("  - " + printServiceName);
        }
    }

    public PrinterStatus getPrinterStatus() {
        try {
            if (this.printService == null) {
                return PrinterStatus.OFFLINE;
            }
            try {
                if (!this.printService.isDocFlavorSupported(DocFlavor.INPUT_STREAM.AUTOSENSE)) {
                    return PrinterStatus.OFFLINE;
                }
            }
            catch (Exception e) {
                return PrinterStatus.OFFLINE;
            }
            PrinterState state = this.printService.getAttribute(PrinterState.class);
            PrinterStateReasons reasons = this.printService.getAttribute(PrinterStateReasons.class);
            if (reasons != null && !reasons.isEmpty()) {
                for (PrinterStateReason reason : reasons.keySet()) {
                    String reasonStr = reason.toString().toLowerCase();
                    if (reasonStr.contains("media-empty") || reasonStr.contains("media_empty")) {
                        return PrinterStatus.PAPER_EMPTY;
                    }
                    if (reasonStr.contains("media-low") || reasonStr.contains("media_low")) {
                        return PrinterStatus.PAPER_LOW;
                    }
                    if (reasonStr.contains("cover-open") || reasonStr.contains("door-open")) {
                        return PrinterStatus.COVER_OPEN;
                    }
                    if (reasonStr.contains("offline") || reasonStr.contains("disconnected")) {
                        return PrinterStatus.OFFLINE;
                    }
                    if (reasonStr.contains("stopped") || reasonStr.contains("shutdown")) {
                        return PrinterStatus.STOPPED;
                    }
                    if (!reasonStr.contains("error") && !reasonStr.contains("fault")) continue;
                    return PrinterStatus.ERROR;
                }
                return PrinterStatus.ERROR;
            }
            if (state != null) {
                if (state == PrinterState.IDLE) {
                    return PrinterStatus.READY;
                }
                if (state == PrinterState.PROCESSING) {
                    return PrinterStatus.PRINTING;
                }
                if (state == PrinterState.STOPPED) {
                    return PrinterStatus.STOPPED;
                }
                if (state == PrinterState.UNKNOWN) {
                    return PrinterStatus.UNKNOWN;
                }
                return PrinterStatus.UNKNOWN;
            }
            return PrinterStatus.READY;
        }
        catch (Exception e) {
            System.err.println("ESCPosPrinter: Erro ao verificar status: " + e.getMessage());
            return PrinterStatus.ERROR;
        }
    }

    public String getDetailedStatus() {
        try {
            PrinterStateReasons reasons;
            StringBuilder details = new StringBuilder();
            details.append("Impressora: ").append(this.printerName).append("\n");
            details.append("Status: ").append(this.getPrinterStatus().getDescription()).append("\n");
            QueuedJobCount jobCount = this.printService.getAttribute(QueuedJobCount.class);
            if (jobCount != null) {
                details.append("Jobs na fila: ").append(jobCount.getValue()).append("\n");
            }
            if ((reasons = this.printService.getAttribute(PrinterStateReasons.class)) != null && !reasons.isEmpty()) {
                details.append("Detalhes: ");
                for (PrinterStateReason reason : reasons.keySet()) {
                    details.append(reason.toString()).append(" ");
                }
                details.append("\n");
            }
            return details.toString();
        }
        catch (Exception e) {
            return "Erro ao obter detalhes: " + e.getMessage();
        }
    }

    public boolean isReady() {
        PrinterStatus status = this.getPrinterStatus();
        return status == PrinterStatus.READY || status == PrinterStatus.PAPER_LOW;
    }

    private void notifyPrinterStatus(PrinterStatus status, String message) {
        try {
            MqttHelper mqttHelper = MqttHelper.getInstance();
            if (mqttHelper.isConnected()) {
                String topic = "totem/" + Main.Globals.numSerie + "/printer/status";
                JSONObject payload = new JSONObject();
                payload.put("timestamp", System.currentTimeMillis());
                payload.put("printer_name", this.printerName);
                payload.put("status", status.name());
                payload.put("status_description", status.getDescription());
                payload.put("is_error", status.isError());
                payload.put("message", message);
                payload.put("device_serial", Main.Globals.numSerie);
                mqttHelper.publish(topic, payload.toString());
                System.out.println("ESCPosPrinter: Status enviado via MQTT - " + status.getDescription());
                if (status.isError()) {
                    String alertTopic = "totem/" + Main.Globals.numSerie + "/alerts";
                    JSONObject alertPayload = new JSONObject();
                    alertPayload.put("type", "printer_error");
                    alertPayload.put("severity", "high");
                    alertPayload.put("description", message);
                    alertPayload.put("timestamp", System.currentTimeMillis());
                    mqttHelper.publish(alertTopic, alertPayload.toString());
                    String errorDetails = "Impressora " + this.printerName + ": " + status.getDescription() + " - " + message;
                    this.publishPrinterError(errorDetails);
                }
            } else {
                System.err.println("ESCPosPrinter: MQTT n\u00e3o conectado. Status n\u00e3o enviado: " + status.getDescription());
            }
        }
        catch (Exception e) {
            System.err.println("ESCPosPrinter: Erro ao enviar status via MQTT: " + e.getMessage());
        }
    }

    private void publishPrinterError(String errorMessage) {
        try {
            MqttHelper mqttHelper = MqttHelper.getInstance();
            if (mqttHelper.isConnected()) {
                String errorTopic = "totem/error";
                JSONObject errorPayload = new JSONObject();
                errorPayload.put("device_id", Main.Globals.numSerie);
                errorPayload.put("value", errorMessage);
                mqttHelper.publish(errorTopic, errorPayload.toString());
                System.out.println("ESCPosPrinter: Erro da impressora enviado via MQTT para " + errorTopic + " - " + errorMessage);
            } else {
                System.err.println("ESCPosPrinter: MQTT n\u00e3o conectado. Erro n\u00e3o enviado: " + errorMessage);
            }
        }
        catch (Exception e) {
            System.err.println("ESCPosPrinter: Falha ao publicar erro da impressora via MQTT: " + e.getMessage());
        }
    }

    public void startStatusMonitoring() {
        this.startStatusMonitoring(30);
    }

    public void startStatusMonitoring(int intervalSeconds) {
        if (this.monitoringEnabled) {
            System.out.println("ESCPosPrinter: Monitoramento j\u00e1 ativo");
            return;
        }
        this.statusMonitor = Executors.newSingleThreadScheduledExecutor();
        this.monitoringEnabled = true;
        this.statusMonitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    PrinterStatus currentStatus = ESCPosPrinter.this.getPrinterStatus();
                    if (currentStatus != ESCPosPrinter.this.lastStatus) {
                        System.out.println("ESCPosPrinter: Mudan\u00e7a de status detectada: " + (ESCPosPrinter.this.lastStatus != null ? ESCPosPrinter.this.lastStatus.getDescription() : "desconhecido") + " \u2192 " + currentStatus.getDescription());
                        ESCPosPrinter.this.notifyPrinterStatus(currentStatus, "Mudan\u00e7a de status detectada");
                        ESCPosPrinter.this.lastStatus = currentStatus;
                    }
                    if (currentStatus.isError()) {
                        System.err.println("ESCPosPrinter: Status de erro mantido - " + currentStatus.getDescription());
                    }
                }
                catch (Exception e) {
                    System.err.println("ESCPosPrinter: Erro no monitoramento de status: " + e.getMessage());
                }
            }
        }, 0L, intervalSeconds, TimeUnit.SECONDS);
        System.out.println("ESCPosPrinter: Monitoramento de status iniciado (intervalo: " + intervalSeconds + "s)");
    }

    public void stopStatusMonitoring() {
        if (this.statusMonitor != null && !this.statusMonitor.isShutdown()) {
            this.statusMonitor.shutdown();
            this.monitoringEnabled = false;
            System.out.println("ESCPosPrinter: Monitoramento de status parado");
        }
    }

    public void checkAndNotifyStatus() {
        PrinterStatus currentStatus = this.getPrinterStatus();
        String message = "Verifica\u00e7\u00e3o manual de status";
        if (currentStatus.isError()) {
            message = "Problema detectado na impressora";
        }
        this.notifyPrinterStatus(currentStatus, message);
        System.out.println("ESCPosPrinter: Status atual - " + currentStatus.getDescription());
    }

    public String getStatusRecommendations() {
        PrinterStatus status = this.getPrinterStatus();
        if (status == PrinterStatus.READY) {
            return "Impressora pronta para uso.";
        }
        if (status == PrinterStatus.PRINTING) {
            return "Impressora ocupada. Aguarde a conclus\u00e3o do job atual.";
        }
        if (status == PrinterStatus.OFFLINE) {
            return "Verifique se a impressora est\u00e1 ligada e conectada ao sistema.";
        }
        if (status == PrinterStatus.PAPER_EMPTY) {
            return "Recarregue o papel na impressora e reinicie o sistema de impress\u00e3o.";
        }
        if (status == PrinterStatus.PAPER_LOW) {
            return "Papel baixo. Considere recarregar antes de imprimir jobs grandes.";
        }
        if (status == PrinterStatus.COVER_OPEN) {
            return "Feche a tampa da impressora e verifique se n\u00e3o h\u00e1 obstru\u00e7\u00f5es.";
        }
        if (status == PrinterStatus.STOPPED) {
            return "Impressora parada. Verifique o painel da impressora e reinicie se necess\u00e1rio.";
        }
        if (status == PrinterStatus.ERROR) {
            return "Erro na impressora. Verifique o painel, reinicie a impressora e o sistema.";
        }
        if (status == PrinterStatus.UNKNOWN) {
            return "Status desconhecido. Verifique a conex\u00e3o e funcionamento da impressora.";
        }
        return "Status desconhecido. Verifique a conex\u00e3o e funcionamento da impressora.";
    }

    public static enum PrinterStatus {
        READY("Impressora pronta", false),
        PRINTING("Imprimindo", false),
        STOPPED("Impressora parada", true),
        OFFLINE("Impressora desconectada", true),
        PAPER_EMPTY("Sem papel", true),
        PAPER_LOW("Papel baixo", false),
        COVER_OPEN("Tampa aberta", true),
        ERROR("Erro na impressora", true),
        UNKNOWN("Status desconhecido", false);

        private final String description;
        private final boolean isError;

        private PrinterStatus(String description, boolean isError) {
            this.description = description;
            this.isError = isError;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

