/*
 * Decompiled with CFR 0.152.
 */
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class Esp32SerialCommunicator {
    private static Esp32SerialCommunicator instance;
    private SerialPort serialPort;
    private InputStream inputStream;
    private OutputStream outputStream;
    private OnDataReceivedListener onDataReceived;
    private OnErrorListener onErrorListener;
    private TextViewUpdater textViewUpdater;
    private ExecutorService executorService;
    private boolean isRunning = false;
    private boolean isReconnecting = false;
    private static final String TAG;
    private ExecutorService heartbeatExecutor;
    private boolean heartbeatRunning = false;
    private long lastHeartbeatResponse = 0L;
    private boolean waitingForHeartbeatResponse = false;
    private static final long HEARTBEAT_INTERVAL_MS = 180000L;
    private static final long HEARTBEAT_TIMEOUT_MS = 10000L;

    private Esp32SerialCommunicator(OnDataReceivedListener onDataReceived, OnErrorListener onErrorListener, TextViewUpdater textViewUpdater) {
        this.onDataReceived = onDataReceived;
        this.onErrorListener = onErrorListener;
        this.textViewUpdater = textViewUpdater;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public static Esp32SerialCommunicator getInstance(OnDataReceivedListener onDataReceived, OnErrorListener onErrorListener, TextViewUpdater textViewUpdater) {
        if (instance == null) {
            instance = new Esp32SerialCommunicator(onDataReceived, onErrorListener, textViewUpdater);
        }
        return instance;
    }

    public void connect() {
        try {
            SerialPort[] availablePorts = SerialPort.getCommPorts();
            if (availablePorts.length == 0) {
                String errorMsg = "Nenhuma porta serial encontrada";
                this.onErrorListener.onError(errorMsg);
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
                return;
            }
            this.serialPort = this.findEsp32Port(availablePorts);
            if (this.serialPort == null) {
                String errorMsg = "Nenhuma porta ESP32 encontrada. Portas dispon\u00edveis: " + this.getAvailablePortsString(availablePorts);
                this.onErrorListener.onError(errorMsg);
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
                return;
            }
        }
        catch (Exception e) {
            String errorMsg = "Erro ao buscar portas seriais: " + e.getMessage();
            this.onErrorListener.onError(errorMsg);
            this.textViewUpdater.updateTextView("ERROR", errorMsg);
            return;
        }
        this.connectToPort();
    }

    public void connect(String portName) {
        if (this.isReconnecting) {
            this.textViewUpdater.updateTextView("INFO", "Reconex\u00e3o j\u00e1 em andamento...");
            return;
        }
        try {
            SerialPort[] availablePorts = SerialPort.getCommPorts();
            if (availablePorts.length == 0) {
                String string = "Nenhuma porta serial encontrada";
                this.onErrorListener.onError(string);
                this.textViewUpdater.updateTextView("ERROR", string);
                return;
            }
            this.serialPort = null;
            for (SerialPort port : availablePorts) {
                if (!port.getSystemPortName().equals(portName)) continue;
                this.serialPort = port;
                break;
            }
            if (this.serialPort == null) {
                String string = "Porta " + portName + " n\u00e3o encontrada. Portas dispon\u00edveis: " + this.getAvailablePortsString(availablePorts);
                this.onErrorListener.onError(string);
                this.textViewUpdater.updateTextView("ERROR", string);
                return;
            }
        }
        catch (Exception e) {
            String string = "Erro ao buscar porta " + portName + ": " + e.getMessage();
            this.onErrorListener.onError(string);
            this.textViewUpdater.updateTextView("ERROR", string);
            return;
        }
        this.connectToPort();
    }

    private SerialPort findEsp32Port(SerialPort[] availablePorts) {
        for (SerialPort port : availablePorts) {
            String description = port.getDescriptivePortName().toLowerCase();
            String portName = port.getSystemPortName();
            if (!description.contains("esp32") && !description.contains("cp210") && !description.contains("silicon labs") && !description.contains("ch340") && !description.contains("ft232") && !description.contains("espressif")) continue;
            this.textViewUpdater.updateTextView("INFO", "ESP32 encontrado por descri\u00e7\u00e3o: " + portName + " (" + port.getDescriptivePortName() + ")");
            return port;
        }
        for (SerialPort port : availablePorts) {
            if (!this.isEsp32ByVidPid(port)) continue;
            this.textViewUpdater.updateTextView("INFO", "ESP32 encontrado por VID/PID: " + port.getSystemPortName());
            return port;
        }
        this.textViewUpdater.updateTextView("WARNING", "ESP32 n\u00e3o encontrado especificamente");
        return null;
    }

    private boolean isEsp32ByVidPid(SerialPort port) {
        int vid = port.getVendorID();
        int pid = port.getProductID();
        if (vid == 4292 && (pid == 60000 || pid == 60016)) {
            return true;
        }
        if (vid == 6790 && pid == 29987) {
            return true;
        }
        return vid == 1027 && (pid == 24577 || pid == 24596);
    }

    private String getAvailablePortsString(SerialPort[] ports) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ports[i].getSystemPortName()).append(" (").append(ports[i].getDescriptivePortName()).append(")");
        }
        return sb.toString();
    }

    private void connectToPort() {
        try {
            if (this.executorService == null || this.executorService.isShutdown() || this.executorService.isTerminated()) {
                this.executorService = Executors.newSingleThreadExecutor();
            }
            this.serialPort.setBaudRate(115200);
            this.serialPort.setNumDataBits(8);
            this.serialPort.setNumStopBits(1);
            this.serialPort.setParity(0);
            this.serialPort.setComPortTimeouts(1, 1000, 0);
            if (!this.serialPort.openPort()) {
                String errorMsg = "Erro ao abrir porta serial: " + this.serialPort.getSystemPortName();
                this.onErrorListener.onError(errorMsg);
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
                return;
            }
            this.serialPort.addDataListener(new SerialPortDataListener(){

                @Override
                public int getListeningEvents() {
                    return 0x10000000;
                }

                @Override
                public void serialEvent(SerialPortEvent event) {
                    if (event.getEventType() == 0x10000000) {
                        Esp32SerialCommunicator.this.textViewUpdater.updateTextView("WARNING", "ESP32 foi desconectado fisicamente (evento)");
                        Esp32SerialCommunicator.this.handleConnectionLost();
                    }
                }
            });
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.textViewUpdater.updateTextView("STATUS", "Conex\u00e3o serial estabelecida na porta: " + this.serialPort.getSystemPortName() + " (" + this.serialPort.getDescriptivePortName() + ")");
            this.isRunning = true;
            this.isReconnecting = false;
            this.executorService.submit(this::readSerialData);
            this.startHeartbeat();
        }
        catch (Exception e) {
            String errorMsg = "Erro ao conectar na porta " + (this.serialPort != null ? this.serialPort.getSystemPortName() : "desconhecida") + ": " + e.getMessage();
            this.onErrorListener.onError(errorMsg);
            this.textViewUpdater.updateTextView("ERROR", errorMsg);
        }
    }

    private void handleConnectionLost() {
        if (this.isReconnecting) {
            return;
        }
        this.isReconnecting = true;
        this.textViewUpdater.updateTextView("WARNING", "Conex\u00e3o com ESP32 perdida - iniciando reconex\u00e3o...");
        Thread reconnectThread = new Thread(() -> {
            try {
                this.disconnectInternal();
                Thread.sleep(2000L);
                int maxRetries = 5;
                int retryCount = 0;
                while (retryCount < maxRetries && this.isReconnecting) {
                    this.textViewUpdater.updateTextView("INFO", "Tentativa de reconex\u00e3o " + ++retryCount + "/" + maxRetries);
                    try {
                        this.connect();
                        if (this.isRunning && this.serialPort != null && this.serialPort.isOpen()) {
                            this.textViewUpdater.updateTextView("SUCCESS", "Reconex\u00e3o bem-sucedida!");
                            return;
                        }
                    }
                    catch (Exception e) {
                        this.textViewUpdater.updateTextView("ERROR", "Falha na tentativa " + retryCount + ": " + e.getMessage());
                    }
                    if (retryCount >= maxRetries) continue;
                    Thread.sleep(3000L);
                }
                this.textViewUpdater.updateTextView("ERROR", "Falha na reconex\u00e3o ap\u00f3s " + maxRetries + " tentativas");
                this.onErrorListener.onError("Reconex\u00e3o falhada ap\u00f3s " + maxRetries + " tentativas");
                this.textViewUpdater.updateTextView("WARNING", "Reiniciando aplica\u00e7\u00e3o devido a falha na reconex\u00e3o...");
                this.restartApplication();
            }
            catch (InterruptedException e) {
                this.textViewUpdater.updateTextView("WARNING", "Reconex\u00e3o interrompida");
            }
            finally {
                this.isReconnecting = false;
            }
        });
        reconnectThread.setDaemon(true);
        reconnectThread.start();
    }

    private void readSerialData() {
        StringBuilder serialBuffer = new StringBuilder();
        byte[] buffer = new byte[1024];
        this.textViewUpdater.updateTextView("INFO", "Aguardando dados do ESP32...");
        while (this.isRunning && this.serialPort != null && this.serialPort.isOpen()) {
            try {
                int bytesRead = this.inputStream.read(buffer);
                if (bytesRead <= 0) continue;
                String receivedData = new String(buffer, 0, bytesRead);
                serialBuffer.append(receivedData);
                String bufferContent = serialBuffer.toString();
                int startIndex = bufferContent.indexOf("{");
                int endIndex = bufferContent.indexOf("}");
                while (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                    String completeMessage = bufferContent.substring(startIndex, endIndex + 1);
                    this.processReceivedMessage(completeMessage);
                    if (this.onDataReceived != null) {
                        this.onDataReceived.onDataReceived(completeMessage);
                    }
                    if (this.textViewUpdater != null) {
                        this.textViewUpdater.updateTextView("DATA", completeMessage);
                    }
                    bufferContent = bufferContent.substring(endIndex + 1);
                    serialBuffer = new StringBuilder(bufferContent);
                    startIndex = bufferContent.indexOf("{");
                    endIndex = bufferContent.indexOf("}");
                }
            }
            catch (IOException e) {
                if (!this.isRunning || e.getMessage().contains("timed out") || e.getMessage().contains("timeout")) continue;
                String errorMsg = "Erro na leitura serial: " + e.getMessage();
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
                this.handleConnectionLost();
                break;
            }
        }
        this.textViewUpdater.updateTextView("INFO", "Thread de leitura serial finalizada");
    }

    public void sendJsonData(String command, int value, String identifier) {
        try {
            if (this.serialPort == null || !this.serialPort.isOpen()) {
                String errorMsg = "Porta serial n\u00e3o est\u00e1 aberta";
                this.onErrorListener.onError(errorMsg);
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
                return;
            }
            JSONObject json = new JSONObject();
            json.put("command", command);
            json.put("value", value);
            json.put("identifier", identifier);
            String jsonString = json.toString() + "\n";
            byte[] dataToSend = jsonString.getBytes();
            this.outputStream.write(dataToSend);
            this.outputStream.flush();
            if (this.textViewUpdater != null) {
                this.textViewUpdater.updateTextView("SENT", json.toString());
            }
        }
        catch (Exception e) {
            String errorMsg = "Erro no envio de dados: " + e.getMessage();
            this.onErrorListener.onError(errorMsg);
            if (this.textViewUpdater != null) {
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
            }
            this.handleConnectionLost();
        }
    }

    public void disconnect() {
        this.isReconnecting = false;
        this.disconnectInternal();
    }

    private void disconnectInternal() {
        block15: {
            try {
                this.isRunning = false;
                this.stopHeartbeat();
                if (this.executorService != null && !this.executorService.isShutdown()) {
                    this.executorService.shutdown();
                    try {
                        if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                            this.executorService.shutdownNow();
                        }
                    }
                    catch (InterruptedException e) {
                        this.executorService.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.inputStream = null;
                }
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.outputStream = null;
                }
                if (this.serialPort != null && this.serialPort.isOpen()) {
                    this.serialPort.closePort();
                }
                this.serialPort = null;
                if (this.textViewUpdater != null) {
                    this.textViewUpdater.updateTextView("STATUS", "Conex\u00e3o serial fechada");
                }
            }
            catch (Exception e) {
                String errorMsg = "Erro ao desconectar: " + e.getMessage();
                if (this.onErrorListener != null) {
                    this.onErrorListener.onError(errorMsg);
                }
                if (this.textViewUpdater == null) break block15;
                this.textViewUpdater.updateTextView("ERROR", errorMsg);
            }
        }
    }

    private void restartApplication() {
        new Thread(() -> {
            try {
                this.textViewUpdater.updateTextView("WARNING", "Encerrando aplica\u00e7\u00e3o ap\u00f3s falha cr\u00edtica na conex\u00e3o ESP32...");
                this.textViewUpdater.updateTextView("INFO", "Sistema reiniciar\u00e1 a aplica\u00e7\u00e3o automaticamente");
                Thread.sleep(2000L);
                this.textViewUpdater.updateTextView("INFO", "Encerrando aplica\u00e7\u00e3o atual...");
                System.exit(1);
            }
            catch (Exception e) {
                this.textViewUpdater.updateTextView("ERROR", "Erro ao encerrar aplica\u00e7\u00e3o: " + e.getMessage());
                e.printStackTrace();
                System.exit(1);
            }
        }).start();
    }

    private void processReceivedMessage(String message) {
        try {
            if (message.contains("\"command\":\"status_response\"") && this.waitingForHeartbeatResponse) {
                this.lastHeartbeatResponse = System.currentTimeMillis();
                this.waitingForHeartbeatResponse = false;
                this.textViewUpdater.updateTextView("HEARTBEAT", "Heartbeat ESP32 OK");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startHeartbeat() {
        if (this.heartbeatRunning) {
            return;
        }
        this.heartbeatRunning = true;
        this.heartbeatExecutor = Executors.newSingleThreadExecutor();
        this.lastHeartbeatResponse = System.currentTimeMillis();
        this.heartbeatExecutor.submit(() -> {
            this.textViewUpdater.updateTextView("INFO", "Sistema de heartbeat ESP32 iniciado (3 minutos)");
            while (this.heartbeatRunning && this.isRunning) {
                try {
                    Thread.sleep(180000L);
                    if (!this.heartbeatRunning || !this.isRunning) break;
                    this.sendHeartbeat();
                    Thread.sleep(10000L);
                    if (!this.waitingForHeartbeatResponse) continue;
                    this.textViewUpdater.updateTextView("ERROR", "Heartbeat ESP32 falhou - reiniciando comunica\u00e7\u00e3o");
                    this.waitingForHeartbeatResponse = false;
                    this.restartSerialCommunication();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    this.textViewUpdater.updateTextView("ERROR", "Erro no heartbeat ESP32: " + e.getMessage());
                }
            }
            this.textViewUpdater.updateTextView("INFO", "Sistema de heartbeat ESP32 finalizado");
        });
    }

    private void stopHeartbeat() {
        this.heartbeatRunning = false;
        this.waitingForHeartbeatResponse = false;
        if (this.heartbeatExecutor != null && !this.heartbeatExecutor.isShutdown()) {
            this.heartbeatExecutor.shutdown();
            try {
                if (!this.heartbeatExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.heartbeatExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.heartbeatExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private void sendHeartbeat() {
        try {
            if (this.serialPort == null || !this.serialPort.isOpen()) {
                this.textViewUpdater.updateTextView("WARNING", "Porta serial n\u00e3o dispon\u00edvel para heartbeat");
                return;
            }
            this.waitingForHeartbeatResponse = true;
            this.sendJsonData("status", 0, "heartbeat");
            this.textViewUpdater.updateTextView("HEARTBEAT", "Enviando heartbeat para ESP32...");
        }
        catch (Exception e) {
            this.textViewUpdater.updateTextView("ERROR", "Erro ao enviar heartbeat: " + e.getMessage());
            this.waitingForHeartbeatResponse = false;
        }
    }

    private void restartSerialCommunication() {
        new Thread(() -> {
            try {
                this.textViewUpdater.updateTextView("WARNING", "Reiniciando comunica\u00e7\u00e3o serial ESP32...");
                boolean wasHeartbeatRunning = this.heartbeatRunning;
                this.stopHeartbeat();
                this.disconnectInternal();
                Thread.sleep(3000L);
                this.connect();
                if (this.isRunning && this.serialPort != null && this.serialPort.isOpen()) {
                    this.textViewUpdater.updateTextView("SUCCESS", "Comunica\u00e7\u00e3o serial ESP32 reiniciada com sucesso");
                } else {
                    this.textViewUpdater.updateTextView("ERROR", "Falha ao reiniciar comunica\u00e7\u00e3o serial ESP32");
                    this.handleConnectionLost();
                }
            }
            catch (Exception e) {
                this.textViewUpdater.updateTextView("ERROR", "Erro ao reiniciar comunica\u00e7\u00e3o serial: " + e.getMessage());
                this.handleConnectionLost();
            }
        }).start();
    }

    public static void listAvailablePorts() {
        SerialPort[] ports = SerialPort.getCommPorts();
        System.out.println("=== Portas seriais dispon\u00edveis ===");
        if (ports.length == 0) {
            System.out.println("Nenhuma porta serial encontrada");
        } else {
            for (SerialPort port : ports) {
                System.out.println("- " + port.getSystemPortName() + " (" + port.getDescriptivePortName() + ")");
                System.out.println("  Vendor ID: 0x" + Integer.toHexString(port.getVendorID()));
                System.out.println("  Product ID: 0x" + Integer.toHexString(port.getProductID()));
            }
        }
        System.out.println("=====================================");
    }

    static {
        TAG = Esp32SerialCommunicator.class.getSimpleName();
    }

    public static interface OnDataReceivedListener {
        public void onDataReceived(String var1);
    }

    public static interface OnErrorListener {
        public void onError(String var1);
    }

    public static interface TextViewUpdater {
        public void updateTextView(String var1, String var2);
    }
}

