/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class GpioCounter
implements Runnable {
    private static final String GPIO_PATH = "/sys/class/gpio";
    private final String gpioPin;
    private final GpioCounterCallback callback;

    public GpioCounter(String gpioPin, GpioCounterCallback callback) {
        this.gpioPin = gpioPin;
        this.callback = callback;
    }

    private void setupGpio() {
        try {
            try (FileWriter exportWriter = new FileWriter("/sys/class/gpio/export");){
                exportWriter.write(this.gpioPin);
            }
            try (FileWriter directionWriter = new FileWriter("/sys/class/gpio/gpio" + this.gpioPin + "/direction");){
                directionWriter.write("in");
            }
            System.out.println("GPIO " + this.gpioPin + " configurado para entrada.");
        }
        catch (IOException e) {
            System.err.println("Erro ao configurar GPIO: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.waitForLowTransition();
                    int count = this.countPulses();
                    System.out.println("Pulsos lidos: " + count);
                    if (count <= 3) continue;
                    this.callback.onCountingComplete(count);
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void waitForLowTransition() throws IOException, InterruptedException {
        while (!"0".equals(this.readValue())) {
            Thread.sleep(10L);
        }
        System.out.println("Transi\u00e7\u00e3o para LOW detectada, iniciando contagem...");
    }

    private int countPulses() throws IOException, InterruptedException {
        int count = 0;
        long startTime = System.currentTimeMillis();
        boolean wasHigh = false;
        while (true) {
            String value = this.readValue();
            long currentTime = System.currentTimeMillis();
            long elapsed = currentTime - startTime;
            if ("0".equals(value)) {
                if (count == 1) {
                    WebSocketManager.getInstance(null).sendMessageToAll("POPUP-MONEY", "Inicio da venda em dinheiro");
                }
                if (!wasHigh) {
                    wasHigh = true;
                    System.out.println("Pulso detectado. Contagem: " + ++count);
                    WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Dinheiro R$" + count + ",00");
                }
                startTime = currentTime;
            } else if ("1".equals(value)) {
                if (elapsed > 10000L) {
                    int quociente = count / 5;
                    double resultado = (double)count / 5.0;
                    double parteDecimal = resultado - Math.floor(resultado);
                    count = parteDecimal > 0.5 ? (quociente + 1) * 5 : quociente * 5;
                    System.out.println("pulsos detectados: " + count);
                    return count;
                }
                wasHigh = false;
            }
            Thread.sleep(45L);
        }
    }

    private String readValue() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader("/sys/class/gpio/gpio" + this.gpioPin + "/value"));){
            String string = reader.readLine();
            return string;
        }
    }

    public static interface GpioCounterCallback {
        public void onCountingComplete(int var1);
    }
}

