/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.json.JSONException;
import org.json.JSONObject;

public class GpioReader
implements Runnable {
    private static final String TAG = "GpioReader";
    private static final String GPIO_DOOR = "535";
    private static final String GPIO_SAFE = "529";
    private static final String GPIO_PATH_DOOR = "/sys/class/gpio/gpio535";
    private static final String GPIO_PATH_SAFE = "/sys/class/gpio/gpio529";
    private final String numSerie;
    private boolean monitoring;
    MqttHelper mqttHelper = MqttHelper.getInstance();

    public GpioReader(String numSerie) {
        this.numSerie = numSerie;
    }

    private String readGpioValue(String gpioPath) {
        String value = "0";
        try (BufferedReader reader = new BufferedReader(new FileReader(gpioPath + "/value"));){
            value = reader.readLine();
        }
        catch (IOException e) {
            System.err.println("GpioReader: Erro ao ler valor do GPIO - " + e.getMessage());
        }
        return value;
    }

    public void startMonitoring() {
        this.monitoring = true;
        new Thread(this).start();
    }

    public void stopMonitoring() {
        this.monitoring = false;
    }

    @Override
    public void run() {
        String lastValueDoor = "0";
        String lastValueSafe = "0";
        while (this.monitoring) {
            String mensagemJson;
            JSONObject json;
            String currentValueDoor = this.readGpioValue(GPIO_PATH_DOOR);
            String currentValueSafe = this.readGpioValue(GPIO_PATH_SAFE);
            if (!currentValueDoor.equals(lastValueDoor)) {
                try {
                    json = new JSONObject();
                    json.put("numSerie", this.numSerie);
                    json.put("command", "DOOR");
                    json.put("value", currentValueDoor);
                    mensagemJson = json.toString();
                    this.mqttHelper.publish("status", mensagemJson);
                    lastValueDoor = currentValueDoor;
                }
                catch (MqttException | JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!currentValueSafe.equals(lastValueSafe)) {
                try {
                    json = new JSONObject();
                    json.put("numSerie", this.numSerie);
                    json.put("command", "SAFE");
                    json.put("value", currentValueSafe);
                    mensagemJson = json.toString();
                    this.mqttHelper.publish("status", mensagemJson);
                    lastValueSafe = currentValueSafe;
                }
                catch (MqttException | JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                System.err.println("GpioReader: Thread foi interrompida - " + e.getMessage());
            }
        }
    }
}

