/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LogDatabaseHelper {
    private static final String DB_NAME = "unified_logger.db";
    private static final String TABLE_LOGS = "pending_logs";
    private static final int DB_VERSION = 1;
    private Connection connection;

    public LogDatabaseHelper() {
        this.initDatabase();
    }

    private void initDatabase() {
        try {
            String url = "jdbc:sqlite:unified_logger.db";
            this.connection = DriverManager.getConnection(url);
            this.createTableIfNotExists();
        }
        catch (SQLException e) {
            System.err.println("Error initializing database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createTableIfNotExists() throws SQLException {
        String createTableSQL = "CREATE TABLE IF NOT EXISTS pending_logs (id INTEGER PRIMARY KEY AUTOINCREMENT, message TEXT NOT NULL, timestamp INTEGER NOT NULL, retry_count INTEGER DEFAULT 0)";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(createTableSQL);
        }
    }

    public void saveLog(String message) {
        String insertSQL = "INSERT INTO pending_logs (message, timestamp) VALUES (?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(insertSQL);){
            pstmt.setString(1, message);
            pstmt.setLong(2, System.currentTimeMillis());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error saving log: " + e.getMessage());
        }
    }

    public List<PendingLog> getPendingLogs(int limit) {
        ArrayList<PendingLog> logs = new ArrayList<PendingLog>();
        String selectSQL = "SELECT id, message, timestamp, retry_count FROM pending_logs ORDER BY timestamp ASC LIMIT ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(selectSQL);){
            pstmt.setInt(1, limit);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    PendingLog log = new PendingLog(rs.getLong("id"), rs.getString("message"), rs.getLong("timestamp"), rs.getInt("retry_count"));
                    logs.add(log);
                }
            }
        }
        catch (SQLException e) {
            System.err.println("Error getting pending logs: " + e.getMessage());
        }
        return logs;
    }

    public void deleteLog(long id) {
        String deleteSQL = "DELETE FROM pending_logs WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(deleteSQL);){
            pstmt.setLong(1, id);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error deleting log: " + e.getMessage());
        }
    }

    public void updateRetryCount(long id, int retryCount) {
        String updateSQL = "UPDATE pending_logs SET retry_count = ? WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(updateSQL);){
            pstmt.setInt(1, retryCount);
            pstmt.setLong(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.err.println("Error updating retry count: " + e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            System.err.println("Error closing database: " + e.getMessage());
        }
    }
}

