/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import org.json.JSONObject;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.software.os.OperatingSystem;

public class Main
implements GpioCounter.GpioCounterCallback,
Esp32SerialCommunicator.OnDataReceivedListener,
Esp32SerialCommunicator.OnErrorListener,
Esp32SerialCommunicator.TextViewUpdater {
    static String scopeCompany = "";
    static String scopeBranch = "";
    static String scopePdv = "";
    private MyWebSocketServer server;
    private WebSocketManager webSocketManager;
    private Esp32SerialCommunicator esp32SerialCommunicator;

    public static void main(String[] args) throws InterruptedException {
        String baseboard;
        SystemInfo systemInfo = new SystemInfo();
        File serialFile = new File("serial.json");
        if (serialFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(serialFile));){
                String line;
                StringBuilder jsonContent = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    jsonContent.append(line);
                }
                JSONObject serialJson = new JSONObject(jsonContent.toString());
                if (serialJson.has("baseboard")) {
                    baseboard = serialJson.getString("baseboard").replaceAll("[^a-zA-Z0-9]", "");
                    System.out.println("Baseboard carregado do arquivo serial.json: " + baseboard);
                } else {
                    baseboard = systemInfo.getHardware().getComputerSystem().getBaseboard().getSerialNumber().replaceAll("[^a-zA-Z0-9]", "");
                }
            }
            catch (Exception e) {
                System.err.println("Erro ao ler arquivo serial.json: " + e.getMessage());
                baseboard = systemInfo.getHardware().getComputerSystem().getBaseboard().getSerialNumber().replaceAll("[^a-zA-Z0-9]", "");
            }
        } else {
            baseboard = systemInfo.getHardware().getComputerSystem().getBaseboard().getSerialNumber().replaceAll("[^a-zA-Z0-9]", "");
        }
        if (baseboard.equals("unknown")) {
            baseboard = DeviceIdentifier.getUniqueDeviceId();
        }
        System.out.println(baseboard);
        ConfigLoader configLoader = new ConfigLoader();
        Globals.numSerie = baseboard;
        System.out.println(Globals.numSerie);
        Globals.model = "Raspberry pi 3";
        configLoader.loadConfig(Globals.numSerie, Globals.model);
        scopeCompany = configLoader.getScopeCompany();
        scopeBranch = configLoader.getScopeBranch();
        scopePdv = configLoader.getScopePdv();
        Globals.pinpadOnly = configLoader.isPinpadOnly();
        Main mainInstance = new Main();
        int port = 8888;
        InetSocketAddress address = new InetSocketAddress(port);
        mainInstance.server = new MyWebSocketServer(address, mainInstance);
        mainInstance.webSocketManager = WebSocketManager.getInstance(mainInstance.server);
        mainInstance.server.setConnectionLostTimeout(60);
        mainInstance.server.setReuseAddr(true);
        new Thread(() -> {
            try {
                mainInstance.server.start();
                System.out.println("Servidor WebSocket iniciado na porta " + port);
            }
            catch (Exception e) {
                System.err.println("Erro ao iniciar o servidor WebSocket: " + e.getMessage());
            }
        }).start();
        if (Main.isRunningOnRaspberryPi()) {
            System.out.println("Raspberry Pi detectado - usando GPIO nativo");
            mainInstance.startCounting();
        } else {
            System.out.println("Ambiente de desenvolvimento - iniciando comunica\u00e7\u00e3o ESP32");
            mainInstance.initializeEsp32Communication();
        }
        try {
            System.out.println("Inicializando MQTT para comandos remotos...");
            MqttHelper mqttHelper = MqttHelper.getInstance();
            mqttHelper.initialize();
            System.out.println("MQTT inicializado com sucesso. T\u00f3pico: totem/" + Globals.numSerie + "/command");
        }
        catch (Exception e) {
            System.err.println("Erro ao inicializar MQTT: " + e.getMessage());
            System.err.println("A aplica\u00e7\u00e3o continuar\u00e1 funcionando, mas n\u00e3o receber\u00e1 comandos remotos");
        }
        try {
            System.out.println("Inicializando gerenciador de impressoras...");
            System.out.println("Gerenciador de impressoras inicializado com sucesso");
        }
        catch (Exception e) {
            System.err.println("Erro ao inicializar gerenciador de impressoras: " + e.getMessage());
            System.err.println("A aplica\u00e7\u00e3o continuar\u00e1 funcionando, mas sem monitoramento avan\u00e7ado de impressora");
        }
        System.out.println("\n===== APLICA\u00c7\u00c3O MULTI-TEF INICIADA =====");
        System.out.println("WebSocket Server: porta " + port);
        System.out.println("S\u00e9rie do dispositivo: " + Globals.numSerie);
        System.out.println("Modo Pinpad Only: " + (Globals.pinpadOnly ? "Sim" : "N\u00e3o"));
        System.out.println("=========================================\n");
    }

    public static String getUniqueDeviceId() {
        SystemInfo systemInfo = new SystemInfo();
        StringBuilder deviceId = new StringBuilder();
        try {
            String systemSerial;
            String baseboard = systemInfo.getHardware().getComputerSystem().getBaseboard().getSerialNumber();
            if (baseboard != null && !baseboard.trim().isEmpty()) {
                deviceId.append(baseboard);
            }
            if ((systemSerial = systemInfo.getHardware().getComputerSystem().getSerialNumber()) != null && !systemSerial.trim().isEmpty()) {
                deviceId.append(systemSerial);
            }
            deviceId.append(Main.generateSystemBasedUUID());
            if (deviceId.length() == 0) {
                deviceId.append(Main.generateSystemBasedUUID());
            }
        }
        catch (Exception e) {
            deviceId.append(Main.generateSystemBasedUUID());
        }
        return deviceId.toString().replaceAll("[^a-zA-Z0-9]", "");
    }

    private static String generateSystemBasedUUID() {
        try {
            SystemInfo systemInfo = new SystemInfo();
            StringBuilder fingerprint = new StringBuilder();
            CentralProcessor processor = systemInfo.getHardware().getProcessor();
            fingerprint.append(processor.getProcessorIdentifier().getIdentifier());
            fingerprint.append(processor.getProcessorIdentifier().getName());
            GlobalMemory memory = systemInfo.getHardware().getMemory();
            fingerprint.append(memory.getTotal());
            OperatingSystem os = systemInfo.getOperatingSystem();
            fingerprint.append(os.getManufacturer());
            fingerprint.append(os.getFamily());
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(fingerprint.toString().getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            return String.valueOf(System.currentTimeMillis() + System.nanoTime()).replaceAll("[^0-9]", "");
        }
    }

    private void initializeEsp32Communication() {
        try {
            Thread.sleep(2000L);
            Esp32SerialCommunicator.listAvailablePorts();
            this.esp32SerialCommunicator = Esp32SerialCommunicator.getInstance(this, this, this);
            this.esp32SerialCommunicator.connect();
            System.out.println("Comunica\u00e7\u00e3o ESP32 inicializada - aguardando dados...");
        }
        catch (Exception e) {
            System.err.println("Erro ao inicializar comunica\u00e7\u00e3o ESP32: " + e.getMessage());
        }
    }

    @Override
    public void onDataReceived(String data) {
        System.out.println("Dados recebidos do ESP32: " + data);
        try {
            JSONObject json = new JSONObject(data);
            String command = json.optString("command");
            int value = json.optInt("count");
            String identifier = json.optString("identifier");
            this.processEsp32Data(command, value, identifier);
        }
        catch (Exception e) {
            System.err.println("Erro ao processar JSON do ESP32: " + e.getMessage());
        }
    }

    @Override
    public void onError(String error) {
        System.err.println("Erro na comunica\u00e7\u00e3o ESP32: " + error);
        if (this.webSocketManager != null) {
            this.webSocketManager.sendMessageToAll("ESP32_ERROR", "Problema na comunica\u00e7\u00e3o ESP32: " + error);
        }
    }

    @Override
    public void updateTextView(String type, String message) {
        System.out.println("[ESP32-" + type + "] " + message);
    }

    private void processEsp32Data(String command, int value, String identifier) {
        switch (command) {
            case "count": {
                this.handleEsp32Count(value, value);
                break;
            }
            case "status": {
                this.handleEsp32Status(value, identifier);
                break;
            }
            case "sensor_ready": {
                this.handleEsp32SensorReady(identifier);
                break;
            }
            case "counting_started": {
                this.handleEsp32CountingStarted(value);
                break;
            }
            case "counting_finished": {
                this.handleEsp32CountingFinished(value, identifier);
                break;
            }
            case "money": {
                System.out.println("Money: " + value);
                this.handleEsp32CountingFinished(value, identifier);
                break;
            }
            default: {
                System.out.println("Comando ESP32 desconhecido: " + command);
            }
        }
    }

    private void handleEsp32Count(int count, int value) {
        System.out.println("Contagem ESP32 recebida: " + count + " do sensor: " + value);
        this.onCountingComplete(count);
    }

    private void handleEsp32Status(int value, String identifier) {
        System.out.println("Status ESP32: " + value + " do dispositivo: " + identifier);
        WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Dinheiro R$" + value + ",00");
    }

    private void handleEsp32SensorReady(String identifier) {
        System.out.println("Sensor ESP32 pronto: " + identifier);
        this.webSocketManager.sendMessageToAll("SENSOR_READY", "Sensor " + identifier + " pronto para uso");
    }

    private void handleEsp32CountingStarted(int count) {
        System.out.println("Contagem ESP32 iniciada no sensor: " + count);
        WebSocketManager.getInstance(null).sendMessageToAll("POPUP-MONEY", "Inicio da venda em dinheiro");
    }

    private void handleEsp32CountingFinished(int count, String identifier) {
        System.out.println("Contagem ESP32 finalizada: " + count + " no sensor: " + identifier);
        this.webSocketManager.sendMessageToAll("COUNTING_FINISHED", "Contagem finalizada: " + count);
        this.onCountingComplete(count);
    }

    public void sendEsp32Command(String command, int value, String identifier) {
        if (this.esp32SerialCommunicator != null) {
            this.esp32SerialCommunicator.sendJsonData(command, value, identifier);
            System.out.println("Comando enviado para ESP32: " + command + " = " + value + " (" + identifier + ")");
        } else {
            System.err.println("ESP32 n\u00e3o est\u00e1 conectado");
        }
    }

    public void credit(String value, String phone) {
        if (Globals.tefRuning) {
            this.webSocketManager.sendMessageToAll("STATUS", "Transa\u00e7\u00e3o em andamento");
            return;
        }
        Globals.tefRuning = true;
        this.webSocketManager.sendMessageToAll("STATUS", "Aguarde!");
        Thread creditThread = new Thread(() -> {
            try {
                Payments paymentInstance = new Payments(scopeCompany, scopeBranch, scopePdv);
                try {
                    paymentInstance.credit(value, phone);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Payments.PaymentsException e) {
                WebSocketManager.getInstance(null).sendMessageToAll("CANCELLED", "Falha ao iniciar o pagamento");
            }
        });
        creditThread.start();
    }

    public void debit(String value, String phone) {
        if (Globals.tefRuning) {
            this.webSocketManager.sendMessageToAll("STATUS", "Transa\u00e7\u00e3o em andamento");
            return;
        }
        Globals.tefRuning = true;
        this.webSocketManager.sendMessageToAll("STATUS", "Aguarde!");
        Thread debitThread = new Thread(() -> {
            try {
                Payments paymentInstance = new Payments(scopeCompany, scopeBranch, scopePdv);
                try {
                    paymentInstance.debit(value, phone);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Payments.PaymentsException e) {
                WebSocketManager.getInstance(null).sendMessageToAll("CANCELLED", "Falha ao iniciar o pagamento");
            }
        });
        debitThread.start();
    }

    public void pix(String value, String phone) {
        if (Globals.tefRuning) {
            this.webSocketManager.sendMessageToAll("STATUS", "Transa\u00e7\u00e3o em andamento");
            return;
        }
        Globals.tefRuning = true;
        this.webSocketManager.sendMessageToAll("STATUS", "Aguarde!");
        Thread pixThread = new Thread(() -> {
            try {
                Payments paymentInstance = new Payments(scopeCompany, scopeBranch, scopePdv);
                try {
                    paymentInstance.pix(value, phone);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Payments.PaymentsException e) {
                WebSocketManager.getInstance(null).sendMessageToAll("CANCELLED", "Falha ao iniciar o pagamento");
            }
        });
        pixThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRunningOnRaspberryPi() {
        try {
            int[] typicalRpiGpios;
            File firmwareModel;
            File deviceTreeModel;
            boolean hasBroadcomCpu;
            File cpuInfo = new File("/proc/cpuinfo");
            if (cpuInfo.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(cpuInfo));){
                    String line;
                    boolean hasRaspberryPiHardware = false;
                    hasBroadcomCpu = false;
                    while ((line = reader.readLine()) != null) {
                        File[] lowerLine = line.toLowerCase();
                        if (lowerLine.contains("raspberry pi")) {
                            hasRaspberryPiHardware = true;
                        }
                        if (!lowerLine.contains("bcm27") && !lowerLine.contains("bcm28") && !lowerLine.contains("bcm2835") && !lowerLine.contains("bcm2836") && !lowerLine.contains("bcm2837") && !lowerLine.contains("bcm2711")) continue;
                        hasBroadcomCpu = true;
                    }
                    if (hasRaspberryPiHardware || hasBroadcomCpu) {
                        boolean lowerLine = true;
                        return lowerLine;
                    }
                }
            }
            if ((deviceTreeModel = new File("/proc/device-tree/model")).exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(deviceTreeModel));){
                    String model = reader.readLine();
                    if (model != null && model.toLowerCase().contains("raspberry pi")) {
                        hasBroadcomCpu = true;
                        return hasBroadcomCpu;
                    }
                }
            }
            if ((firmwareModel = new File("/sys/firmware/devicetree/base/model")).exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(firmwareModel));){
                    String model = reader.readLine();
                    if (model != null && model.toLowerCase().contains("raspberry pi")) {
                        boolean lowerLine = true;
                        return lowerLine;
                    }
                }
            }
            File[] raspberryPiFiles = new File[]{new File("/boot/config.txt"), new File("/boot/cmdline.txt"), new File("/opt/vc/bin/vcgencmd"), new File("/usr/bin/raspi-config")};
            int raspberryPiFileCount = 0;
            for (File file : raspberryPiFiles) {
                if (!file.exists()) continue;
                ++raspberryPiFileCount;
            }
            if (raspberryPiFileCount >= 2) {
                return true;
            }
            String arch = System.getProperty("os.arch").toLowerCase();
            String osName = System.getProperty("os.name").toLowerCase();
            if (!osName.contains("linux")) return false;
            if (!arch.contains("arm")) {
                if (!arch.contains("aarch64")) return false;
            }
            File gpioExport = new File("/sys/class/gpio/export");
            File gpioUnexport = new File("/sys/class/gpio/unexport");
            boolean hasTypicalRpiGpios = false;
            for (int gpio : typicalRpiGpios = new int[]{2, 3, 4, 17, 27, 22, 10, 9}) {
                File gpioPin = new File("/sys/class/gpio/gpio" + gpio);
                if (!gpioPin.exists()) continue;
                hasTypicalRpiGpios = true;
                break;
            }
            if (!gpioExport.exists()) return false;
            if (!gpioUnexport.exists()) return false;
            if (!hasTypicalRpiGpios) return false;
            return true;
        }
        catch (Exception e) {
            System.err.println("Erro ao detectar Raspberry Pi: " + e.getMessage());
        }
        return false;
    }

    public static String getDeviceInfo() {
        StringBuilder info;
        block15: {
            info = new StringBuilder();
            try {
                File cpuInfo;
                info.append("OS: ").append(System.getProperty("os.name")).append("\n");
                info.append("Arch: ").append(System.getProperty("os.arch")).append("\n");
                File deviceTreeModel = new File("/proc/device-tree/model");
                if (deviceTreeModel.exists()) {
                    try (BufferedReader reader = new BufferedReader(new FileReader(deviceTreeModel));){
                        String model = reader.readLine();
                        info.append("Device Model: ").append(model != null ? model : "Unknown").append("\n");
                    }
                }
                if (!(cpuInfo = new File("/proc/cpuinfo")).exists()) break block15;
                try (BufferedReader reader = new BufferedReader(new FileReader(cpuInfo));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("Hardware") && !line.startsWith("Model") && !line.startsWith("model name")) continue;
                        info.append("CPU ").append(line).append("\n");
                    }
                }
            }
            catch (Exception e) {
                info.append("Erro ao obter informa\u00e7\u00f5es: ").append(e.getMessage());
            }
        }
        return info.toString();
    }

    public void startCounting() {
        System.out.println("iniciando thread de contagem");
        if (Main.isRunningOnRaspberryPi()) {
            GpioCounter counter = new GpioCounter("538", this);
            Thread counterThread = new Thread(counter);
            counterThread.setDaemon(true);
            counterThread.start();
        } else {
            System.out.println("ESP32 j\u00e1 est\u00e1 aguardando eventos de contagem automaticamente");
            this.webSocketManager.sendMessageToAll("STATUS", "ESP32 aguardando contagem...");
        }
    }

    @Override
    public void onCountingComplete(int count) {
        System.out.println("valor contado: " + count);
        Transaction transactionInstance = new Transaction();
        String value = Integer.toString(count) + "00";
        System.out.println("valor como string: " + value);
        transactionInstance.onTransactionCompleted("PAGAMENTO EM DINHEIRO", "money", value, null, null);
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "Venda concluida");
    }

    public void shutdown() {
        if (this.esp32SerialCommunicator != null) {
            this.esp32SerialCommunicator.disconnect();
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                System.err.println("Erro ao parar servidor WebSocket: " + e.getMessage());
            }
        }
        try {
            MqttHelper mqttHelper = MqttHelper.getInstance();
            mqttHelper.disconnect();
            System.out.println("MQTT desconectado com sucesso");
        }
        catch (Exception e) {
            System.err.println("Erro ao desconectar MQTT: " + e.getMessage());
        }
        try {
            PrinterManager printerManager = PrinterManager.getInstance();
            printerManager.shutdown();
            System.out.println("Gerenciador de impressoras encerrado com sucesso");
        }
        catch (Exception e) {
            System.err.println("Erro ao encerrar gerenciador de impressoras: " + e.getMessage());
        }
    }

    public static class Globals {
        public static boolean pinpadOnly;
        public static boolean tefRuning;
        public static String numSerie;
        public static String model;

        static {
            tefRuning = false;
        }
    }
}

