/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONException;
import org.json.JSONObject;

public class MqttHelper
implements MqttCallbackExtended {
    private static final String TAG = "MqttHelper";
    private static MqttHelper instance;
    private MqttClient client;
    private String brokerUrl = "tcp://mqtt.automizei.com:1883";
    private String clientId = Main.Globals.numSerie;
    private String commandTopic = "totem/" + Main.Globals.numSerie + "/command";
    private ScheduledExecutorService reconnectService = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean isConnected = false;
    private static final String UPDATE_URL = "https://repo.automizei.com/multi-tef/multi-tef.jar";
    private static final String JAR_FILENAME = "multi-tef.jar";
    private static final String BACKUP_SUFFIX = ".backup";
    private static final int MAX_RECONNECT_ATTEMPTS = 10;
    private static final int RECONNECT_DELAY_SECONDS = 30;

    private MqttHelper() {
        this.setupReconnectionService();
    }

    public static synchronized MqttHelper getInstance() {
        if (instance == null) {
            instance = new MqttHelper();
        }
        return instance;
    }

    public void initialize() {
        try {
            this.connect();
        }
        catch (Exception e) {
            System.err.println("MqttHelper: Erro inicial de conex\u00e3o, ser\u00e1 tentada reconex\u00e3o autom\u00e1tica: " + e.getMessage());
        }
    }

    public void connect() throws MqttException {
        if (this.client != null && this.client.isConnected()) {
            System.out.println("MqttHelper: Cliente j\u00e1 conectado");
            return;
        }
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setAutomaticReconnect(false);
        mqttConnectOptions.setCleanSession(true);
        mqttConnectOptions.setUserName("mqtt");
        mqttConnectOptions.setPassword("automizei2023".toCharArray());
        mqttConnectOptions.setConnectionTimeout(30);
        mqttConnectOptions.setKeepAliveInterval(60);
        mqttConnectOptions.setMaxInflight(10);
        try {
            this.client = new MqttClient(this.brokerUrl, this.clientId, new MemoryPersistence());
            this.client.setCallback(this);
            this.client.connect(mqttConnectOptions);
            this.subscribeToCommandTopic();
            this.isConnected = true;
            System.out.println("MqttHelper: Conectado com sucesso e inscrito no t\u00f3pico " + this.commandTopic);
        }
        catch (MqttException e) {
            System.err.println("MqttHelper: Erro ao conectar: " + e.getMessage());
            this.isConnected = false;
            throw e;
        }
    }

    public void disconnect() throws MqttException {
        this.isConnected = false;
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
        }
        if (this.reconnectService != null && !this.reconnectService.isShutdown()) {
            this.reconnectService.shutdown();
        }
    }

    public void publish(String topic, String message) throws MqttException {
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        this.client.publish(topic, mqttMessage);
    }

    public void subscribe(String topic) throws MqttException {
        this.client.subscribe(topic);
    }

    @Override
    public void connectionLost(Throwable cause) {
        System.err.println("MqttHelper: Conex\u00e3o perdida - " + cause.toString());
        this.isConnected = false;
        this.scheduleReconnection();
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String payload = new String(message.getPayload());
        System.out.println("MqttHelper: Mensagem recebida - " + topic + " - " + payload);
        if (this.commandTopic.equals(topic)) {
            this.processCommand(payload);
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        System.out.println("MqttHelper: Delivery complete");
    }

    @Override
    public void connectComplete(boolean reconnect, String serverURI) {
        System.out.println("MqttHelper: Conectado ao broker MQTT - " + serverURI + " (reconex\u00e3o: " + reconnect + ")");
        this.isConnected = true;
        if (reconnect) {
            try {
                this.subscribeToCommandTopic();
                System.out.println("MqttHelper: Reinscri\u00e7\u00e3o no t\u00f3pico de comandos realizada com sucesso");
            }
            catch (Exception e) {
                System.err.println("MqttHelper: Erro ao reinscrever no t\u00f3pico: " + e.getMessage());
            }
        }
    }

    private void subscribeToCommandTopic() throws MqttException {
        if (this.client != null && this.client.isConnected()) {
            this.client.subscribe(this.commandTopic, 1);
            System.out.println("MqttHelper: Inscrito no t\u00f3pico " + this.commandTopic);
        }
    }

    private void processCommand(String payload) {
        try {
            JSONObject json = new JSONObject(payload);
            String command = json.optString("command");
            System.out.println("MqttHelper: Processando comando: " + command);
            if ("update".equals(command)) {
                System.out.println("MqttHelper: Comando de atualiza\u00e7\u00e3o recebido, iniciando processo...");
                this.handleUpdateCommand();
            } else {
                System.out.println("MqttHelper: Comando n\u00e3o reconhecido: " + command);
            }
        }
        catch (JSONException e) {
            System.err.println("MqttHelper: Erro ao processar JSON do comando: " + e.getMessage());
            System.err.println("MqttHelper: Payload recebido: " + payload);
        }
        catch (Exception e) {
            System.err.println("MqttHelper: Erro inesperado ao processar comando: " + e.getMessage());
        }
    }

    private void handleUpdateCommand() {
        Thread updateThread = new Thread(() -> {
            try {
                System.out.println("MqttHelper: Iniciando processo de atualiza\u00e7\u00e3o autom\u00e1tica...");
                File currentJar = new File(JAR_FILENAME);
                File backupJar = new File("multi-tef.jar.backup");
                if (currentJar.exists()) {
                    System.out.println("MqttHelper: Criando backup do arquivo atual...");
                    Files.copy(currentJar.toPath(), backupJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("MqttHelper: Backup criado com sucesso");
                    if (!currentJar.delete()) {
                        System.err.println("MqttHelper: Falha ao remover arquivo atual");
                        return;
                    }
                    System.out.println("MqttHelper: Arquivo atual removido com sucesso");
                } else {
                    System.out.println("MqttHelper: Arquivo atual n\u00e3o encontrado, continuando com download...");
                }
                boolean downloadSuccess = this.downloadNewVersion();
                if (!downloadSuccess) {
                    System.err.println("MqttHelper: Falha no download, restaurando backup...");
                    if (!backupJar.exists()) return;
                    Files.copy(backupJar.toPath(), currentJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    backupJar.delete();
                    System.out.println("MqttHelper: Backup restaurado com sucesso");
                    return;
                }
                System.out.println("MqttHelper: Download conclu\u00eddo com sucesso, encerrando aplica\u00e7\u00e3o...");
                if (backupJar.exists()) {
                    backupJar.delete();
                    System.out.println("MqttHelper: Backup removido ap\u00f3s sucesso do download");
                }
                this.shutdownApplication();
                return;
            }
            catch (Exception e) {
                System.err.println("MqttHelper: Erro durante atualiza\u00e7\u00e3o: " + e.getMessage());
                e.printStackTrace();
                try {
                    File backupJar = new File("multi-tef.jar.backup");
                    File currentJar = new File(JAR_FILENAME);
                    if (!backupJar.exists()) return;
                    if (currentJar.exists()) return;
                    Files.copy(backupJar.toPath(), currentJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    backupJar.delete();
                    System.out.println("MqttHelper: Backup restaurado ap\u00f3s erro");
                    return;
                }
                catch (Exception restoreError) {
                    System.err.println("MqttHelper: Erro ao restaurar backup: " + restoreError.getMessage());
                }
            }
        });
        updateThread.setName("MQTT-Update-Thread");
        updateThread.setDaemon(false);
        updateThread.start();
    }

    /*
     * Exception decompiling
     */
    private boolean downloadNewVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void shutdownApplication() {
        System.out.println("MqttHelper: Iniciando encerramento da aplica\u00e7\u00e3o...");
        Thread shutdownThread = new Thread(() -> {
            try {
                Thread.sleep(2000L);
                System.out.println("MqttHelper: Encerrando aplica\u00e7\u00e3o...");
                System.exit(0);
            }
            catch (InterruptedException e) {
                System.err.println("MqttHelper: Interrup\u00e7\u00e3o durante shutdown: " + e.getMessage());
                System.exit(1);
            }
        });
        shutdownThread.setName("Shutdown-Thread");
        shutdownThread.setDaemon(false);
        shutdownThread.start();
    }

    private void setupReconnectionService() {
        this.reconnectService.scheduleWithFixedDelay(() -> {
            if (!this.isConnected && this.client != null && !this.client.isConnected()) {
                try {
                    System.out.println("MqttHelper: Tentando reconectar...");
                    this.connect();
                }
                catch (Exception e) {
                    System.err.println("MqttHelper: Falha na tentativa de reconex\u00e3o: " + e.getMessage());
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    private void scheduleReconnection() {
        if (this.reconnectService != null && !this.reconnectService.isShutdown()) {
            System.out.println("MqttHelper: Agendando tentativa de reconex\u00e3o em 30 segundos...");
        }
    }

    public boolean isConnected() {
        return this.isConnected && this.client != null && this.client.isConnected();
    }

    public void forceReconnect() {
        try {
            if (this.client != null && this.client.isConnected()) {
                this.client.disconnect();
            }
        }
        catch (Exception e) {
            System.err.println("MqttHelper: Erro ao desconectar para reconex\u00e3o for\u00e7ada: " + e.getMessage());
        }
        try {
            Thread.sleep(1000L);
            this.connect();
        }
        catch (Exception e) {
            System.err.println("MqttHelper: Erro na reconex\u00e3o for\u00e7ada: " + e.getMessage());
        }
    }
}

