/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class MyWebSocketServer
extends WebSocketServer {
    private Main mainInstance;
    private Set<WebSocket> connections = new CopyOnWriteArraySet<WebSocket>();
    private Gson gson = new Gson();
    private boolean cancel = false;

    public MyWebSocketServer(InetSocketAddress address, Main mainInstance) {
        super(address);
        this.mainInstance = mainInstance;
    }

    @Override
    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        this.connections.add(conn);
        System.out.println("New connection: " + handshake.getResourceDescriptor());
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "");
    }

    @Override
    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        this.connections.remove(conn);
        System.out.println("Closed connection to " + String.valueOf(conn.getRemoteSocketAddress()) + " with exit code " + code + " additional info: " + reason);
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
        Message msg = this.gson.fromJson(message, Message.class);
        String type = msg.getType();
        String value = msg.getValue();
        String phone = msg.getPhone();
        this.cancel = false;
        switch (type) {
            case "credit": {
                this.credit(value, phone);
                break;
            }
            case "debit": {
                this.debit(value, phone);
                break;
            }
            case "pix": {
                this.pix(value, phone);
                break;
            }
            case "order": {
                this.order(value);
                break;
            }
            case "money": {
                this.money(phone);
                break;
            }
            case "cancel": {
                this.cancel();
                break;
            }
            default: {
                System.out.println("Unknown message type: " + type);
            }
        }
    }

    @Override
    public void onError(WebSocket conn, Exception ex) {
        if (conn != null) {
            InetSocketAddress remoteAddress = conn.getRemoteSocketAddress();
            if (remoteAddress != null) {
                System.err.println("WebSocket error with remote address: " + String.valueOf(remoteAddress));
            } else {
                System.err.println("WebSocket error with unknown remote address.");
            }
        } else {
            System.err.println("WebSocket error: connection is null.");
        }
        ex.printStackTrace();
    }

    @Override
    public void onStart() {
        System.out.println("Server started successfully");
    }

    public void sendMessageToAll(String type, String message) {
        Message msg = new Message(type, message);
        String jsonMessage = this.gson.toJson(msg);
        for (WebSocket conn : this.connections) {
            conn.send(jsonMessage);
        }
    }

    private void credit(String value, String phone) {
        System.out.println("Processing credit with value: " + value);
        this.mainInstance.credit(value, phone);
    }

    private void debit(String value, String phone) {
        System.out.println("Processing debit with value: " + value);
        this.mainInstance.debit(value, phone);
    }

    private void pix(String value, String phone) {
        this.mainInstance.pix(value, phone);
    }

    private void order(String value) {
        System.out.println("Processing order with value: " + value);
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "Venda concluida");
    }

    private void money(String phone) {
        System.out.println("Money");
    }

    private void cancel() {
        this.cancel = true;
    }

    public boolean getCancel() {
        return this.cancel;
    }
}

