/*
 * Decompiled with CFR 0.152.
 */
import com.itautec.scope.Buffer;
import com.itautec.scope.Scope;
import com.itautec.scope.StParamColeta;

public class Payments {
    private final Scope scope = new Scope();

    public Payments(String company, String branch, String pdv) throws PaymentsException {
        StParamColeta stColeta = new StParamColeta();
        WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Iniciando Pinpad");
        Buffer port_pin = new Buffer();
        this.scope.ppGetCOMPort(port_pin);
        this.scope.ppOpenSecure(2, port_pin.buffer);
        WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Conectando ao servidor");
        long rc = this.scope.open("2", company, branch, pdv);
        if (rc != 0L) {
            for (int retry = 1; retry < 5; ++retry) {
                WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Conectando ao servidor tentativa: " + retry);
                rc = this.scope.open("2", company, branch, pdv);
                if (rc != 0L) continue;
                WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Conectado ao servidor");
                break;
            }
            if (rc != 0L) {
                WebSocketManager.getInstance(null).sendMessageToAll("ERROR", "Falha ao conectar com o servidor");
                throw new PaymentsException("Falha ao conectar com o servidor. C\u00f3digo: " + rc);
            }
        }
        this.scope.setAplColeta();
        this.scope.abreSessaoTEF();
    }

    public void credit(String value, String phone) throws InterruptedException {
        this.scope.compraCartaoCredito(value, "0");
        Transaction transactionInstance = new Transaction();
        WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Aguarde iniciando pagamento!");
        transactionInstance.processTransaction("CREDIT", value, phone);
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "");
    }

    public void debit(String value, String phone) throws InterruptedException {
        Transaction transactionInstance = new Transaction();
        this.scope.compraCartaoDebito(value);
        WebSocketManager.getInstance(null).sendMessageToAll("STATUS", "Aguarde iniciando pagamento!");
        transactionInstance.processTransaction("DEBIT", value, phone);
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "Venda concluida");
    }

    public void pix(String value, String phone) throws InterruptedException {
        this.scope.carteiraVirtualEx2(value, 0, 0, 0);
        Transaction transactionInstance = new Transaction();
        transactionInstance.processTransaction("PIX", value, phone);
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "Venda concluida");
    }

    public void money(String value, String phone) throws InterruptedException {
        Transaction transactionInstance = new Transaction();
        transactionInstance.processTransaction("MONEY", value, phone);
        WebSocketManager.getInstance(null).sendMessageToAll("ORDER-FINISH", "Venda concluida");
    }

    public class PaymentsException
    extends Exception {
        private final long errorCode;

        public PaymentsException(String message) {
            super(message);
            this.errorCode = -1L;
        }

        public PaymentsException(String message, long errorCode) {
            super(message);
            this.errorCode = errorCode;
        }

        public long getErrorCode() {
            return this.errorCode;
        }
    }
}

