/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class PrinterManager {
    private static final String TAG = "PrinterManager";
    private static PrinterManager instance;
    private ScheduledExecutorService globalMonitor;
    private ConcurrentHashMap<String, ESCPosPrinter> activePrinters = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ESCPosPrinter.PrinterStatus> lastKnownStatus = new ConcurrentHashMap();
    private boolean isMonitoring = false;
    private static final int DEFAULT_MONITOR_INTERVAL = 60;
    private static final String DEFAULT_PRINTER = "Printer_POS-80";

    private PrinterManager() {
        this.globalMonitor = Executors.newScheduledThreadPool(2);
    }

    public static synchronized PrinterManager getInstance() {
        if (instance == null) {
            instance = new PrinterManager();
        }
        return instance;
    }

    public void initialize() {
        System.out.println("PrinterManager: Inicializando gerenciador de impressoras...");
        ESCPosPrinter.listAvailablePrinters();
        this.testPrinterConnectivity(DEFAULT_PRINTER);
        this.startGlobalMonitoring();
        System.out.println("PrinterManager: Gerenciador inicializado com sucesso");
    }

    public boolean testPrinterConnectivity(String printerName) {
        try {
            System.out.println("PrinterManager: Testando conectividade com " + printerName);
            ESCPosPrinter testPrinter = new ESCPosPrinter(printerName);
            ESCPosPrinter.PrinterStatus status = testPrinter.getPrinterStatus();
            System.out.println("PrinterManager: Status de " + printerName + ": " + status.getDescription());
            if (status.isError()) {
                System.err.println("PrinterManager: \u26a0\ufe0f Problema detectado: " + status.getDescription());
                System.err.println("PrinterManager: Recomenda\u00e7\u00f5es: " + testPrinter.getStatusRecommendations());
            } else {
                System.out.println("PrinterManager: \u2705 Impressora " + printerName + " est\u00e1 operacional");
            }
            testPrinter.close();
            return !status.isError();
        }
        catch (Exception e) {
            System.err.println("PrinterManager: \u274c Falha ao conectar com " + printerName + ": " + e.getMessage());
            String errorMessage = "Falha ao conectar com impressora " + printerName + ": " + e.getMessage();
            this.publishPrinterError(errorMessage);
            return false;
        }
    }

    public ESCPosPrinter createPrinter(String printerName) throws IOException {
        try {
            ESCPosPrinter printer = new ESCPosPrinter(printerName);
            this.activePrinters.put(printerName, printer);
            this.lastKnownStatus.put(printerName, printer.getPrinterStatus());
            System.out.println("PrinterManager: Impressora " + printerName + " registrada para monitoramento");
            return printer;
        }
        catch (IOException e) {
            String errorMessage = "Erro ao criar impressora " + printerName + ": " + e.getMessage();
            this.publishPrinterError(errorMessage);
            System.err.println("PrinterManager: Erro ao criar impressora " + printerName + ": " + e.getMessage());
            throw e;
        }
    }

    public void releasePrinter(String printerName) {
        ESCPosPrinter printer = this.activePrinters.remove(printerName);
        this.lastKnownStatus.remove(printerName);
        if (printer != null) {
            try {
                printer.close();
                System.out.println("PrinterManager: Impressora " + printerName + " removida do monitoramento");
            }
            catch (Exception e) {
                System.err.println("PrinterManager: Erro ao fechar impressora " + printerName + ": " + e.getMessage());
            }
        }
    }

    public void startGlobalMonitoring() {
        if (this.isMonitoring) {
            System.out.println("PrinterManager: Monitoramento global j\u00e1 ativo");
            return;
        }
        this.isMonitoring = true;
        this.globalMonitor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    PrinterManager.this.monitorAllPrinters();
                }
                catch (Exception e) {
                    System.err.println("PrinterManager: Erro no monitoramento global: " + e.getMessage());
                }
            }
        }, 30L, 60L, TimeUnit.SECONDS);
        System.out.println("PrinterManager: Monitoramento global iniciado (intervalo: 60s)");
    }

    public void stopGlobalMonitoring() {
        if (this.isMonitoring) {
            this.isMonitoring = false;
            for (ESCPosPrinter printer : this.activePrinters.values()) {
                try {
                    printer.stopStatusMonitoring();
                }
                catch (Exception e) {
                    System.err.println("PrinterManager: Erro ao parar monitoramento: " + e.getMessage());
                }
            }
            System.out.println("PrinterManager: Monitoramento global parado");
        }
    }

    private void monitorAllPrinters() {
        if (this.activePrinters.isEmpty()) {
            this.testPrinterConnectivity(DEFAULT_PRINTER);
            return;
        }
        for (String name : this.activePrinters.keySet()) {
            ESCPosPrinter printer = this.activePrinters.get(name);
            try {
                ESCPosPrinter.PrinterStatus lastStatus;
                ESCPosPrinter.PrinterStatus currentStatus = printer.getPrinterStatus();
                if (currentStatus == (lastStatus = this.lastKnownStatus.get(name))) continue;
                System.out.println("PrinterManager: Mudan\u00e7a de status em " + name + ": " + (lastStatus != null ? lastStatus.getDescription() : "desconhecido") + " \u2192 " + currentStatus.getDescription());
                this.lastKnownStatus.put(name, currentStatus);
                if (!currentStatus.isError()) continue;
                this.notifyPrinterIssue(name, currentStatus, printer.getStatusRecommendations());
            }
            catch (Exception e) {
                System.err.println("PrinterManager: Erro ao monitorar impressora " + name + ": " + e.getMessage());
            }
        }
    }

    private void notifyPrinterIssue(String printerName, ESCPosPrinter.PrinterStatus status, String recommendations) {
        try {
            WebSocketManager.getInstance(null).sendMessageToAll("PRINTER_ALERT", "Impressora " + printerName + ": " + status.getDescription() + ". " + recommendations);
            System.err.println("PrinterManager: \ud83d\udea8 ALERTA - " + printerName + ": " + status.getDescription());
            System.err.println("PrinterManager: \ud83d\udca1 Recomenda\u00e7\u00f5es: " + recommendations);
            String errorMessage = "Problema na impressora " + printerName + ": " + status.getDescription() + " - " + recommendations;
            this.publishPrinterError(errorMessage);
        }
        catch (Exception e) {
            System.err.println("PrinterManager: Erro ao notificar problema da impressora: " + e.getMessage());
        }
    }

    private void publishPrinterError(String errorMessage) {
        try {
            MqttHelper mqttHelper = MqttHelper.getInstance();
            if (mqttHelper.isConnected()) {
                String errorTopic = "totem/error";
                JSONObject errorPayload = new JSONObject();
                errorPayload.put("device_id", Main.Globals.numSerie);
                errorPayload.put("value", errorMessage);
                mqttHelper.publish(errorTopic, errorPayload.toString());
                System.out.println("PrinterManager: Erro da impressora enviado via MQTT para " + errorTopic + " - " + errorMessage);
            } else {
                System.err.println("PrinterManager: MQTT n\u00e3o conectado. Erro n\u00e3o enviado: " + errorMessage);
            }
        }
        catch (Exception e) {
            System.err.println("PrinterManager: Falha ao publicar erro da impressora via MQTT: " + e.getMessage());
        }
    }

    public PrinterHealthReport getHealthReport() {
        PrinterHealthReport report = new PrinterHealthReport();
        boolean defaultPrinterOk = this.testPrinterConnectivity(DEFAULT_PRINTER);
        report.defaultPrinterStatus = defaultPrinterOk ? "OK" : "ERRO";
        for (String name : this.activePrinters.keySet()) {
            ESCPosPrinter printer = this.activePrinters.get(name);
            try {
                ESCPosPrinter.PrinterStatus status = printer.getPrinterStatus();
                report.activePrinters.put(name, status.getDescription());
                report.hasErrors = report.hasErrors || status.isError();
            }
            catch (Exception e) {
                report.activePrinters.put(name, "ERRO: " + e.getMessage());
                report.hasErrors = true;
            }
        }
        report.totalActivePrinters = this.activePrinters.size();
        report.monitoringActive = this.isMonitoring;
        return report;
    }

    public void shutdown() {
        System.out.println("PrinterManager: Encerrando gerenciador de impressoras...");
        this.stopGlobalMonitoring();
        for (String name : this.activePrinters.keySet()) {
            ESCPosPrinter printer = this.activePrinters.get(name);
            try {
                printer.close();
            }
            catch (Exception e) {
                System.err.println("PrinterManager: Erro ao fechar " + name + ": " + e.getMessage());
            }
        }
        this.activePrinters.clear();
        this.lastKnownStatus.clear();
        if (this.globalMonitor != null && !this.globalMonitor.isShutdown()) {
            this.globalMonitor.shutdown();
        }
        System.out.println("PrinterManager: Gerenciador encerrado com sucesso");
    }

    public static class PrinterHealthReport {
        public String defaultPrinterStatus = "DESCONHECIDO";
        public ConcurrentHashMap<String, String> activePrinters = new ConcurrentHashMap();
        public int totalActivePrinters = 0;
        public boolean hasErrors = false;
        public boolean monitoringActive = false;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("=== RELAT\u00d3RIO DE SA\u00daDE DAS IMPRESSORAS ===\n");
            sb.append("Impressora Padr\u00e3o (").append(PrinterManager.DEFAULT_PRINTER).append("): ").append(this.defaultPrinterStatus).append("\n");
            sb.append("Impressoras Ativas: ").append(this.totalActivePrinters).append("\n");
            sb.append("Monitoramento: ").append(this.monitoringActive ? "ATIVO" : "INATIVO").append("\n");
            sb.append("Status Geral: ").append(this.hasErrors ? "\u274c PROBLEMAS DETECTADOS" : "\u2705 TUDO OK").append("\n");
            if (!this.activePrinters.isEmpty()) {
                sb.append("\nDetalhes das Impressoras Ativas:\n");
                for (String name : this.activePrinters.keySet()) {
                    String status = this.activePrinters.get(name);
                    sb.append("  - ").append(name).append(": ").append(status).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

