/*
 * Decompiled with CFR 0.152.
 */
package com.itautec.scope;

public class ScopeDadosTransacao {
    private String empresa;
    private String filial;
    private String pos;
    private int codBandeira;
    private int codRede;
    private String codEstabelecimento;
    private String nsu;
    private String dataHoraEstab;
    private String dataAdm;
    private String dataHoraGmt;
    private String valor;
    private String txServico;
    private String valorSaque;
    private String cartao;
    private String dataVencCartao;
    private int numParcelas;
    private String banco;
    private String agencia;
    private String numCheque;
    private String codAutorizacao;
    private String codResp;
    private String nsuHost;
    private int codGrupoServico;
    private int codServico;
    private char statusMsg;
    private char situacaoMsg;
    private boolean digitado;

    public ScopeDadosTransacao(byte[] byArray) {
        this.setEmpresa(this.convert2String(byArray, 0, 5));
        this.setFilial(this.convert2String(byArray, 5, 5));
        this.setPos(this.convert2String(byArray, 10, 4));
        this.setCodBandeira(this.convert2String(byArray, 14, 4));
        this.setCodRede(this.convert2String(byArray, 18, 4));
        this.setCodEstabelecimento(this.convert2String(byArray, 22, 16));
        this.setNsu(this.convert2String(byArray, 38, 7));
        this.setDataHoraEstab(this.convert2String(byArray, 45, 11));
        this.setDataAdm(this.convert2String(byArray, 56, 5));
        this.setDataHoraGmt(this.convert2String(byArray, 61, 11));
        this.setValor(this.convert2String(byArray, 72, 13));
        this.setTxServico(this.convert2String(byArray, 85, 13));
        this.setValorSaque(this.convert2String(byArray, 98, 13));
        this.setCartao(this.convert2String(byArray, 111, 38));
        this.setDataVencCartao(this.convert2String(byArray, 149, 5));
        this.setNumParcelas(this.convert2String(byArray, 154, 3));
        this.setBanco(this.convert2String(byArray, 157, 4));
        this.setAgencia(this.convert2String(byArray, 161, 5));
        this.setNumCheque(this.convert2String(byArray, 166, 13));
        this.setCodAutorizacao(this.convert2String(byArray, 179, 11));
        this.setCodResp(this.convert2String(byArray, 190, 3));
        this.setNsuHost(this.convert2String(byArray, 193, 13));
        this.setCodGrupoServico(this.convert2String(byArray, 206, 3));
        this.setCodServico(this.convert2String(byArray, 209, 4));
        this.setStatusMsg((char)byArray[213]);
        this.setSituacaoMsg((char)byArray[214]);
        this.setDigitado(byArray[215] == 1);
    }

    private String convert2String(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = n + n2; n3 > n && byArray[n3 - 1] == 0; --n3) {
        }
        return new String(byArray, n, n3 - n);
    }

    public String getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(String string) {
        this.empresa = string;
    }

    public String getFilial() {
        return this.filial;
    }

    public void setFilial(String string) {
        this.filial = string;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String string) {
        this.pos = string;
    }

    public int getCodBandeira() {
        return this.codBandeira;
    }

    public void setCodBandeira(int n) {
        this.codBandeira = n;
    }

    private void setCodBandeira(String string) {
        this.codBandeira = Integer.parseInt(string);
    }

    public int getCodRede() {
        return this.codRede;
    }

    public void setCodRede(int n) {
        this.codRede = n;
    }

    private void setCodRede(String string) {
        this.codRede = Integer.parseInt(string);
    }

    public String getCodEstabelecimento() {
        return this.codEstabelecimento;
    }

    public void setCodEstabelecimento(String string) {
        this.codEstabelecimento = string;
    }

    public String getNsu() {
        return this.nsu;
    }

    public void setNsu(String string) {
        this.nsu = string;
    }

    public String getDataHoraEstab() {
        return this.dataHoraEstab;
    }

    public String getDataHoraEstabFormatada() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataHoraEstab.substring(0, 2));
        stringBuilder.append('/');
        stringBuilder.append(this.dataHoraEstab.substring(2, 4));
        stringBuilder.append(' ');
        stringBuilder.append(this.dataHoraEstab.substring(4, 6));
        stringBuilder.append(':');
        stringBuilder.append(this.dataHoraEstab.substring(6, 8));
        stringBuilder.append(':');
        stringBuilder.append(this.dataHoraEstab.substring(8, 10));
        return stringBuilder.toString();
    }

    public void setDataHoraEstab(String string) {
        this.dataHoraEstab = string;
    }

    public String getDataAdm() {
        return this.dataAdm;
    }

    public String getDataAdmFormatada() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataAdm.substring(0, 2));
        stringBuilder.append('/');
        stringBuilder.append(this.dataAdm.substring(2, 4));
        return stringBuilder.toString();
    }

    public String getDataHoraGmtFormatada() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dataHoraGmt.substring(0, 2));
        stringBuilder.append('/');
        stringBuilder.append(this.dataHoraGmt.substring(2, 4));
        stringBuilder.append(' ');
        stringBuilder.append(this.dataHoraGmt.substring(4, 6));
        stringBuilder.append(':');
        stringBuilder.append(this.dataHoraGmt.substring(6, 8));
        stringBuilder.append(':');
        stringBuilder.append(this.dataHoraGmt.substring(8, 10));
        return stringBuilder.toString();
    }

    public void setDataAdm(String string) {
        this.dataAdm = string;
    }

    public String getDataHoraGmt() {
        return this.dataHoraGmt;
    }

    public void setDataHoraGmt(String string) {
        this.dataHoraGmt = string;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(String string) {
        this.valor = string;
    }

    public String getTxServico() {
        return this.txServico;
    }

    public void setTxServico(String string) {
        this.txServico = string;
    }

    public String getValorSaque() {
        return this.valorSaque;
    }

    public void setValorSaque(String string) {
        this.valorSaque = string;
    }

    public String getCartao() {
        return this.cartao;
    }

    public void setCartao(String string) {
        this.cartao = string;
    }

    public String getDataVencCartao() {
        return this.dataVencCartao;
    }

    public void setDataVencCartao(String string) {
        this.dataVencCartao = string;
    }

    public int getNumParcelas() {
        return this.numParcelas;
    }

    public void setNumParcelas(int n) {
        this.numParcelas = n;
    }

    private void setNumParcelas(String string) {
        this.numParcelas = Integer.parseInt(string);
    }

    public String getBanco() {
        return this.banco;
    }

    public void setBanco(String string) {
        this.banco = string;
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String string) {
        this.agencia = string;
    }

    public String getNumCheque() {
        return this.numCheque;
    }

    public void setNumCheque(String string) {
        this.numCheque = string;
    }

    public String getCodAutorizacao() {
        return this.codAutorizacao;
    }

    public void setCodAutorizacao(String string) {
        this.codAutorizacao = string;
    }

    public String getCodResp() {
        return this.codResp;
    }

    public void setCodResp(String string) {
        this.codResp = string;
    }

    public String getNsuHost() {
        return this.nsuHost;
    }

    public void setNsuHost(String string) {
        this.nsuHost = string;
    }

    public int getCodGrupoServico() {
        return this.codGrupoServico;
    }

    public void setCodGrupoServico(int n) {
        this.codGrupoServico = n;
    }

    private void setCodGrupoServico(String string) {
        this.codGrupoServico = Integer.parseInt(string);
    }

    public int getCodServico() {
        return this.codServico;
    }

    public void setCodServico(int n) {
        this.codServico = n;
    }

    private void setCodServico(String string) {
        this.codServico = Integer.parseInt(string);
    }

    public String getStatusMsg() {
        String string = null;
        switch (this.getStatusCode()) {
            case 'P': {
                string = "Pendente";
                break;
            }
            case 'R': {
                string = "Confirmada real-time";
                break;
            }
            case 'M': {
                string = "Confirmada manualmente";
                break;
            }
            case 'A': {
                string = "Confirmada manualmente (pendente de primeira perna)";
                break;
            }
            default: {
                string = "NAO PREVISTO";
            }
        }
        return string;
    }

    public char getStatusCode() {
        return this.statusMsg;
    }

    public void setStatusMsg(char c) {
        this.statusMsg = c;
    }

    public char getSituacaoCode() {
        return this.situacaoMsg;
    }

    public String getSituacaoMsg() {
        String string = null;
        switch (this.getSituacaoCode()) {
            case 'O': {
                string = "OK";
                break;
            }
            case '1': {
                string = "Em andamento";
                break;
            }
            case '2': {
                string = "Pendente";
                break;
            }
            case 'k': {
                string = "Cancelamento pendente";
                break;
            }
            case 'K': {
                string = "Cancelamento";
                break;
            }
            case 'N': {
                string = "N\u00e3o efetuado";
                break;
            }
            case 'D': {
                string = "Desfeito";
                break;
            }
            case 'C': {
                string = "Cancelado";
                break;
            }
            case 'A': {
                string = "Pre-autorizacao confirmada";
                break;
            }
            default: {
                string = "NAO PREVISTO";
            }
        }
        return string;
    }

    public void setSituacaoMsg(char c) {
        this.situacaoMsg = c;
    }

    public boolean isDigitado() {
        return this.digitado;
    }

    public void setDigitado(boolean bl) {
        this.digitado = bl;
    }
}

