/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app;

import com.vaadin.flow.router.PageTitle;
import jakarta.annotation.PostConstruct;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootApplication
@PageTitle(value="NEO SALES - Venda Mais")
@EnableAsync
@EnableScheduling
public class Application {
    public static void main(String[] args) {
        if (System.getenv().containsKey("DEVELOPMENT")) {
            System.setProperty("spring.profiles.active", "cloud");
        } else {
            System.setProperty("spring.profiles.active", "google");
        }
        System.out.println("Profile ativo " + System.getProperty("spring.profiles.active"));
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean(name={"asyncKanban"})
    public Executor asyncJanban() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(3);
        executor.setAllowCoreThreadTimeOut(true);
        executor.setKeepAliveSeconds(3);
        executor.setCorePoolSize(1000);
        executor.setQueueCapacity(1000);
        executor.initialize();
        return executor;
    }

    @Bean(name={"asyncDefault"})
    public Executor asyncDefault() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(3);
        executor.setAllowCoreThreadTimeOut(true);
        executor.setKeepAliveSeconds(3);
        executor.setCorePoolSize(1000);
        executor.setQueueCapacity(500);
        executor.initialize();
        return executor;
    }

    @PostConstruct
    public void setTimeZone() {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Sao_Paulo"));
    }
}

