/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app;

import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.features.broadcast.service.BroadcastNotification;
import br.com.system.app.features.broadcast.service.BroadcastWhatsQrcode;
import br.com.system.app.features.cobranca.service.CobrancaAssinaturaService;
import br.com.system.app.features.estrutura.model.EstruturaComplemento;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaComplementoService;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.menu.Menu;
import br.com.system.app.features.sessions.service.SessionsService;
import br.com.system.app.features.suportnumber.SuportNumberService;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.waha.WahaQrcodeView;
import br.com.system.app.features.waha.service.WahaService;
import br.com.system.app.features.whatsapp.dto.WhatsAppFornecedorEnum;
import br.com.system.app.security.SecurityContext;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Footer;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@JsModule.Container(value={@JsModule(value="@vaadin/vaadin-lumo-styles/badge"), @JsModule(value="@vaadin/vaadin-lumo-styles/presets/compact.js")})
public class MainLayout
extends AppLayout
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private H2 viewTitle;
    private final SessionsService sessionsService;
    private final CobrancaAssinaturaService cas;
    private final WahaService wahaService;
    private final SuportNumberService suportNumber;
    private final EstruturaComplemento compl;
    private Registration broadcasterRegNotification;
    private Registration broadcasterRegQrcode;

    public MainLayout(SessionsService sessionsService, WahaService wahaService, CobrancaAssinaturaService cas, EstruturaComplementoService ecs, SuportNumberService suportNumber) {
        this.wahaService = wahaService;
        this.sessionsService = sessionsService;
        this.cas = cas;
        this.suportNumber = suportNumber;
        this.compl = ecs.getComplementos(this.getEstrutura());
        this.setPrimarySection(AppLayout.Section.DRAWER);
        this.addDrawerContent();
        this.addHeaderContent();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.setDrawerOpened(true);
        this.getElement().setProperty("overlay", false);
        UI ui = attachEvent.getUI();
        EstruturaUsuario eu = this.getEu();
        this.broadcasterRegNotification = BroadcastNotification.register(notification -> {
            if (eu != null && eu.getUsuario().getNotificacaoNaView().booleanValue() && eu.getId().equals(notification.getEstruturaUsuario().getId()) && ui.isAttached()) {
                ui.access((Command & Serializable)() -> UIUtils.showNotification((String)(notification.getAssunto() + "<BR>" + notification.getNotificacao()), (NotificationVariant)NotificationVariant.LUMO_PRIMARY, (Integer)15000, (Notification.Position)Notification.Position.BOTTOM_END));
            }
        });
        this.broadcasterRegQrcode = BroadcastWhatsQrcode.register(whatsappConta -> {
            if (eu != null && eu.getUsuario().getWhatsappConta() != null && eu.getUsuario().getWhatsappConta().getId().equals(whatsappConta.getId()) && ui.isAttached()) {
                ui.access((Command & Serializable)() -> new WahaQrcodeView(eu.getUsuario(), whatsappConta, this.wahaService));
            }
        });
        this.checkWhatsQrcode();
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.broadcasterRegNotification != null) {
            this.broadcasterRegNotification.remove();
        }
        if (this.broadcasterRegQrcode != null) {
            this.broadcasterRegQrcode.remove();
        }
    }

    private void addHeaderContent() {
        DrawerToggle toggle = new DrawerToggle();
        toggle.getElement().setAttribute("aria-label", "Menu toggle");
        this.viewTitle = new H2();
        this.viewTitle.addClassNames(new String[]{"text-s", "m-0", "p-0"});
        FooterContainer fc = new FooterContainer(new Component[]{this.viewTitle, this.createFooter()});
        this.addToNavbar(true, new Component[]{toggle, fc});
    }

    private void addDrawerContent() {
        Scroller scroller = new Scroller((Component)new Menu().create(this.getEu(), this.cas, this.compl));
        this.addToDrawer(new Component[]{scroller});
    }

    private Footer createFooter() {
        Footer layout = new Footer();
        EstruturaUsuario eu = this.getEu();
        if (eu != null && eu.isAtivo()) {
            Usuario user = eu.getUsuario();
            Div divSuporte = new Div();
            divSuporte.getElement().setProperty("innerHTML", "<span><a href=\"https://wa.me/" + this.suportNumber.getForWhats(this.compl.getCobrancaAssinatura().getProprietario()) + "\" data-toggle=\"tooltip\" target=\"_blank\" title=\"Suporte\"><img src=\"images/whats30.png\"></a></span>");
            Div div = new Div();
            div.add(new Component[]{divSuporte});
            div.add(user.getLogin());
            div.add(new Component[]{new Icon("lumo", "dropdown")});
            div.getElement().getStyle().set("display", "flex");
            div.getElement().getStyle().set("align-items", "center");
            div.getElement().getStyle().set("gap", "var(--lumo-space-s)");
            MenuBar menuBarProfile = new MenuBar();
            menuBarProfile.setThemeName("tertiary-inline contrast");
            MenuItem userName = menuBarProfile.addItem("");
            userName.add(new Component[]{div});
            ((SubMenu)userName.getSubMenu()).addItem("Notifica\u00e7\u00f5es", (ComponentEventListener & Serializable)e -> UI.getCurrent().navigate("notificacoes"));
            ((SubMenu)userName.getSubMenu()).addItem("Configura\u00e7\u00f5es", (ComponentEventListener & Serializable)e -> UI.getCurrent().navigate("configuracoes"));
            ((SubMenu)userName.getSubMenu()).addItem("Tarefas", (ComponentEventListener & Serializable)e -> UI.getCurrent().navigate("tasks"));
            ((SubMenu)userName.getSubMenu()).addItem("Encerrar Sess\u00e3o", (ComponentEventListener & Serializable)e -> {
                this.sessionsService.encerrarSessao(UI.getCurrent().getSession().getSession().getId());
                try {
                    VaadinServletRequest.getCurrent().logout();
                    UI.getCurrent().getSession().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            layout.add(new Component[]{menuBarProfile});
        } else {
            this.sessionsService.encerrarSessao(eu);
        }
        return layout;
    }

    private void checkWhatsQrcode() {
        if (this.getUsuario().getWhatsappConta() != null && this.getUsuario().getWhatsappConta().getFornecedor().equals((Object)WhatsAppFornecedorEnum.NEO)) {
            this.wahaService.dispatchQrcode(this.getUsuario().getWhatsappConta(), arg_0 -> this.wahaQrcodeListener(arg_0));
        }
    }

    public void wahaQrcodeListener(Boolean show) {
        ((UI)this.getUI().get()).access((Command & Serializable)() -> new WahaQrcodeView(this.getUsuario(), this.getUsuario().getWhatsappConta(), this.wahaService));
    }

    protected void afterNavigation() {
        super.afterNavigation();
        this.viewTitle.setText(this.getCurrentPageTitle());
    }

    private String getCurrentPageTitle() {
        PageTitle title = this.getContent().getClass().getAnnotation(PageTitle.class);
        return title == null ? "" : title.value();
    }
}

