/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.components;

import br.com.system.app.components.EmojiEnum;
import br.com.system.app.components.containers.Container;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.features.layout.UIUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import java.io.Serializable;
import java.util.function.Consumer;
import org.vaadin.lineawesome.LineAwesomeIcon;

public class EmojiView
extends Container {
    private static final long serialVersionUID = 1L;
    private final Button bPrev = UIUtils.createIconButton((LineAwesomeIcon)LineAwesomeIcon.ARROW_CIRCLE_LEFT_SOLID, (String)"Pagina Anterior");
    private final Button bNext = UIUtils.createIconButton((LineAwesomeIcon)LineAwesomeIcon.ARROW_CIRCLE_RIGHT_SOLID, (String)"Pr\u00f3xima pagina");
    private final Button bClose = UIUtils.createCloseButton();
    private final HorizontalContainer content = new HorizontalContainer(new Component[0]);
    private final EmojiEnum[] emojis = EmojiEnum.values();
    private int page = 0;
    private Consumer<Button> listener;

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    public EmojiView() {
        this.makeScreen();
    }

    private void makeScreen() {
        this.insert(new Component[]{this.content});
        this.getFooter().removeAll();
        this.getFooter().add(new Component[]{this.bClose, this.bPrev, this.bNext});
        this.setHeight("525px");
        this.setWidth("529px");
        this.setHeader("Emojis");
        this.content.getStyle().set("gap", "8px");
        this.bNext.addClickListener((ComponentEventListener & Serializable)e -> {
            this.page = this.page > 19 ? 19 : ++this.page;
            this.showEmojis();
        });
        this.bPrev.addClickListener((ComponentEventListener & Serializable)e -> {
            this.page = this.page <= 0 ? 0 : --this.page;
            this.showEmojis();
        });
        this.bClose.addClickListener((ComponentEventListener & Serializable)e -> this.close());
    }

    public void show(Consumer<Button> listener) {
        this.listener = listener;
        this.page = 0;
        this.showEmojis();
        this.open();
    }

    private void showEmojis() {
        this.content.removeAll();
        for (int i = this.page * 100; i <= this.page * 100 + 99; ++i) {
            if (i > this.emojis.length - 1) {
                return;
            }
            Button b = UIUtils.createButton((String)this.emojis[i].toString(), (String)"", (ButtonVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
            b.getStyle().set("font-size", "23px");
            b.setTooltipText(this.emojis[i].name());
            b.setId(this.emojis[i].name());
            b.addClickListener((ComponentEventListener & Serializable)e -> this.listener.accept(b));
            this.content.add(new Component[]{b});
        }
    }
}

