/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.bots.service;

import br.com.system.app.features.analisefatura.model.BotTypeEnum;
import br.com.system.app.features.bots.model.BotProcess;
import br.com.system.app.features.bots.repository.BotProcessRepository;
import br.com.system.commons.SleepUtil;
import java.io.Serializable;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BotService
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private BotProcessRepository repository;

    public void waitProcess(BotTypeEnum type) {
        for (int retry = 0; retry <= 60; ++retry) {
            if (!this.haveProcess(type)) {
                return;
            }
            SleepUtil.inSeconds((Integer)5);
        }
        this.stopProcess(type);
    }

    public void stopProcess(BotTypeEnum type) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet) {
            if (!thread.getName().contains(type.name())) continue;
            thread.interrupt();
        }
    }

    public boolean haveProcess(BotTypeEnum type) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet) {
            if (!thread.getName().contains(type.name())) continue;
            return true;
        }
        return false;
    }

    public void deleteByProcessType(BotTypeEnum type) {
        this.repository.deleteByProcessType(type);
    }

    public BotProcess save(BotProcess process) {
        return (BotProcess)this.repository.save((Object)process);
    }

    public BotProcess getByProcess(String processName) {
        return this.repository.findByProcessName(processName);
    }
}

