/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.service;

import br.com.system.app.features.cep.model.CepLocalidade;
import br.com.system.app.features.cep.model.CepUf;
import br.com.system.app.features.cep.service.CepService;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteClassificacao;
import br.com.system.app.features.cliente.model.ClienteContato;
import br.com.system.app.features.cliente.model.ClienteFornecedor;
import br.com.system.app.features.cliente.model.ClienteProduto;
import br.com.system.app.features.cliente.model.ClienteProdutoCadastro;
import br.com.system.app.features.cliente.model.ClienteResponsavel;
import br.com.system.app.features.cliente.model.TipoContatoEnum;
import br.com.system.app.features.cliente.service.ClienteProdutoService;
import br.com.system.app.features.cliente.service.ClienteService;
import br.com.system.app.features.estrutura.model.EstruturaTipoEnum;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.estrutura.service.EstruturaUsuarioService;
import br.com.system.app.features.notificacoes.service.NotificacoesService;
import br.com.system.app.features.shared.exception.BusinessException;
import br.com.system.app.features.usuario.model.Usuario;
import br.com.system.app.features.usuario.service.UsuarioService;
import br.com.system.app.features.util.ExcellUtil;
import br.com.system.commons.StringUtil;
import br.com.system.commons.TelefoneUtil;
import br.com.system.commons.ValidationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClienteImportacaoThread
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private NotificacoesService notificacoesService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private CepService cepService;
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private EstruturaUsuarioService eus;
    @Autowired
    private ClienteProdutoService clienteProdutoService;

    public String importar(HashMap<String, Integer> colunas, InputStream conteudo, String nomeArquivo, EstruturaUsuario eu) {
        Thread.currentThread().setName("asyncDefault-cliente-importacao");
        StringBuilder log = new StringBuilder();
        XSSFWorkbook xls = null;
        try {
            xls = new XSSFWorkbook(conteudo);
            Sheet aba = xls.getSheetAt(0);
            for (int r = 0; r <= aba.getLastRowNum(); ++r) {
                Object obs = "";
                Row row = aba.getRow(r);
                if (row == null || this.getCellValue(colunas, "CNPJ", row).contains("CNPJ")) continue;
                String cnpj = StringUtil.normalizeCpfCnpj((String)this.getCellValue(colunas, "CNPJ", row));
                if ((cnpj = StringUtil.numbersOnly((String)cnpj)).isEmpty()) continue;
                try {
                    if (!ValidationUtil.isValidCnpjAndCpf((String)cnpj)) {
                        log.append(cnpj).append(" inv\u00e1lido ").append("<BR>");
                        continue;
                    }
                    HashSet<ClienteContato> contatos = new HashSet<ClienteContato>();
                    for (int i = 0; i < colunas.size(); ++i) {
                        String telefone;
                        String email = this.getCellValue(colunas, "E-MAIL " + i, row);
                        if (ValidationUtil.isValidEmail((String)email)) {
                            contatos.add(new ClienteContato(TipoContatoEnum.EMAIL, email));
                        }
                        if (!TelefoneUtil.isValid((String)(telefone = this.getCellValue(colunas, "TELEFONE " + i, row)))) continue;
                        contatos.add(new ClienteContato(TipoContatoEnum.TELEFONE, telefone));
                    }
                    String nome = this.getCellValue(colunas, "NOME", row);
                    Cliente cliente = this.clienteService.getAndCreateCliente(eu, cnpj, nome, contatos);
                    String tags = this.getCellValue(colunas, "TAGS", row);
                    String logins = this.getCellValue(colunas, "LOGIN_RESPONSAVEL(is)", row);
                    String cep = StringUtil.numbersOnly((String)this.getCellValue(colunas, "CEP", row));
                    String logradouro = this.getCellValue(colunas, "LOGRADOURO", row);
                    String nro = this.getCellValue(colunas, "NRO", row);
                    String bairro = this.getCellValue(colunas, "BAIRRO", row);
                    String cidade = this.getCellValue(colunas, "CIDADE", row);
                    String estado = this.getCellValue(colunas, "ESTADO", row);
                    String observacoes = this.getCellValue(colunas, "DADOS COMPLEMENTARES", row);
                    ClienteClassificacao classificacao = this.clienteService.getByNome(eu.getEstrutura().getEstruturaTipo(), this.getCellValue(colunas, "CLASSIFICA\u00c7\u00c3O", row));
                    String tempoMedio = this.getCellValue(colunas, "TEMPO M\u00c9DIO", row);
                    String fornecedor = this.getCellValue(colunas, "FORNECEDOR", row);
                    String produto = this.getCellValue(colunas, "PRODUTO", row);
                    String quantidade = this.isTicket(eu) ? this.getCellValue(colunas, "COLABORADORES", row) : this.getCellValue(colunas, "QUANTIDADE", row);
                    String valor = this.isTicket(eu) ? this.getCellValue(colunas, "VALOR_DIA", row) : this.getCellValue(colunas, "VALOR", row);
                    String nroDias = this.getCellValue(colunas, "NRO_DIAS", row);
                    String desagio = this.getCellValue(colunas, "DESAGIO", row);
                    LocalDate ativacao = this.getCellDate(colunas, "DATA ATIVA\u00c7\u00c3O", row);
                    LocalDate fidelidade = this.getCellDate(colunas, "DATA FIDELIDADE", row);
                    if (!cliente.getClienteResponsavel().isEmpty() && !logins.isBlank()) {
                        cliente.getClienteResponsavel().clear();
                        cliente = this.clienteService.salvar(cliente, eu);
                    }
                    obs = (String)obs + this.setReponsaveis(eu, cliente, logins);
                    if (!nome.isBlank()) {
                        cliente.setNome(nome.trim().toUpperCase());
                    }
                    if (!tags.isBlank()) {
                        cliente.setTags(StringUtil.normalizeTags((String)tags));
                    }
                    if (cep.length() == 8) {
                        cliente.setCep(cep);
                    }
                    if (!logradouro.isBlank()) {
                        cliente.setLogradouro(logradouro);
                    }
                    if (!nro.isBlank()) {
                        cliente.setNumero(nro);
                    }
                    if (!bairro.isBlank()) {
                        cliente.setBairro(bairro);
                    }
                    if (!cidade.isEmpty() && estado.isBlank()) {
                        obs = (String)obs + "(Faltou a UF da cidade, n\u00e3o atualizado)";
                    }
                    if (!observacoes.isBlank()) {
                        cliente.setObservacao(observacoes);
                    }
                    if (classificacao != null) {
                        cliente.setClienteClassificacao(classificacao);
                    }
                    if (tempoMedio != null && !tempoMedio.isBlank()) {
                        cliente.setTempoMedio(Integer.valueOf(StringUtil.toInt((String)tempoMedio)));
                    }
                    if (!cidade.isBlank() && !estado.isBlank()) {
                        CepUf cepUf = this.cepService.getUfBySigla(estado);
                        if (cepUf == null) {
                            obs = (String)obs + "(ESTADO n\u00e3o encontrado)";
                        } else {
                            CepLocalidade loc = this.cepService.getLocalidadeByNome(cepUf, cidade);
                            if (loc == null) {
                                obs = (String)obs + "(CIDADE n\u00e3o encontrada)";
                            } else {
                                cliente.setCidade(cidade);
                                cliente.setEstado(estado);
                            }
                        }
                    }
                    cliente = this.clienteService.salvar(cliente, eu);
                    log.append("CNPJ: ").append(cnpj).append(" importado ").append((String)obs).append("<BR> ");
                    if (!fornecedor.isBlank() && !produto.isBlank()) {
                        ClienteFornecedor clienteFornecedor = this.clienteProdutoService.getFornecedorByNome(eu.getEstrutura().getEstruturaTipo(), fornecedor);
                        ClienteProdutoCadastro produtoCadastro = this.clienteProdutoService.getProdutoByNome(eu.getEstrutura().getEstruturaTipo(), produto);
                        if (clienteFornecedor != null && produtoCadastro != null) {
                            ClienteProduto p = this.clienteProdutoService.getByClienteAndFornecedorAndProduto(cliente, clienteFornecedor, produtoCadastro);
                            if (p == null) {
                                p = new ClienteProduto();
                                p.setClienteFornecedor(clienteFornecedor);
                                p.setClienteProdutoCadastro(produtoCadastro);
                                p.setCliente(cliente);
                            }
                            if (quantidade != null && !quantidade.isBlank()) {
                                p.setQuantidade(Integer.valueOf(StringUtil.toInt((String)quantidade)));
                            }
                            if (valor != null && !valor.isBlank()) {
                                p.setValor(BigDecimal.valueOf(Double.parseDouble(valor)));
                            }
                            if (nroDias != null && !nroDias.isEmpty()) {
                                p.setQuantidadeDias(Integer.valueOf(nroDias));
                            }
                            if (desagio != null && !desagio.isEmpty()) {
                                p.setDesconto(BigDecimal.valueOf(Double.parseDouble(desagio)));
                            }
                            if (ativacao != null) {
                                p.setDataAtivacao(ativacao);
                            }
                            if (fidelidade != null) {
                                p.setDataFidelidade(fidelidade);
                            }
                            this.clienteProdutoService.salvar(p, eu);
                            p = null;
                        }
                        clienteFornecedor = null;
                        produtoCadastro = null;
                    }
                }
                catch (Exception eItem) {
                    log.append("CNPJ: ").append(cnpj).append(" ERRO: ").append(eItem.getMessage()).append("<BR>");
                }
                row = null;
            }
        }
        catch (IOException e) {
            throw new BusinessException("Erro ao processar arquivo: " + e.getMessage());
        }
        finally {
            try {
                xls.close();
                colunas.clear();
                conteudo.close();
                xls = null;
                colunas = null;
                conteudo = null;
            }
            catch (Exception exception) {}
        }
        if (log.toString().isEmpty()) {
            log.append("Arquivo sem conte\u00fado v\u00e1lido");
        }
        this.notificacoesService.notify(eu, "Importando clientes do arquivo " + nomeArquivo, log.toString());
        return log.toString();
    }

    private String getCellValue(HashMap<String, Integer> colunas, String columName, Row row) {
        Integer posicao = this.getPosition(colunas, columName, row);
        if (posicao < 0) {
            return "";
        }
        Cell cell = row.getCell(posicao.intValue());
        return ExcellUtil.getValueString((Cell)cell).trim();
    }

    public LocalDate getCellDate(HashMap<String, Integer> colunas, String columName, Row row) {
        try {
            Integer posicao = this.getPosition(colunas, columName, row);
            if (posicao < 0) {
                return null;
            }
            return row.getCell(posicao.intValue()).getDateCellValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer getPosition(HashMap<String, Integer> colunas, String columName, Row row) {
        Integer posicao = -1;
        for (Map.Entry<String, Integer> entry : colunas.entrySet()) {
            String key = entry.getKey();
            if (!key.equals(columName)) continue;
            posicao = entry.getValue();
            break;
        }
        if (posicao == null || posicao < 0) {
            return -1;
        }
        if (row.getCell(posicao.intValue()) == null) {
            return -1;
        }
        return posicao;
    }

    private String setReponsaveis(EstruturaUsuario eu, Cliente cliente, String logins) {
        Object obs = "";
        if (logins.isBlank()) {
            return "";
        }
        for (String login : logins.split(",")) {
            Usuario u = this.usuarioService.getByLogin(login);
            if (u != null) {
                Optional optionEu = this.eus.getByUsuarioAndEstrutura(u, eu.getEstrutura());
                if (optionEu.isPresent()) {
                    cliente.getClienteResponsavel().add(new ClienteResponsavel(cliente, (EstruturaUsuario)optionEu.get()));
                    continue;
                }
                obs = (String)obs + "(" + login + " N\u00e3o encontrado)<BR>";
                continue;
            }
            obs = (String)obs + "(" + login + " N\u00e3o encontrado)<BR>";
        }
        return obs;
    }

    private boolean isTicket(EstruturaUsuario eu) {
        return EstruturaTipoEnum.getById((Long)eu.getEstrutura().getEstruturaTipo().getId()).equals((Object)EstruturaTipoEnum.TICKET);
    }
}

