/*
 * Decompiled with CFR 0.152.
 */
package br.com.system.app.features.cliente.view;

import br.com.system.app.components.ConfirmationDialog;
import br.com.system.app.components.DownloadDialog;
import br.com.system.app.components.containers.FooterContainer;
import br.com.system.app.components.containers.HorizontalContainer;
import br.com.system.app.components.containers.VerticalContainer;
import br.com.system.app.features.cliente.model.Cliente;
import br.com.system.app.features.cliente.model.ClienteAnexo;
import br.com.system.app.features.cliente.service.ClienteAnexoService;
import br.com.system.app.features.estrutura.model.EstruturaUsuario;
import br.com.system.app.features.layout.UIUtils;
import br.com.system.app.features.util.TempFileMultiBuffer;
import br.com.system.app.security.SecurityContext;
import br.com.system.commons.FileUtil;
import br.com.system.commons.datetime.FormatDate;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ClienteAnexoView
extends Dialog
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private final ClienteAnexoService clienteAnexoService;
    private final Cliente cliente;
    private Grid<ClienteAnexo> grid;
    private final EstruturaUsuario eu;
    private List<ClienteAnexo> lista;
    private DownloadDialog dd;

    public ClienteAnexoView(Cliente cliente, EstruturaUsuario eu, ClienteAnexoService clienteAnexoService) {
        this.clienteAnexoService = clienteAnexoService;
        this.cliente = cliente;
        this.eu = eu;
        if (this.hasPermission("CLIENTE_ANEXO_VIEW")) {
            this.init();
        } else {
            UIUtils.showNotification((String)"Voc\u00ea n\u00e3o tem Permiss\u00e3o para visualisar anexos");
        }
    }

    private void init() {
        this.dd = new DownloadDialog();
        this.setWidth("900px");
        TempFileMultiBuffer buffer = new TempFileMultiBuffer();
        Upload upload = new Upload((Receiver)buffer);
        upload.setMaxFiles(30);
        Button btnGravar = UIUtils.createSmallButton((String)"Gravar", (VaadinIcon)VaadinIcon.INBOX);
        btnGravar.addClickListener((ComponentEventListener & Serializable)e -> {
            if (!this.hasPermission("CLIENTE_ANEXO_SAVE")) {
                UIUtils.showNotification((String)"Sem permiss\u00e3o para incluir novos arquivos.");
                return;
            }
            if (buffer.getFiles().size() <= 0) {
                UIUtils.showNotification((String)"N\u00e3o h\u00e1 arquivos para gravar.");
                return;
            }
            this.clienteAnexoService.save(this.cliente, this.eu, buffer);
            upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
            buffer.clear();
            this.povoa();
        });
        Button btnFechar = UIUtils.createSmallButton((String)"Fechar", (VaadinIcon)VaadinIcon.CLOSE);
        btnFechar.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        Button btnDown = UIUtils.createButton((String)"Baixar Todos", (String)"Baixar todos os arquivos em ZIP", (ButtonVariant[])new ButtonVariant[0]);
        btnDown.addClickListener((ComponentEventListener & Serializable)e -> this.dd.open(this.clienteAnexoService.getZip(this.lista), "Cliente-anexo.zip", true));
        this.add(new Component[]{new VerticalContainer(new Component[]{upload, this.createGrid(), new FooterContainer(new Component[]{btnFechar, btnDown, btnGravar})})});
        this.open();
    }

    private void povoa() {
        this.lista = this.clienteAnexoService.getAnexo(this.cliente);
        this.grid.setItems((Collection)this.lista);
    }

    private HorizontalContainer createGrid() {
        this.grid = new Grid(ClienteAnexo.class);
        this.grid.setColumns(new String[0]);
        this.grid.setWidth("890px");
        if (this.hasPermission("CLIENTE_ANEXO_DELETE")) {
            this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
                Button btn = UIUtils.createSmallButton((VaadinIcon)VaadinIcon.TRASH, (String)"Excluir anexo do cliente");
                btn.addClickListener((ComponentEventListener & Serializable)del -> {
                    ConfirmationDialog cd = new ConfirmationDialog("Exclus\u00e3o", "Confirma exclus\u00e3o do anexo?");
                    cd.getCancel().addClickListener((ComponentEventListener & Serializable)cancel -> cd.close());
                    cd.getConfirm().addClickListener((ComponentEventListener & Serializable)conf -> {
                        try {
                            this.clienteAnexoService.delete(eg);
                        }
                        catch (Exception e) {
                            UIUtils.showError((String)("Erro ao excluir anexo " + e.getMessage()));
                        }
                        cd.close();
                        this.povoa();
                    });
                });
                return btn;
            })).setFlexGrow(0).setWidth("50px");
        }
        this.grid.addColumn("nomeArquivo").setFlexGrow(0).setWidth("250px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getDataHora().format(FormatDate.DATETIME_BR.toDTF()))).setFlexGrow(0).setWidth("180px");
        this.grid.addColumn((Renderer)new TextRenderer((ItemLabelGenerator & Serializable)p -> p.getEstruturaUsuario().getUsuario().getNome())).setFlexGrow(0).setWidth("180px").setHeader("Usu\u00e1rio");
        this.grid.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)eg -> {
            Button b = UIUtils.createSmallButton((String)"Download");
            b.setVisible(eg.getHashArquivo() != null && !eg.getHashArquivo().isEmpty());
            b.addClickListener((ComponentEventListener & Serializable)e -> {
                ClienteAnexo pa = eg;
                String extensao = FileUtil.getExtension((String)pa.getNomeArquivo());
                String url = pa.getHashArquivo().endsWith(extensao) ? pa.getHashArquivo() : pa.getHashArquivo() + extensao;
                this.dd.open(url, pa.getNomeArquivo());
            });
            return b;
        })).setFlexGrow(0).setWidth("150px");
        this.povoa();
        return new HorizontalContainer(new Component[]{this.grid});
    }
}

